/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2.params;

import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.api.v2.params.ImmutableParsedReference;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Detached;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;

@Value.Immutable
public interface ParsedReference {
    @Nullable
    @Value.Parameter(order=1)
    public String name();

    @Nullable
    @Value.Parameter(order=2)
    public String hash();

    @Nullable
    @Value.Parameter(order=3)
    public Reference.ReferenceType type();

    @Value.Check
    default public void check() {
        if (this.hash() == null && this.name() == null) {
            throw new IllegalStateException("Either name or hash or name and hash must be supplied");
        }
    }

    public static ParsedReference parsedReference(@Nullable String name, @Nullable String hash, @Nullable Reference.ReferenceType type) {
        if (hash != null && name == null) {
            name = "DETACHED";
        }
        return ImmutableParsedReference.of(name, hash, type);
    }

    @Value.NonAttribute
    default public Reference toReference() {
        Reference.ReferenceType t2 = this.type();
        if (t2 == null) {
            if ("DETACHED".equals(this.name())) {
                return Detached.of(this.hash());
            }
            throw new IllegalArgumentException("Cannot convert a name to a typed reference without a type");
        }
        switch (t2) {
            case BRANCH: {
                return Branch.of(this.name(), this.hash());
            }
            case TAG: {
                return Tag.of(this.name(), this.hash());
            }
        }
        throw new IllegalArgumentException("Unsupported reference type: " + (Object)((Object)this.type()));
    }
}

