/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.util.JsonUtil;
import org.apache.iceberg.view.ImmutableSQLViewRepresentation;
import org.apache.iceberg.view.SQLViewRepresentation;

class SQLViewRepresentationParser {
    private static final String SQL = "sql";
    private static final String DIALECT = "dialect";
    private static final String SCHEMA_ID = "schema-id";
    private static final String DEFAULT_CATALOG = "default-catalog";
    private static final String DEFAULT_NAMESPACE = "default-namespace";
    private static final String FIELD_ALIASES = "field-aliases";
    private static final String FIELD_COMMENTS = "field-comments";

    private SQLViewRepresentationParser() {
    }

    static String toJson(SQLViewRepresentation sqlViewRepresentation) {
        return JsonUtil.generate(gen -> SQLViewRepresentationParser.toJson(sqlViewRepresentation, gen), false);
    }

    static void toJson(SQLViewRepresentation view, JsonGenerator generator) throws IOException {
        Preconditions.checkArgument(view != null, "Invalid SQL view representation: null");
        generator.writeStartObject();
        generator.writeStringField("type", view.type());
        generator.writeStringField(SQL, view.sql());
        generator.writeStringField(DIALECT, view.dialect());
        if (view.defaultCatalog() != null) {
            generator.writeStringField(DEFAULT_CATALOG, view.defaultCatalog());
        }
        if (view.defaultNamespace() != null) {
            JsonUtil.writeStringArray(DEFAULT_NAMESPACE, Arrays.asList(view.defaultNamespace().levels()), generator);
        }
        if (!view.fieldAliases().isEmpty()) {
            JsonUtil.writeStringArray(FIELD_ALIASES, view.fieldAliases(), generator);
        }
        if (!view.fieldComments().isEmpty()) {
            JsonUtil.writeStringArray(FIELD_COMMENTS, view.fieldComments(), generator);
        }
        generator.writeEndObject();
    }

    static SQLViewRepresentation fromJson(String json) {
        return JsonUtil.parse(json, SQLViewRepresentationParser::fromJson);
    }

    static SQLViewRepresentation fromJson(JsonNode node) {
        List<String> fieldComments;
        List<String> fieldAliases;
        Preconditions.checkArgument(node != null, "Cannot parse SQL view representation from null object");
        Preconditions.checkArgument(node.isObject(), "Cannot parse SQL view representation from non-object: %s", (Object)node);
        ImmutableSQLViewRepresentation.Builder builder = ImmutableSQLViewRepresentation.builder().sql(JsonUtil.getString(SQL, node)).dialect(JsonUtil.getString(DIALECT, node));
        String defaultCatalog = JsonUtil.getStringOrNull(DEFAULT_CATALOG, node);
        if (defaultCatalog != null) {
            builder.defaultCatalog(defaultCatalog);
        }
        Integer schemaId = JsonUtil.getIntOrNull(SCHEMA_ID, node);
        List<String> namespace = JsonUtil.getStringListOrNull(DEFAULT_NAMESPACE, node);
        if (namespace != null && !namespace.isEmpty()) {
            builder.defaultNamespace(Namespace.of(Iterables.toArray(namespace, String.class)));
        }
        if ((fieldAliases = JsonUtil.getStringListOrNull(FIELD_ALIASES, node)) != null) {
            builder.fieldAliases(fieldAliases);
        }
        if ((fieldComments = JsonUtil.getStringListOrNull(FIELD_COMMENTS, node)) != null) {
            builder.fieldComments(fieldComments);
        }
        return builder.build();
    }
}

