/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.orc.impl;

import java.nio.ByteBuffer;
import org.apache.iceberg.shaded.org.apache.orc.storage.common.io.DiskRange;
import org.apache.iceberg.shaded.org.apache.orc.storage.common.io.DiskRangeList;

public class BufferChunk
extends DiskRangeList {
    private ByteBuffer chunk;

    public BufferChunk(long offset, int length) {
        super(offset, offset + (long)length);
        this.chunk = null;
    }

    public BufferChunk(ByteBuffer chunk, long offset) {
        super(offset, offset + (long)chunk.remaining());
        this.chunk = chunk;
    }

    public void setChunk(ByteBuffer chunk) {
        this.chunk = chunk;
    }

    @Override
    public boolean hasData() {
        return this.chunk != null;
    }

    @Override
    public final String toString() {
        if (this.chunk == null) {
            return "data range[" + this.offset + ", " + this.end + ")";
        }
        boolean makesSense = (long)this.chunk.remaining() == this.end - this.offset;
        return "data range [" + this.offset + ", " + this.end + "), size: " + this.chunk.remaining() + (makesSense ? "" : "(!)") + " type: " + (this.chunk.isDirect() ? "direct" : "array-backed");
    }

    @Override
    public DiskRange sliceAndShift(long offset, long end, long shiftBy) {
        assert (offset <= end && offset >= this.offset && end <= this.end);
        assert (offset + shiftBy >= 0L);
        ByteBuffer sliceBuf = this.chunk.slice();
        int newPos = (int)(offset - this.offset);
        int newLimit = newPos + (int)(end - offset);
        try {
            sliceBuf.position(newPos);
            sliceBuf.limit(newLimit);
        }
        catch (Throwable t2) {
            throw new RuntimeException("Failed to slice buffer chunk with range [" + this.offset + ", " + this.end + "), position: " + this.chunk.position() + " limit: " + this.chunk.limit() + ", " + (this.chunk.isDirect() ? "direct" : "array") + "; to [" + offset + ", " + end + ") " + t2.getClass(), t2);
        }
        return new BufferChunk(sliceBuf, offset + shiftBy);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        BufferChunk ob = (BufferChunk)other;
        return this.chunk.equals(ob.chunk);
    }

    @Override
    public int hashCode() {
        return this.chunk.hashCode();
    }

    @Override
    public ByteBuffer getData() {
        return this.chunk;
    }
}

