/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.impl.EnglishReasonPhraseCatalog;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.iceberg.IcebergBuild;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.exceptions.RESTException;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.ErrorHandler;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.RESTObjectMapper;
import org.apache.iceberg.rest.RESTRequest;
import org.apache.iceberg.rest.RESTResponse;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.iceberg.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPClient
implements RESTClient {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPClient.class);
    private static final String SIGV4_ENABLED = "rest.sigv4-enabled";
    private static final String SIGV4_REQUEST_INTERCEPTOR_IMPL = "org.apache.iceberg.aws.RESTSigV4Signer";
    @VisibleForTesting
    static final String CLIENT_VERSION_HEADER = "X-Client-Version";
    @VisibleForTesting
    static final String CLIENT_GIT_COMMIT_SHORT_HEADER = "X-Client-Git-Commit-Short";
    private final String uri;
    private final CloseableHttpClient httpClient;
    private final ObjectMapper mapper;

    private HTTPClient(String uri, Map<String, String> baseHeaders, ObjectMapper objectMapper, HttpRequestInterceptor requestInterceptor) {
        this.uri = uri;
        this.mapper = objectMapper;
        HttpClientBuilder clientBuilder = HttpClients.custom();
        if (baseHeaders != null) {
            clientBuilder.setDefaultHeaders(baseHeaders.entrySet().stream().map(e -> new BasicHeader((String)e.getKey(), e.getValue())).collect(Collectors.toList()));
        }
        if (requestInterceptor != null) {
            clientBuilder.addRequestInterceptorLast(requestInterceptor);
        }
        this.httpClient = clientBuilder.build();
    }

    private static String extractResponseBodyAsString(CloseableHttpResponse response) {
        try {
            if (response.getEntity() == null) {
                return null;
            }
            return EntityUtils.toString(response.getEntity(), "UTF-8");
        }
        catch (IOException | ParseException e) {
            throw new RESTException(e, "Failed to convert HTTP response body to string", new Object[0]);
        }
    }

    private static boolean isSuccessful(CloseableHttpResponse response) {
        int code = response.getCode();
        return code == 200 || code == 202 || code == 204;
    }

    private static ErrorResponse buildDefaultErrorResponse(CloseableHttpResponse response) {
        String responseReason = response.getReasonPhrase();
        String message = responseReason != null && !responseReason.isEmpty() ? responseReason : EnglishReasonPhraseCatalog.INSTANCE.getReason(response.getCode(), null);
        String type = "RESTException";
        return ErrorResponse.builder().responseCode(response.getCode()).withMessage(message).withType(type).build();
    }

    private static void throwFailure(CloseableHttpResponse response, String responseBody, Consumer<ErrorResponse> errorHandler) {
        ErrorResponse errorResponse = null;
        if (responseBody != null) {
            try {
                if (errorHandler instanceof ErrorHandler) {
                    errorResponse = ((ErrorHandler)errorHandler).parseResponse(response.getCode(), responseBody);
                } else {
                    LOG.warn("Unknown error handler {}, response body won't be parsed", (Object)errorHandler.getClass().getName());
                    errorResponse = ErrorResponse.builder().responseCode(response.getCode()).withMessage(responseBody).build();
                }
            }
            catch (UncheckedIOException | IllegalArgumentException e) {
                LOG.error("Failed to parse an error response. Will create one instead.", (Throwable)e);
            }
        }
        if (errorResponse == null) {
            errorResponse = HTTPClient.buildDefaultErrorResponse(response);
        }
        errorHandler.accept(errorResponse);
        throw new RESTException("Unhandled error: %s", errorResponse);
    }

    private URI buildUri(String path, Map<String, String> params) {
        String baseUri = String.format("%s/%s", this.uri, path);
        try {
            URIBuilder builder = new URIBuilder(baseUri);
            if (params != null) {
                params.forEach(builder::addParameter);
            }
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new RESTException("Failed to create request URI from base %s, params %s", baseUri, params);
        }
    }

    private <T> T execute(Method method, String path, Map<String, String> queryParams, Object requestBody, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return this.execute(method, path, queryParams, requestBody, responseType, headers, errorHandler, h2 -> {});
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <T> T execute(Method method, String path, Map<String, String> queryParams, Object requestBody, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler, Consumer<Map<String, String>> responseHeaders) {
        if (path.startsWith("/")) {
            throw new RESTException("Received a malformed path for a REST request: %s. Paths should not start with /", path);
        }
        HttpUriRequestBase request = new HttpUriRequestBase(method.name(), this.buildUri(path, queryParams));
        if (requestBody instanceof Map) {
            this.addRequestHeaders(request, headers, ContentType.APPLICATION_FORM_URLENCODED.getMimeType());
            request.setEntity(this.toFormEncoding((Map)requestBody));
        } else if (requestBody != null) {
            this.addRequestHeaders(request, headers, ContentType.APPLICATION_JSON.getMimeType());
            request.setEntity(this.toJson(requestBody));
        } else {
            this.addRequestHeaders(request, headers, ContentType.APPLICATION_JSON.getMimeType());
        }
        try {
            Throwable throwable = null;
            try (CloseableHttpResponse response = this.httpClient.execute(request);){
                T t2;
                HashMap<String, String> respHeaders = Maps.newHashMap();
                for (Header header : response.getHeaders()) {
                    respHeaders.put(header.getName(), header.getValue());
                }
                responseHeaders.accept(respHeaders);
                if (response.getCode() == 204 || responseType == null && HTTPClient.isSuccessful(response)) {
                    Header[] headerArray = null;
                    return (T)headerArray;
                }
                String responseBody = HTTPClient.extractResponseBodyAsString(response);
                if (!HTTPClient.isSuccessful(response)) {
                    HTTPClient.throwFailure(response, responseBody, errorHandler);
                }
                if (responseBody == null) {
                    throw new RESTException("Invalid (null) response body for request (expected %s): method=%s, path=%s, status=%d", responseType.getSimpleName(), method.name(), path, response.getCode());
                }
                try {
                    t2 = this.mapper.readValue(responseBody, responseType);
                }
                catch (JsonProcessingException e) {
                    try {
                        throw new RESTException(e, "Received a success response code of %d, but failed to parse response body into %s", response.getCode(), responseType.getSimpleName());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                return t2;
            }
        }
        catch (IOException e) {
            throw new RESTException(e, "Error occurred while processing %s request", new Object[]{method});
        }
    }

    @Override
    public void head(String path, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        this.execute(Method.HEAD, path, null, null, null, headers, errorHandler);
    }

    @Override
    public <T extends RESTResponse> T get(String path, Map<String, String> queryParams, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return (T)((RESTResponse)this.execute(Method.GET, path, queryParams, null, responseType, headers, errorHandler));
    }

    @Override
    public <T extends RESTResponse> T post(String path, RESTRequest body, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return (T)((RESTResponse)this.execute(Method.POST, path, null, body, responseType, headers, errorHandler));
    }

    @Override
    public <T extends RESTResponse> T post(String path, RESTRequest body, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler, Consumer<Map<String, String>> responseHeaders) {
        return (T)((RESTResponse)this.execute(Method.POST, path, null, body, responseType, headers, errorHandler, responseHeaders));
    }

    @Override
    public <T extends RESTResponse> T delete(String path, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return (T)((RESTResponse)this.execute(Method.DELETE, path, null, null, responseType, headers, errorHandler));
    }

    @Override
    public <T extends RESTResponse> T delete(String path, Map<String, String> queryParams, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return (T)((RESTResponse)this.execute(Method.DELETE, path, queryParams, null, responseType, headers, errorHandler));
    }

    @Override
    public <T extends RESTResponse> T postForm(String path, Map<String, String> formData, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return (T)((RESTResponse)this.execute(Method.POST, path, null, formData, responseType, headers, errorHandler));
    }

    private void addRequestHeaders(HttpUriRequest request, Map<String, String> requestHeaders, String bodyMimeType) {
        request.setHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        request.setHeader("Content-Type", bodyMimeType);
        requestHeaders.forEach(request::setHeader);
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close(CloseMode.GRACEFUL);
    }

    @VisibleForTesting
    static HttpRequestInterceptor loadInterceptorDynamically(String impl, Map<String, String> properties) {
        HttpRequestInterceptor instance;
        DynConstructors.Ctor ctor;
        try {
            ctor = DynConstructors.builder(HttpRequestInterceptor.class).loader(HTTPClient.class.getClassLoader()).impl(impl, new Class[0]).buildChecked();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize RequestInterceptor, missing no-arg constructor: %s", impl), e);
        }
        try {
            instance = (HttpRequestInterceptor)ctor.newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize, %s does not implement RequestInterceptor", impl), e);
        }
        DynMethods.builder("initialize").hiddenImpl(impl, Map.class).orNoop().build(instance).invoke(properties);
        return instance;
    }

    public static Builder builder(Map<String, String> properties) {
        return new Builder(properties);
    }

    private StringEntity toJson(Object requestBody) {
        try {
            return new StringEntity(this.mapper.writeValueAsString(requestBody));
        }
        catch (JsonProcessingException e) {
            throw new RESTException(e, "Failed to write request body: %s", requestBody);
        }
    }

    private StringEntity toFormEncoding(Map<?, ?> formData) {
        return new StringEntity(RESTUtil.encodeFormData(formData));
    }

    public static class Builder {
        private final Map<String, String> properties;
        private final Map<String, String> baseHeaders = Maps.newHashMap();
        private String uri;
        private ObjectMapper mapper = RESTObjectMapper.mapper();

        private Builder(Map<String, String> properties) {
            this.properties = properties;
        }

        public Builder uri(String baseUri) {
            Preconditions.checkNotNull(baseUri, "Invalid uri for http client: null");
            this.uri = RESTUtil.stripTrailingSlash(baseUri);
            return this;
        }

        public Builder withHeader(String key, String value) {
            this.baseHeaders.put(key, value);
            return this;
        }

        public Builder withHeaders(Map<String, String> headers) {
            this.baseHeaders.putAll(headers);
            return this;
        }

        public Builder withObjectMapper(ObjectMapper objectMapper) {
            this.mapper = objectMapper;
            return this;
        }

        public HTTPClient build() {
            this.withHeader(HTTPClient.CLIENT_VERSION_HEADER, IcebergBuild.fullVersion());
            this.withHeader(HTTPClient.CLIENT_GIT_COMMIT_SHORT_HEADER, IcebergBuild.gitCommitShortId());
            HttpRequestInterceptor interceptor = null;
            if (PropertyUtil.propertyAsBoolean(this.properties, HTTPClient.SIGV4_ENABLED, false)) {
                interceptor = HTTPClient.loadInterceptorDynamically(HTTPClient.SIGV4_REQUEST_INTERCEPTOR_IMPL, this.properties);
            }
            return new HTTPClient(this.uri, this.baseHeaders, this.mapper, interceptor);
        }
    }
}

