/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hive.HiveSchemaUtil;
import org.apache.iceberg.hive.HiveTableOperations;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.mr.Catalogs;
import org.apache.iceberg.mr.hive.HiveIcebergInputFormat;
import org.apache.iceberg.mr.hive.HiveIcebergOutputFormat;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveIcebergMetaHook
implements HiveMetaHook {
    private static final Logger LOG = LoggerFactory.getLogger(HiveIcebergMetaHook.class);
    private static final Set<String> PARAMETERS_TO_REMOVE = ImmutableSet.of("iceberg.mr.table.schema", "location", "name");
    private static final Set<String> PROPERTIES_TO_REMOVE = ImmutableSet.of("metadata_location", "previous_metadata_location", "iceberg.mr.table.partition.spec");
    private final Configuration conf;
    private Table icebergTable = null;
    private Properties catalogProperties;
    private boolean deleteIcebergTable;
    private FileIO deleteIo;
    private TableMetadata deleteMetadata;

    public HiveIcebergMetaHook(Configuration conf) {
        this.conf = conf;
    }

    public void preCreateTable(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
        this.catalogProperties = HiveIcebergMetaHook.getCatalogProperties(hmsTable);
        hmsTable.getParameters().put("table_type", "iceberg".toUpperCase());
        if (!Catalogs.hiveCatalog(this.conf, this.catalogProperties)) {
            hmsTable.getSd().setInputFormat(HiveIcebergInputFormat.class.getCanonicalName());
            hmsTable.getSd().setOutputFormat(HiveIcebergOutputFormat.class.getCanonicalName());
            try {
                this.icebergTable = Catalogs.loadTable(this.conf, this.catalogProperties);
                Preconditions.checkArgument(this.catalogProperties.getProperty("iceberg.mr.table.schema") == null, "Iceberg table already created - can not use provided schema");
                Preconditions.checkArgument(this.catalogProperties.getProperty("iceberg.mr.table.partition.spec") == null, "Iceberg table already created - can not use provided partition specification");
                LOG.info("Iceberg table already exists {}", (Object)this.icebergTable);
                return;
            }
            catch (NoSuchTableException noSuchTableException) {
                // empty catch block
            }
        }
        Schema schema = this.schema(this.catalogProperties, hmsTable);
        PartitionSpec spec = HiveIcebergMetaHook.spec(schema, this.catalogProperties, hmsTable);
        if (hmsTable.isSetPartitionKeys()) {
            hmsTable.getSd().getCols().addAll(hmsTable.getPartitionKeys());
            hmsTable.setPartitionKeysIsSet(false);
        }
        this.catalogProperties.put("iceberg.mr.table.schema", SchemaParser.toJson(schema));
        this.catalogProperties.put("iceberg.mr.table.partition.spec", PartitionSpecParser.toJson(spec));
        hmsTable.getParameters().putIfAbsent("external.table.purge", "TRUE");
        if (!Catalogs.hiveCatalog(this.conf, this.catalogProperties)) {
            Preconditions.checkArgument(hmsTable.getSd() != null && hmsTable.getSd().getLocation() != null, "Table location not set");
        }
        PARAMETERS_TO_REMOVE.forEach(hmsTable.getParameters()::remove);
    }

    public void rollbackCreateTable(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
    }

    public void commitCreateTable(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
        if (this.icebergTable == null) {
            if (Catalogs.hiveCatalog(this.conf, this.catalogProperties)) {
                this.catalogProperties.put("engine.hive.enabled", (Object)true);
            }
            Catalogs.createTable(this.conf, this.catalogProperties);
        }
    }

    public void preDropTable(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
        this.catalogProperties = HiveIcebergMetaHook.getCatalogProperties(hmsTable);
        boolean bl = this.deleteIcebergTable = hmsTable.getParameters() != null && "TRUE".equalsIgnoreCase((String)hmsTable.getParameters().get("external.table.purge"));
        if (this.deleteIcebergTable && Catalogs.hiveCatalog(this.conf, this.catalogProperties)) {
            try {
                String metadataLocation = (String)hmsTable.getParameters().get("metadata_location");
                this.deleteIo = Catalogs.loadTable(this.conf, this.catalogProperties).io();
                this.deleteMetadata = TableMetadataParser.read(this.deleteIo, metadataLocation);
            }
            catch (Exception e) {
                LOG.error("preDropTable: Error during loading Iceberg table or parsing its metadata for HMS table: {}.{}. In some cases, this might lead to undeleted metadata files under the table directory: {}. Please double check and, if needed, manually delete any dangling files/folders, if any. In spite of this error, the HMS table drop operation should proceed as normal.", new Object[]{hmsTable.getDbName(), hmsTable.getTableName(), hmsTable.getSd().getLocation(), e});
            }
        }
    }

    public void rollbackDropTable(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
    }

    public void commitDropTable(org.apache.hadoop.hive.metastore.api.Table hmsTable, boolean deleteData) {
        if (deleteData && this.deleteIcebergTable) {
            try {
                if (!Catalogs.hiveCatalog(this.conf, this.catalogProperties)) {
                    LOG.info("Dropping with purge all the data for table {}.{}", (Object)hmsTable.getDbName(), (Object)hmsTable.getTableName());
                    Catalogs.dropTable(this.conf, this.catalogProperties);
                } else if (this.deleteMetadata != null && this.deleteIo.newInputFile(this.deleteMetadata.location()).exists()) {
                    CatalogUtil.dropTableData(this.deleteIo, this.deleteMetadata);
                }
            }
            catch (Exception e) {
                LOG.warn("Exception during commitDropTable operation for table {}.{}.", new Object[]{hmsTable.getDbName(), hmsTable.getTableName(), e});
            }
        }
    }

    private static Properties getCatalogProperties(org.apache.hadoop.hive.metastore.api.Table hmsTable) {
        Properties properties = new Properties();
        hmsTable.getParameters().forEach((key, value) -> {
            String icebergKey = HiveTableOperations.translateToIcebergProp(key);
            properties.put(icebergKey, value);
        });
        if (properties.get("location") == null && hmsTable.getSd() != null && hmsTable.getSd().getLocation() != null) {
            properties.put("location", hmsTable.getSd().getLocation());
        }
        if (properties.get("name") == null) {
            properties.put("name", TableIdentifier.of(hmsTable.getDbName(), hmsTable.getTableName()).toString());
        }
        PROPERTIES_TO_REMOVE.forEach(properties::remove);
        return properties;
    }

    private Schema schema(Properties properties, org.apache.hadoop.hive.metastore.api.Table hmsTable) {
        boolean autoConversion = this.conf.getBoolean("iceberg.mr.schema.auto.conversion", false);
        if (properties.getProperty("iceberg.mr.table.schema") != null) {
            return SchemaParser.fromJson(properties.getProperty("iceberg.mr.table.schema"));
        }
        if (hmsTable.isSetPartitionKeys() && !hmsTable.getPartitionKeys().isEmpty()) {
            ArrayList<FieldSchema> cols = Lists.newArrayList(hmsTable.getSd().getCols());
            cols.addAll(hmsTable.getPartitionKeys());
            return HiveSchemaUtil.convert(cols, autoConversion);
        }
        return HiveSchemaUtil.convert(hmsTable.getSd().getCols(), autoConversion);
    }

    private static PartitionSpec spec(Schema schema, Properties properties, org.apache.hadoop.hive.metastore.api.Table hmsTable) {
        if (hmsTable.getParameters().get("iceberg.mr.table.partition.spec") != null) {
            Preconditions.checkArgument(!hmsTable.isSetPartitionKeys() || hmsTable.getPartitionKeys().isEmpty(), "Provide only one of the following: Hive partition specification, or the iceberg.mr.table.partition.spec property");
            return PartitionSpecParser.fromJson(schema, (String)hmsTable.getParameters().get("iceberg.mr.table.partition.spec"));
        }
        if (hmsTable.isSetPartitionKeys() && !hmsTable.getPartitionKeys().isEmpty()) {
            return HiveSchemaUtil.spec(schema, hmsTable.getPartitionKeys());
        }
        return PartitionSpec.unpartitioned();
    }
}

