/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.inmemory;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseMetastoreCatalog;
import org.apache.iceberg.BaseMetastoreTableOperations;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.inmemory.InMemoryFileIO;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class InMemoryCatalog
extends BaseMetastoreCatalog
implements SupportsNamespaces,
Closeable {
    private static final Joiner SLASH = Joiner.on("/");
    private static final Joiner DOT = Joiner.on(".");
    private final ConcurrentMap<Namespace, Map<String, String>> namespaces = Maps.newConcurrentMap();
    private final ConcurrentMap<TableIdentifier, String> tables = Maps.newConcurrentMap();
    private FileIO io;
    private String catalogName;
    private String warehouseLocation;

    @Override
    public String name() {
        return this.catalogName;
    }

    @Override
    public void initialize(String name, Map<String, String> properties) {
        this.catalogName = name != null ? name : InMemoryCatalog.class.getSimpleName();
        String warehouse = properties.getOrDefault("warehouse", "");
        this.warehouseLocation = warehouse.replaceAll("/*$", "");
        this.io = new InMemoryFileIO();
    }

    @Override
    protected TableOperations newTableOps(TableIdentifier tableIdentifier) {
        return new InMemoryTableOperations(this.io, tableIdentifier);
    }

    @Override
    protected String defaultWarehouseLocation(TableIdentifier tableIdentifier) {
        return SLASH.join(this.defaultNamespaceLocation(tableIdentifier.namespace()), tableIdentifier.name(), new Object[0]);
    }

    private String defaultNamespaceLocation(Namespace namespace) {
        if (namespace.isEmpty()) {
            return this.warehouseLocation;
        }
        return SLASH.join(this.warehouseLocation, SLASH.join(namespace.levels()), new Object[0]);
    }

    @Override
    public boolean dropTable(TableIdentifier tableIdentifier, boolean purge) {
        TableOperations ops = this.newTableOps(tableIdentifier);
        TableMetadata lastMetadata = purge && ops.current() != null ? ops.current() : null;
        if (null == this.tables.remove(tableIdentifier)) {
            return false;
        }
        if (purge && lastMetadata != null) {
            CatalogUtil.dropTableData(ops.io(), lastMetadata);
        }
        return true;
    }

    @Override
    public List<TableIdentifier> listTables(Namespace namespace) {
        if (!this.namespaceExists(namespace) && !namespace.isEmpty()) {
            throw new NoSuchNamespaceException("Cannot list tables for namespace. Namespace does not exist: %s", namespace);
        }
        return this.tables.keySet().stream().filter(t2 -> namespace.isEmpty() || t2.namespace().equals(namespace)).sorted(Comparator.comparing(TableIdentifier::toString)).collect(Collectors.toList());
    }

    @Override
    public void renameTable(TableIdentifier fromTableIdentifier, TableIdentifier toTableIdentifier) {
        if (fromTableIdentifier.equals(toTableIdentifier)) {
            return;
        }
        if (!this.namespaceExists(toTableIdentifier.namespace())) {
            throw new NoSuchNamespaceException("Cannot rename %s to %s. Namespace does not exist: %s", fromTableIdentifier, toTableIdentifier, toTableIdentifier.namespace());
        }
        if (!this.tables.containsKey(fromTableIdentifier)) {
            throw new NoSuchTableException("Cannot rename %s to %s. Table does not exist", fromTableIdentifier, toTableIdentifier);
        }
        if (this.tables.containsKey(toTableIdentifier)) {
            throw new AlreadyExistsException("Cannot rename %s to %s. Table already exists", fromTableIdentifier, toTableIdentifier);
        }
        String fromLocation = (String)this.tables.remove(fromTableIdentifier);
        Preconditions.checkState(null != fromLocation, "Cannot rename from %s to %s. Source table does not exist", (Object)fromTableIdentifier, (Object)toTableIdentifier);
        this.tables.put(toTableIdentifier, fromLocation);
    }

    @Override
    public void createNamespace(Namespace namespace) {
        this.createNamespace(namespace, Collections.emptyMap());
    }

    @Override
    public void createNamespace(Namespace namespace, Map<String, String> metadata) {
        if (this.namespaceExists(namespace)) {
            throw new AlreadyExistsException("Cannot create namespace %s. Namespace already exists", namespace);
        }
        this.namespaces.put(namespace, ImmutableMap.copyOf(metadata));
    }

    @Override
    public boolean namespaceExists(Namespace namespace) {
        return this.namespaces.containsKey(namespace);
    }

    @Override
    public boolean dropNamespace(Namespace namespace) throws NamespaceNotEmptyException {
        if (!this.namespaceExists(namespace)) {
            return false;
        }
        List<TableIdentifier> tableIdentifiers = this.listTables(namespace);
        if (!tableIdentifiers.isEmpty()) {
            throw new NamespaceNotEmptyException("Namespace %s is not empty. Contains %d table(s).", namespace, tableIdentifiers.size());
        }
        return this.namespaces.remove(namespace) != null;
    }

    @Override
    public boolean setProperties(Namespace namespace, Map<String, String> properties) throws NoSuchNamespaceException {
        if (!this.namespaceExists(namespace)) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", namespace);
        }
        this.namespaces.computeIfPresent(namespace, (k, v) -> ImmutableMap.builder().putAll(v).putAll(properties).buildKeepingLast());
        return true;
    }

    @Override
    public boolean removeProperties(Namespace namespace, Set<String> properties) throws NoSuchNamespaceException {
        if (!this.namespaceExists(namespace)) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", namespace);
        }
        this.namespaces.computeIfPresent(namespace, (k, v) -> {
            HashMap newProperties = Maps.newHashMap(v);
            properties.forEach(newProperties::remove);
            return ImmutableMap.copyOf(newProperties);
        });
        return true;
    }

    @Override
    public Map<String, String> loadNamespaceMetadata(Namespace namespace) throws NoSuchNamespaceException {
        Map properties = (Map)this.namespaces.get(namespace);
        if (properties == null) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", namespace);
        }
        return ImmutableMap.copyOf(properties);
    }

    @Override
    public List<Namespace> listNamespaces() {
        return this.namespaces.keySet().stream().filter(n -> !n.isEmpty()).map(n -> n.level(0)).distinct().sorted().map(xva$0 -> Namespace.of(xva$0)).collect(Collectors.toList());
    }

    @Override
    public List<Namespace> listNamespaces(Namespace namespace) throws NoSuchNamespaceException {
        String searchNamespaceString = namespace.isEmpty() ? "" : DOT.join(namespace.levels()) + ".";
        int searchNumberOfLevels = namespace.levels().length;
        List filteredNamespaces = this.namespaces.keySet().stream().filter(n -> DOT.join(n.levels()).startsWith(searchNamespaceString)).collect(Collectors.toList());
        if (!this.namespaces.containsKey(namespace) && filteredNamespaces.isEmpty()) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", namespace);
        }
        return filteredNamespaces.stream().map(n -> Namespace.of(Arrays.copyOf(n.levels(), searchNumberOfLevels + 1))).distinct().sorted(Comparator.comparing(n -> DOT.join(n.levels()))).collect(Collectors.toList());
    }

    @Override
    public void close() throws IOException {
        this.namespaces.clear();
        this.tables.clear();
    }

    private class InMemoryTableOperations
    extends BaseMetastoreTableOperations {
        private final FileIO fileIO;
        private final TableIdentifier tableIdentifier;

        InMemoryTableOperations(FileIO fileIO, TableIdentifier tableIdentifier) {
            this.fileIO = fileIO;
            this.tableIdentifier = tableIdentifier;
        }

        @Override
        public void doRefresh() {
            String latestLocation = (String)InMemoryCatalog.this.tables.get(this.tableIdentifier);
            if (latestLocation == null) {
                this.disableRefresh();
            } else {
                this.refreshFromMetadataLocation(latestLocation);
            }
        }

        @Override
        public void doCommit(TableMetadata base, TableMetadata metadata) {
            String oldLocation;
            String newLocation = this.writeNewMetadata(metadata, this.currentVersion() + 1);
            String string = oldLocation = base == null ? null : base.metadataFileLocation();
            if (null == base && !InMemoryCatalog.this.namespaceExists(this.tableIdentifier.namespace())) {
                throw new NoSuchNamespaceException("Cannot create table %s. Namespace does not exist: %s", this.tableIdentifier, this.tableIdentifier.namespace());
            }
            InMemoryCatalog.this.tables.compute(this.tableIdentifier, (k, existingLocation) -> {
                if (!Objects.equal(existingLocation, oldLocation)) {
                    if (null == base) {
                        throw new AlreadyExistsException("Table already exists: %s", this.tableName());
                    }
                    throw new CommitFailedException("Cannot commit to table %s metadata location from %s to %s because it has been concurrently modified to %s", this.tableIdentifier, oldLocation, newLocation, existingLocation);
                }
                return newLocation;
            });
        }

        @Override
        public FileIO io() {
            return this.fileIO;
        }

        @Override
        protected String tableName() {
            return this.tableIdentifier.toString();
        }
    }
}

