/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aliyun;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import java.util.Map;
import org.apache.iceberg.aliyun.AliyunClientFactory;
import org.apache.iceberg.aliyun.AliyunProperties;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.PropertyUtil;

public class AliyunClientFactories {
    private static final AliyunClientFactory ALIYUN_CLIENT_FACTORY_DEFAULT = new DefaultAliyunClientFactory();

    private AliyunClientFactories() {
    }

    public static AliyunClientFactory defaultFactory() {
        return ALIYUN_CLIENT_FACTORY_DEFAULT;
    }

    public static AliyunClientFactory from(Map<String, String> properties) {
        String factoryImpl = PropertyUtil.propertyAsString(properties, "client.factory-impl", DefaultAliyunClientFactory.class.getName());
        return AliyunClientFactories.loadClientFactory(factoryImpl, properties);
    }

    private static AliyunClientFactory loadClientFactory(String impl, Map<String, String> properties) {
        AliyunClientFactory factory;
        DynConstructors.Ctor ctor;
        try {
            ctor = DynConstructors.builder(AliyunClientFactory.class).hiddenImpl(impl, new Class[0]).buildChecked();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize AliyunClientFactory, missing no-arg constructor: %s", impl), e);
        }
        try {
            factory = (AliyunClientFactory)ctor.newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize AliyunClientFactory, %s does not implement AliyunClientFactory.", impl), e);
        }
        factory.initialize(properties);
        return factory;
    }

    static class DefaultAliyunClientFactory
    implements AliyunClientFactory {
        private AliyunProperties aliyunProperties;

        DefaultAliyunClientFactory() {
        }

        @Override
        public OSS newOSSClient() {
            Preconditions.checkNotNull(this.aliyunProperties, "Cannot create aliyun oss client before initializing the AliyunClientFactory.");
            return new OSSClientBuilder().build(this.aliyunProperties.ossEndpoint(), this.aliyunProperties.accessKeyId(), this.aliyunProperties.accessKeySecret());
        }

        @Override
        public void initialize(Map<String, String> properties) {
            this.aliyunProperties = new AliyunProperties(properties);
        }

        @Override
        public AliyunProperties aliyunProperties() {
            return this.aliyunProperties;
        }
    }
}

