/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonView;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.immutables.value.Generated;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.PaginatedResponse;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ser.Views;

@ParametersAreNonnullByDefault
@Generated(from="EntriesResponse", generator="Immutables")
@Immutable
public final class ImmutableEntriesResponse
implements EntriesResponse {
    private final boolean isHasMore;
    @Nullable
    private final String token;
    private final List<EntriesResponse.Entry> entries;
    @Nullable
    private final Reference effectiveReference;

    private ImmutableEntriesResponse(Builder builder) {
        this.token = builder.token;
        this.entries = ImmutableEntriesResponse.createUnmodifiableList(true, builder.entries);
        this.effectiveReference = builder.effectiveReference;
        this.isHasMore = builder.isHasMoreIsSet() ? builder.isHasMore : EntriesResponse.super.isHasMore();
    }

    private ImmutableEntriesResponse(boolean isHasMore, @Nullable String token, List<EntriesResponse.Entry> entries, @Nullable Reference effectiveReference) {
        this.isHasMore = isHasMore;
        this.token = token;
        this.entries = entries;
        this.effectiveReference = effectiveReference;
    }

    @Override
    @JsonProperty(value="hasMore")
    public boolean isHasMore() {
        return this.isHasMore;
    }

    @Override
    @JsonProperty(value="token")
    @Nullable
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty(value="entries")
    public List<EntriesResponse.Entry> getEntries() {
        return this.entries;
    }

    @Override
    @JsonProperty(value="effectiveReference")
    @JsonView(value={Views.V2.class})
    @Nullable
    public Reference getEffectiveReference() {
        return this.effectiveReference;
    }

    public final ImmutableEntriesResponse withIsHasMore(boolean value) {
        if (this.isHasMore == value) {
            return this;
        }
        return new ImmutableEntriesResponse(value, this.token, this.entries, this.effectiveReference);
    }

    public final ImmutableEntriesResponse withToken(@Nullable String value) {
        if (Objects.equals(this.token, value)) {
            return this;
        }
        return new ImmutableEntriesResponse(this.isHasMore, value, this.entries, this.effectiveReference);
    }

    public final ImmutableEntriesResponse withEntries(EntriesResponse.Entry ... elements) {
        List<EntriesResponse.Entry> newValue = ImmutableEntriesResponse.createUnmodifiableList(false, ImmutableEntriesResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableEntriesResponse(this.isHasMore, this.token, newValue, this.effectiveReference);
    }

    public final ImmutableEntriesResponse withEntries(Iterable<? extends EntriesResponse.Entry> elements) {
        if (this.entries == elements) {
            return this;
        }
        List<EntriesResponse.Entry> newValue = ImmutableEntriesResponse.createUnmodifiableList(false, ImmutableEntriesResponse.createSafeList(elements, true, false));
        return new ImmutableEntriesResponse(this.isHasMore, this.token, newValue, this.effectiveReference);
    }

    public final ImmutableEntriesResponse withEffectiveReference(@Nullable Reference value) {
        if (this.effectiveReference == value) {
            return this;
        }
        return new ImmutableEntriesResponse(this.isHasMore, this.token, this.entries, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEntriesResponse && this.equalTo(0, (ImmutableEntriesResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableEntriesResponse another) {
        return this.isHasMore == another.isHasMore && Objects.equals(this.token, another.token) && this.entries.equals(another.entries) && Objects.equals(this.effectiveReference, another.effectiveReference);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Boolean.hashCode(this.isHasMore);
        h2 += (h2 << 5) + Objects.hashCode(this.token);
        h2 += (h2 << 5) + this.entries.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.effectiveReference);
        return h2;
    }

    public String toString() {
        return "EntriesResponse{isHasMore=" + this.isHasMore + ", token=" + this.token + ", entries=" + this.entries + ", effectiveReference=" + this.effectiveReference + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEntriesResponse fromJson(Json json) {
        Builder builder = ImmutableEntriesResponse.builder();
        if (json.isHasMoreIsSet) {
            builder.isHasMore(json.isHasMore);
        }
        if (json.token != null) {
            builder.token(json.token);
        }
        if (json.entries != null) {
            builder.addAllEntries(json.entries);
        }
        if (json.effectiveReference != null) {
            builder.effectiveReference(json.effectiveReference);
        }
        return builder.build();
    }

    public static ImmutableEntriesResponse copyOf(EntriesResponse instance) {
        if (instance instanceof ImmutableEntriesResponse) {
            return (ImmutableEntriesResponse)instance;
        }
        return ImmutableEntriesResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="EntriesResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_IS_HAS_MORE = 1L;
        private long optBits;
        private boolean isHasMore;
        @javax.annotation.Nullable
        private String token;
        private List<EntriesResponse.Entry> entries = new ArrayList<EntriesResponse.Entry>();
        @javax.annotation.Nullable
        private Reference effectiveReference;

        private Builder() {
        }

        public final Builder from(EntriesResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaginatedResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedResponse instance;
            long bits = 0L;
            if (object instanceof EntriesResponse) {
                instance = (EntriesResponse)object;
                this.addAllEntries(instance.getEntries());
                Reference effectiveReferenceValue = instance.getEffectiveReference();
                if (effectiveReferenceValue != null) {
                    this.effectiveReference(effectiveReferenceValue);
                }
                if ((bits & 2L) == 0L) {
                    this.isHasMore(instance.isHasMore());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    String tokenValue = instance.getToken();
                    if (tokenValue != null) {
                        this.token(tokenValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof PaginatedResponse) {
                instance = (PaginatedResponse)object;
                if ((bits & 2L) == 0L) {
                    this.isHasMore(instance.isHasMore());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    String tokenValue = instance.getToken();
                    if (tokenValue != null) {
                        this.token(tokenValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="hasMore")
        public final Builder isHasMore(boolean isHasMore) {
            this.isHasMore = isHasMore;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="token")
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final Builder addEntries(EntriesResponse.Entry element) {
            this.entries.add(Objects.requireNonNull(element, "entries element"));
            return this;
        }

        public final Builder addEntries(EntriesResponse.Entry ... elements) {
            for (EntriesResponse.Entry element : elements) {
                this.entries.add(Objects.requireNonNull(element, "entries element"));
            }
            return this;
        }

        @JsonProperty(value="entries")
        public final Builder entries(Iterable<? extends EntriesResponse.Entry> elements) {
            this.entries.clear();
            return this.addAllEntries(elements);
        }

        public final Builder addAllEntries(Iterable<? extends EntriesResponse.Entry> elements) {
            for (EntriesResponse.Entry entry : elements) {
                this.entries.add(Objects.requireNonNull(entry, "entries element"));
            }
            return this;
        }

        @JsonProperty(value="effectiveReference")
        @JsonView(value={Views.V2.class})
        public final Builder effectiveReference(Reference effectiveReference) {
            this.effectiveReference = effectiveReference;
            return this;
        }

        public ImmutableEntriesResponse build() {
            return new ImmutableEntriesResponse(this);
        }

        private boolean isHasMoreIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="EntriesResponse", generator="Immutables")
    static final class Json
    implements EntriesResponse {
        boolean isHasMore;
        boolean isHasMoreIsSet;
        @javax.annotation.Nullable
        String token;
        @javax.annotation.Nullable
        List<EntriesResponse.Entry> entries = Collections.emptyList();
        @javax.annotation.Nullable
        Reference effectiveReference;

        Json() {
        }

        @JsonProperty(value="hasMore")
        public void setIsHasMore(boolean isHasMore) {
            this.isHasMore = isHasMore;
            this.isHasMoreIsSet = true;
        }

        @JsonProperty(value="token")
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty(value="entries")
        public void setEntries(List<EntriesResponse.Entry> entries) {
            this.entries = entries;
        }

        @JsonProperty(value="effectiveReference")
        @JsonView(value={Views.V2.class})
        public void setEffectiveReference(Reference effectiveReference) {
            this.effectiveReference = effectiveReference;
        }

        @Override
        public boolean isHasMore() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<EntriesResponse.Entry> getEntries() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reference getEffectiveReference() {
            throw new UnsupportedOperationException();
        }
    }
}

