/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentResponse;
import org.projectnessie.model.Reference;

@ParametersAreNonnullByDefault
@Generated(from="ContentResponse", generator="Immutables")
@Immutable
public final class ImmutableContentResponse
implements ContentResponse {
    private final Content content;
    @Nullable
    private final Reference effectiveReference;

    private ImmutableContentResponse(Content content, @Nullable Reference effectiveReference) {
        this.content = Objects.requireNonNull(content, "content");
        this.effectiveReference = effectiveReference;
    }

    private ImmutableContentResponse(ImmutableContentResponse original, Content content, @Nullable Reference effectiveReference) {
        this.content = content;
        this.effectiveReference = effectiveReference;
    }

    @Override
    @JsonProperty(value="content")
    public Content getContent() {
        return this.content;
    }

    @Override
    @JsonProperty(value="effectiveReference")
    @Nullable
    public Reference getEffectiveReference() {
        return this.effectiveReference;
    }

    public final ImmutableContentResponse withContent(Content value) {
        if (this.content == value) {
            return this;
        }
        Content newValue = Objects.requireNonNull(value, "content");
        return new ImmutableContentResponse(this, newValue, this.effectiveReference);
    }

    public final ImmutableContentResponse withEffectiveReference(@Nullable Reference value) {
        if (this.effectiveReference == value) {
            return this;
        }
        return new ImmutableContentResponse(this, this.content, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContentResponse && this.equalTo(0, (ImmutableContentResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableContentResponse another) {
        return this.content.equals(another.content) && Objects.equals(this.effectiveReference, another.effectiveReference);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.content.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.effectiveReference);
        return h2;
    }

    public String toString() {
        return "ContentResponse{content=" + this.content + ", effectiveReference=" + this.effectiveReference + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableContentResponse fromJson(Json json) {
        Builder builder = ImmutableContentResponse.builder();
        if (json.content != null) {
            builder.content(json.content);
        }
        if (json.effectiveReference != null) {
            builder.effectiveReference(json.effectiveReference);
        }
        return builder.build();
    }

    public static ImmutableContentResponse of(Content content, @Nullable Reference effectiveReference) {
        return new ImmutableContentResponse(content, effectiveReference);
    }

    public static ImmutableContentResponse copyOf(ContentResponse instance) {
        if (instance instanceof ImmutableContentResponse) {
            return (ImmutableContentResponse)instance;
        }
        return ImmutableContentResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ContentResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CONTENT = 1L;
        private long initBits = 1L;
        @javax.annotation.Nullable
        private Content content;
        @javax.annotation.Nullable
        private Reference effectiveReference;

        private Builder() {
        }

        public final Builder from(ContentResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.content(instance.getContent());
            Reference effectiveReferenceValue = instance.getEffectiveReference();
            if (effectiveReferenceValue != null) {
                this.effectiveReference(effectiveReferenceValue);
            }
            return this;
        }

        @JsonProperty(value="content")
        public final Builder content(Content content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="effectiveReference")
        public final Builder effectiveReference(Reference effectiveReference) {
            this.effectiveReference = effectiveReference;
            return this;
        }

        public ImmutableContentResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContentResponse(null, this.content, this.effectiveReference);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("content");
            }
            return "Cannot build ContentResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ContentResponse", generator="Immutables")
    static final class Json
    implements ContentResponse {
        @javax.annotation.Nullable
        Content content;
        @javax.annotation.Nullable
        Reference effectiveReference;

        Json() {
        }

        @JsonProperty(value="content")
        public void setContent(Content content) {
            this.content = content;
        }

        @JsonProperty(value="effectiveReference")
        public void setEffectiveReference(Reference effectiveReference) {
            this.effectiveReference = effectiveReference;
        }

        @Override
        public Content getContent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reference getEffectiveReference() {
            throw new UnsupportedOperationException();
        }
    }
}

