/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.requests;

import java.util.Locale;
import org.apache.iceberg.metrics.CommitReport;
import org.apache.iceberg.metrics.MetricsReport;
import org.apache.iceberg.metrics.ScanReport;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.RESTRequest;
import org.apache.iceberg.rest.requests.ImmutableReportMetricsRequest;
import org.immutables.value.Value;

@Value.Immutable
public interface ReportMetricsRequest
extends RESTRequest {
    public ReportType reportType();

    public MetricsReport report();

    @Override
    default public void validate() {
    }

    public static ReportMetricsRequest of(MetricsReport report) {
        ReportType reportType = null;
        if (report instanceof ScanReport) {
            reportType = ReportType.SCAN_REPORT;
        } else if (report instanceof CommitReport) {
            reportType = ReportType.COMMIT_REPORT;
        }
        Preconditions.checkArgument(null != reportType, "Unsupported report type: %s", (Object)report.getClass().getName());
        return ImmutableReportMetricsRequest.builder().reportType(reportType).report(report).build();
    }

    public static enum ReportType {
        SCAN_REPORT,
        COMMIT_REPORT;


        static ReportType fromString(String reportType) {
            Preconditions.checkArgument(null != reportType, "Invalid report type: null");
            try {
                return ReportType.valueOf(reportType.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Invalid report type: %s", reportType), e);
            }
        }
    }
}

