/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.hadoop.HadoopConfigurable;
import org.apache.iceberg.hadoop.SerializableConfiguration;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.SerializableMap;
import org.apache.iceberg.util.SerializableSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolvingFileIO
implements FileIO,
HadoopConfigurable {
    private static final Logger LOG = LoggerFactory.getLogger(ResolvingFileIO.class);
    private static final String FALLBACK_IMPL = "org.apache.iceberg.hadoop.HadoopFileIO";
    private static final String S3_FILE_IO_IMPL = "org.apache.iceberg.aws.s3.S3FileIO";
    private static final Map<String, String> SCHEME_TO_FILE_IO = ImmutableMap.of("s3", "org.apache.iceberg.aws.s3.S3FileIO", "s3a", "org.apache.iceberg.aws.s3.S3FileIO", "s3n", "org.apache.iceberg.aws.s3.S3FileIO");
    private final Map<String, FileIO> ioInstances = Maps.newHashMap();
    private SerializableMap<String, String> properties;
    private SerializableSupplier<Configuration> hadoopConf;

    @Override
    public InputFile newInputFile(String location) {
        return this.io(location).newInputFile(location);
    }

    @Override
    public InputFile newInputFile(String location, long length) {
        return this.io(location).newInputFile(location, length);
    }

    @Override
    public OutputFile newOutputFile(String location) {
        return this.io(location).newOutputFile(location);
    }

    @Override
    public void deleteFile(String location) {
        this.io(location).deleteFile(location);
    }

    @Override
    public Map<String, String> properties() {
        return this.properties.immutableMap();
    }

    @Override
    public void initialize(Map<String, String> newProperties) {
        this.close();
        this.properties = SerializableMap.copyOf(newProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<FileIO> instances = Lists.newArrayList();
        Map<String, FileIO> map = this.ioInstances;
        synchronized (map) {
            instances.addAll(this.ioInstances.values());
            this.ioInstances.clear();
        }
        for (FileIO io : instances) {
            io.close();
        }
    }

    @Override
    public void serializeConfWith(Function<Configuration, SerializableSupplier<Configuration>> confSerializer) {
        this.hadoopConf = confSerializer.apply((Configuration)this.hadoopConf.get());
    }

    public void setConf(Configuration conf) {
        this.hadoopConf = new SerializableConfiguration(conf)::get;
    }

    public Configuration getConf() {
        return (Configuration)this.hadoopConf.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileIO io(String location) {
        String impl = ResolvingFileIO.implFromLocation(location);
        FileIO io = this.ioInstances.get(impl);
        if (io != null) {
            return io;
        }
        Map<String, FileIO> map = this.ioInstances;
        synchronized (map) {
            io = this.ioInstances.get(impl);
            if (io != null) {
                return io;
            }
            Configuration conf = (Configuration)this.hadoopConf.get();
            try {
                io = CatalogUtil.loadFileIO(impl, this.properties, conf);
            }
            catch (IllegalArgumentException e) {
                if (impl.equals(FALLBACK_IMPL)) {
                    throw e;
                }
                LOG.warn("Failed to load FileIO implementation: {}, falling back to {}", new Object[]{impl, FALLBACK_IMPL, e});
                try {
                    io = CatalogUtil.loadFileIO(FALLBACK_IMPL, this.properties, conf);
                }
                catch (IllegalArgumentException suppressed) {
                    LOG.warn("Failed to load FileIO implementation: {} (fallback)", (Object)FALLBACK_IMPL, (Object)suppressed);
                    e.addSuppressed(suppressed);
                    throw e;
                }
            }
            this.ioInstances.put(impl, io);
        }
        return io;
    }

    private static String implFromLocation(String location) {
        return SCHEME_TO_FILE_IO.getOrDefault(ResolvingFileIO.scheme(location), FALLBACK_IMPL);
    }

    public Class<?> ioClass(String location) {
        String fileIOClassName = ResolvingFileIO.implFromLocation(location);
        try {
            return Class.forName(fileIOClassName);
        }
        catch (ClassNotFoundException e) {
            throw new ValidationException("Class %s not found : %s", fileIOClassName, e.getMessage());
        }
    }

    private static String scheme(String location) {
        int colonPos = location.indexOf(":");
        if (colonPos > 0) {
            return location.substring(0, colonPos);
        }
        return null;
    }
}

