/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.encryption;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.AEADBadTagException;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class Ciphers {
    private static final int NONCE_LENGTH = 12;
    private static final int GCM_TAG_LENGTH = 16;
    private static final int GCM_TAG_LENGTH_BITS = 128;

    public static class AesGcmDecryptor {
        private final SecretKeySpec aesKey;
        private final Cipher cipher;

        public AesGcmDecryptor(byte[] keyBytes) {
            Preconditions.checkArgument(keyBytes != null, "Key can't be null");
            int keyLength = keyBytes.length;
            Preconditions.checkArgument(keyLength == 16 || keyLength == 24 || keyLength == 32, "Cannot use a key of length " + keyLength + " because AES only allows 16, 24 or 32 bytes");
            this.aesKey = new SecretKeySpec(keyBytes, "AES");
            try {
                this.cipher = Cipher.getInstance("AES/GCM/NoPadding");
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("Failed to create GCM cipher", e);
            }
        }

        public byte[] decrypt(byte[] ciphertext, byte[] aad) {
            int plainTextLength = ciphertext.length - 16 - 12;
            Preconditions.checkState(plainTextLength >= 1, "Cannot decrypt cipher text of length " + ciphertext.length + " because text must longer than GCM_TAG_LENGTH + NONCE_LENGTH bytes. Text may not be encrypted with AES GCM cipher");
            byte[] nonce = new byte[12];
            System.arraycopy(ciphertext, 0, nonce, 0, 12);
            byte[] plainText = new byte[plainTextLength];
            int inputLength = ciphertext.length - 12;
            try {
                GCMParameterSpec spec = new GCMParameterSpec(128, nonce);
                this.cipher.init(2, (Key)this.aesKey, spec);
                if (null != aad) {
                    this.cipher.updateAAD(aad);
                }
                this.cipher.doFinal(ciphertext, 12, inputLength, plainText, 0);
            }
            catch (AEADBadTagException e) {
                throw new RuntimeException("GCM tag check failed. Possible reasons: wrong decryption key; or corrupt/tampereddata. AES GCM doesn't differentiate between these two.. ", e);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("Failed to decrypt", e);
            }
            return plainText;
        }
    }

    public static class AesGcmEncryptor {
        private final SecretKeySpec aesKey;
        private final Cipher cipher;
        private final SecureRandom randomGenerator;

        public AesGcmEncryptor(byte[] keyBytes) {
            Preconditions.checkArgument(keyBytes != null, "Key can't be null");
            int keyLength = keyBytes.length;
            Preconditions.checkArgument(keyLength == 16 || keyLength == 24 || keyLength == 32, "Cannot use a key of length " + keyLength + " because AES only allows 16, 24 or 32 bytes");
            this.aesKey = new SecretKeySpec(keyBytes, "AES");
            try {
                this.cipher = Cipher.getInstance("AES/GCM/NoPadding");
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("Failed to create GCM cipher", e);
            }
            this.randomGenerator = new SecureRandom();
        }

        public byte[] encrypt(byte[] plainText, byte[] aad) {
            byte[] nonce = new byte[12];
            this.randomGenerator.nextBytes(nonce);
            int cipherTextLength = 12 + plainText.length + 16;
            byte[] cipherText = new byte[cipherTextLength];
            try {
                GCMParameterSpec spec = new GCMParameterSpec(128, nonce);
                this.cipher.init(1, (Key)this.aesKey, spec);
                if (null != aad) {
                    this.cipher.updateAAD(aad);
                }
                this.cipher.doFinal(plainText, 0, plainText.length, cipherText, 12);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("Failed to encrypt", e);
            }
            System.arraycopy(nonce, 0, cipherText, 0, 12);
            return cipherText;
        }
    }
}

