/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.iceberg.aws.AwsClientFactories;
import org.apache.iceberg.aws.AwsClientFactory;
import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.aws.s3.S3InputFile;
import org.apache.iceberg.aws.s3.S3OutputFile;
import org.apache.iceberg.aws.s3.S3URI;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.io.BulkDeletionFailureException;
import org.apache.iceberg.io.CredentialSupplier;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.FileInfo;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.SupportsBulkOperations;
import org.apache.iceberg.io.SupportsPrefixOperations;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Multimaps;
import org.apache.iceberg.relocated.com.google.common.collect.SetMultimap;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.util.SerializableMap;
import org.apache.iceberg.util.SerializableSupplier;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.model.Tagging;

public class S3FileIO
implements FileIO,
SupportsBulkOperations,
SupportsPrefixOperations,
CredentialSupplier {
    private static final Logger LOG = LoggerFactory.getLogger(S3FileIO.class);
    private static final String DEFAULT_METRICS_IMPL = "org.apache.iceberg.hadoop.HadoopMetricsContext";
    private static volatile ExecutorService executorService;
    private String credential = null;
    private SerializableSupplier<S3Client> s3;
    private AwsProperties awsProperties;
    private SerializableMap<String, String> properties = null;
    private volatile transient S3Client client;
    private MetricsContext metrics = MetricsContext.nullMetrics();
    private final AtomicBoolean isResourceClosed = new AtomicBoolean(false);

    public S3FileIO() {
    }

    public S3FileIO(SerializableSupplier<S3Client> s3) {
        this(s3, new AwsProperties());
    }

    public S3FileIO(SerializableSupplier<S3Client> s3, AwsProperties awsProperties) {
        this.s3 = s3;
        this.awsProperties = awsProperties;
    }

    @Override
    public InputFile newInputFile(String path) {
        return S3InputFile.fromLocation(path, this.client(), this.awsProperties, this.metrics);
    }

    @Override
    public InputFile newInputFile(String path, long length) {
        return S3InputFile.fromLocation(path, length, this.client(), this.awsProperties, this.metrics);
    }

    @Override
    public OutputFile newOutputFile(String path) {
        return S3OutputFile.fromLocation(path, this.client(), this.awsProperties, this.metrics);
    }

    @Override
    public void deleteFile(String path) {
        if (this.awsProperties.s3DeleteTags() != null && !this.awsProperties.s3DeleteTags().isEmpty()) {
            try {
                this.tagFileToDelete(path, this.awsProperties.s3DeleteTags());
            }
            catch (S3Exception e) {
                LOG.warn("Failed to add delete tags: {} to {}", new Object[]{this.awsProperties.s3DeleteTags(), path, e});
            }
        }
        if (!this.awsProperties.isS3DeleteEnabled()) {
            return;
        }
        S3URI location = new S3URI(path, this.awsProperties.s3BucketToAccessPointMapping());
        DeleteObjectRequest deleteRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(location.bucket()).key(location.key()).build();
        this.client().deleteObject(deleteRequest);
    }

    @Override
    public Map<String, String> properties() {
        return this.properties.immutableMap();
    }

    @Override
    public void deleteFiles(Iterable<String> paths) throws BulkDeletionFailureException {
        if (this.awsProperties.s3DeleteTags() != null && !this.awsProperties.s3DeleteTags().isEmpty()) {
            Tasks.foreach(paths).noRetry().executeWith(this.executorService()).suppressFailureWhenFinished().onFailure((path, exc) -> LOG.warn("Failed to add delete tags: {} to {}", new Object[]{this.awsProperties.s3DeleteTags(), path, exc})).run(path -> this.tagFileToDelete((String)path, this.awsProperties.s3DeleteTags()));
        }
        if (this.awsProperties.isS3DeleteEnabled()) {
            SetMultimap bucketToObjects = Multimaps.newSetMultimap(Maps.newHashMap(), Sets::newHashSet);
            ArrayList<Future<List>> deletionTasks = Lists.newArrayList();
            for (String string : paths) {
                S3URI s3URI = new S3URI(string, this.awsProperties.s3BucketToAccessPointMapping());
                String bucket = s3URI.bucket();
                String objectKey = s3URI.key();
                bucketToObjects.get(bucket).add(objectKey);
                if (bucketToObjects.get(bucket).size() != this.awsProperties.s3FileIoDeleteBatchSize()) continue;
                HashSet keys = Sets.newHashSet(bucketToObjects.get(bucket));
                Future<List> deletionTask = this.executorService().submit(() -> this.deleteBatch(bucket, keys));
                deletionTasks.add(deletionTask);
                bucketToObjects.removeAll(bucket);
            }
            for (Map.Entry entry : bucketToObjects.asMap().entrySet()) {
                String string = (String)entry.getKey();
                Collection keys = (Collection)entry.getValue();
                Future<List> deletionTask = this.executorService().submit(() -> this.deleteBatch(bucket, keys));
                deletionTasks.add(deletionTask);
            }
            int totalFailedDeletions = 0;
            for (Future future : deletionTasks) {
                try {
                    List failedDeletions = (List)future.get();
                    failedDeletions.forEach(path -> LOG.warn("Failed to delete object at path {}", path));
                    totalFailedDeletions += failedDeletions.size();
                }
                catch (ExecutionException e) {
                    LOG.warn("Caught unexpected exception during batch deletion: ", e.getCause());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    deletionTasks.stream().filter(task -> !task.isDone()).forEach(task -> task.cancel(true));
                    throw new RuntimeException("Interrupted when waiting for deletions to complete", e);
                }
            }
            if (totalFailedDeletions > 0) {
                throw new BulkDeletionFailureException(totalFailedDeletions);
            }
        }
    }

    private void tagFileToDelete(String path, Set<Tag> deleteTags) throws S3Exception {
        S3URI location = new S3URI(path, this.awsProperties.s3BucketToAccessPointMapping());
        String bucket = location.bucket();
        String objectKey = location.key();
        GetObjectTaggingRequest getObjectTaggingRequest = (GetObjectTaggingRequest)GetObjectTaggingRequest.builder().bucket(bucket).key(objectKey).build();
        GetObjectTaggingResponse getObjectTaggingResponse = this.client().getObjectTagging(getObjectTaggingRequest);
        HashSet<Tag> tags = Sets.newHashSet();
        if (getObjectTaggingResponse.hasTagSet()) {
            tags.addAll(getObjectTaggingResponse.tagSet());
        }
        tags.addAll(deleteTags);
        PutObjectTaggingRequest putObjectTaggingRequest = (PutObjectTaggingRequest)PutObjectTaggingRequest.builder().bucket(bucket).key(objectKey).tagging((Tagging)Tagging.builder().tagSet(tags).build()).build();
        this.client().putObjectTagging(putObjectTaggingRequest);
    }

    private List<String> deleteBatch(String bucket, Collection<String> keysToDelete) {
        List objectIds = keysToDelete.stream().map(key -> (ObjectIdentifier)ObjectIdentifier.builder().key(key).build()).collect(Collectors.toList());
        DeleteObjectsRequest request = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucket).delete((Delete)Delete.builder().objects(objectIds).build()).build();
        ArrayList<String> failures = Lists.newArrayList();
        try {
            DeleteObjectsResponse response = this.client().deleteObjects(request);
            if (response.hasErrors()) {
                failures.addAll(response.errors().stream().map(error -> String.format("s3://%s/%s", request.bucket(), error.key())).collect(Collectors.toList()));
            }
        }
        catch (Exception e) {
            LOG.warn("Encountered failure when deleting batch", (Throwable)e);
            failures.addAll(request.delete().objects().stream().map(obj -> String.format("s3://%s/%s", request.bucket(), obj.key())).collect(Collectors.toList()));
        }
        return failures;
    }

    @Override
    public Iterable<FileInfo> listPrefix(String prefix) {
        S3URI s3uri = new S3URI(prefix, this.awsProperties.s3BucketToAccessPointMapping());
        ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(s3uri.bucket()).prefix(s3uri.key()).build();
        return () -> this.client().listObjectsV2Paginator(request).stream().flatMap(r -> r.contents().stream()).map(o -> new FileInfo(String.format("%s://%s/%s", s3uri.scheme(), s3uri.bucket(), o.key()), o.size(), o.lastModified().toEpochMilli())).iterator();
    }

    @Override
    public void deletePrefix(String prefix) {
        this.deleteFiles(() -> Streams.stream(this.listPrefix(prefix)).map(FileInfo::location).iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S3Client client() {
        if (this.client == null) {
            S3FileIO s3FileIO = this;
            synchronized (s3FileIO) {
                if (this.client == null) {
                    this.client = (S3Client)this.s3.get();
                }
            }
        }
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExecutorService executorService() {
        if (executorService != null) return executorService;
        Class<S3FileIO> clazz = S3FileIO.class;
        synchronized (S3FileIO.class) {
            if (executorService != null) return executorService;
            executorService = ThreadPools.newWorkerPool("iceberg-s3fileio-delete", this.awsProperties.s3FileIoDeleteThreads());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return executorService;
        }
    }

    @Override
    public String getCredential() {
        return this.credential;
    }

    @Override
    public void initialize(Map<String, String> props) {
        this.properties = SerializableMap.copyOf(props);
        this.awsProperties = new AwsProperties(this.properties);
        if (this.s3 == null) {
            AwsClientFactory clientFactory = AwsClientFactories.from(props);
            if (clientFactory instanceof CredentialSupplier) {
                this.credential = ((CredentialSupplier)((Object)clientFactory)).getCredential();
            }
            this.s3 = clientFactory::s3;
            if (this.awsProperties.s3PreloadClientEnabled()) {
                this.client();
            }
        }
        try {
            DynConstructors.Ctor ctor = DynConstructors.builder(MetricsContext.class).loader(S3FileIO.class.getClassLoader()).hiddenImpl(DEFAULT_METRICS_IMPL, String.class).buildChecked();
            MetricsContext context = (MetricsContext)ctor.newInstance("s3");
            context.initialize(this.properties);
            this.metrics = context;
        }
        catch (ClassCastException | NoClassDefFoundError | NoSuchMethodException e) {
            LOG.warn("Unable to load metrics class: '{}', falling back to null metrics", (Object)DEFAULT_METRICS_IMPL, (Object)e);
        }
    }

    @Override
    public void close() {
        if (this.isResourceClosed.compareAndSet(false, true) && this.client != null) {
            this.client.close();
        }
    }
}

