/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws;

import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.aws.ApacheHttpClientConfigurations;
import org.apache.iceberg.aws.UrlConnectionHttpClientConfigurations;
import org.apache.iceberg.aws.s3.signer.S3V4RestSignerClient;
import org.apache.iceberg.common.DynClasses;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SerializableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.core.client.builder.SdkClientBuilder;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.glue.GlueClientBuilder;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.sts.model.Tag;

public class AwsProperties
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(AwsProperties.class);
    public static final String S3FILEIO_SSE_TYPE = "s3.sse.type";
    public static final String S3FILEIO_SSE_TYPE_NONE = "none";
    public static final String S3FILEIO_SSE_TYPE_KMS = "kms";
    public static final String S3FILEIO_SSE_TYPE_S3 = "s3";
    public static final String S3FILEIO_SSE_TYPE_CUSTOM = "custom";
    public static final String S3FILEIO_SSE_KEY = "s3.sse.key";
    public static final String S3FILEIO_SSE_MD5 = "s3.sse.md5";
    public static final String GLUE_CATALOG_ID = "glue.id";
    public static final String GLUE_ACCOUNT_ID = "glue.account-id";
    public static final String GLUE_CATALOG_SKIP_ARCHIVE = "glue.skip-archive";
    public static final boolean GLUE_CATALOG_SKIP_ARCHIVE_DEFAULT = true;
    public static final String GLUE_CATALOG_SKIP_NAME_VALIDATION = "glue.skip-name-validation";
    public static final boolean GLUE_CATALOG_SKIP_NAME_VALIDATION_DEFAULT = false;
    public static final String GLUE_LAKEFORMATION_ENABLED = "glue.lakeformation-enabled";
    public static final boolean GLUE_LAKEFORMATION_ENABLED_DEFAULT = false;
    public static final String GLUE_CATALOG_ENDPOINT = "glue.endpoint";
    public static final String S3FILEIO_MULTIPART_UPLOAD_THREADS = "s3.multipart.num-threads";
    public static final String S3FILEIO_MULTIPART_SIZE = "s3.multipart.part-size-bytes";
    public static final int S3FILEIO_MULTIPART_SIZE_DEFAULT = 0x2000000;
    public static final int S3FILEIO_MULTIPART_SIZE_MIN = 0x500000;
    public static final String S3FILEIO_MULTIPART_THRESHOLD_FACTOR = "s3.multipart.threshold";
    public static final double S3FILEIO_MULTIPART_THRESHOLD_FACTOR_DEFAULT = 1.5;
    public static final String S3FILEIO_STAGING_DIRECTORY = "s3.staging-dir";
    public static final String S3FILEIO_ACL = "s3.acl";
    public static final String S3FILEIO_ENDPOINT = "s3.endpoint";
    public static final String S3FILEIO_PATH_STYLE_ACCESS = "s3.path-style-access";
    public static final boolean S3FILEIO_PATH_STYLE_ACCESS_DEFAULT = false;
    public static final String S3FILEIO_ACCESS_KEY_ID = "s3.access-key-id";
    public static final String S3FILEIO_SECRET_ACCESS_KEY = "s3.secret-access-key";
    public static final String S3FILEIO_SESSION_TOKEN = "s3.session-token";
    public static final String S3_USE_ARN_REGION_ENABLED = "s3.use-arn-region-enabled";
    public static final boolean S3_USE_ARN_REGION_ENABLED_DEFAULT = false;
    public static final String S3_CHECKSUM_ENABLED = "s3.checksum-enabled";
    public static final boolean S3_CHECKSUM_ENABLED_DEFAULT = false;
    public static final String S3_REMOTE_SIGNING_ENABLED = "s3.remote-signing-enabled";
    public static final boolean S3_REMOTE_SIGNING_ENABLED_DEFAULT = false;
    public static final String S3FILEIO_DELETE_BATCH_SIZE = "s3.delete.batch-size";
    public static final int S3FILEIO_DELETE_BATCH_SIZE_DEFAULT = 250;
    public static final int S3FILEIO_DELETE_BATCH_SIZE_MAX = 1000;
    public static final String DYNAMODB_ENDPOINT = "dynamodb.endpoint";
    public static final String DYNAMODB_TABLE_NAME = "dynamodb.table-name";
    public static final String DYNAMODB_TABLE_NAME_DEFAULT = "iceberg";
    public static final String CLIENT_FACTORY = "client.factory";
    public static final String CLIENT_ASSUME_ROLE_ARN = "client.assume-role.arn";
    public static final String CLIENT_ASSUME_ROLE_TAGS_PREFIX = "client.assume-role.tags.";
    public static final String CLIENT_ASSUME_ROLE_TIMEOUT_SEC = "client.assume-role.timeout-sec";
    public static final int CLIENT_ASSUME_ROLE_TIMEOUT_SEC_DEFAULT = 3600;
    public static final String CLIENT_ASSUME_ROLE_EXTERNAL_ID = "client.assume-role.external-id";
    public static final String CLIENT_ASSUME_ROLE_REGION = "client.assume-role.region";
    public static final String CLIENT_ASSUME_ROLE_SESSION_NAME = "client.assume-role.session-name";
    public static final String CLIENT_CREDENTIALS_PROVIDER = "client.credentials-provider";
    private static final String CLIENT_CREDENTIAL_PROVIDER_PREFIX = "client.credentials-provider.";
    public static final String CLIENT_REGION = "client.region";
    public static final String HTTP_CLIENT_TYPE = "http-client.type";
    public static final String HTTP_CLIENT_TYPE_URLCONNECTION = "urlconnection";
    public static final String HTTP_CLIENT_TYPE_APACHE = "apache";
    public static final String HTTP_CLIENT_TYPE_DEFAULT = "urlconnection";
    public static final String HTTP_CLIENT_URLCONNECTION_CONNECTION_TIMEOUT_MS = "http-client.urlconnection.connection-timeout-ms";
    public static final String HTTP_CLIENT_URLCONNECTION_SOCKET_TIMEOUT_MS = "http-client.urlconnection.socket-timeout-ms";
    public static final String HTTP_CLIENT_APACHE_CONNECTION_TIMEOUT_MS = "http-client.apache.connection-timeout-ms";
    public static final String HTTP_CLIENT_APACHE_SOCKET_TIMEOUT_MS = "http-client.apache.socket-timeout-ms";
    public static final String HTTP_CLIENT_APACHE_CONNECTION_ACQUISITION_TIMEOUT_MS = "http-client.apache.connection-acquisition-timeout-ms";
    public static final String HTTP_CLIENT_APACHE_CONNECTION_MAX_IDLE_TIME_MS = "http-client.apache.connection-max-idle-time-ms";
    public static final String HTTP_CLIENT_APACHE_CONNECTION_TIME_TO_LIVE_MS = "http-client.apache.connection-time-to-live-ms";
    public static final String HTTP_CLIENT_APACHE_EXPECT_CONTINUE_ENABLED = "http-client.apache.expect-continue-enabled";
    public static final String HTTP_CLIENT_APACHE_MAX_CONNECTIONS = "http-client.apache.max-connections";
    public static final String HTTP_CLIENT_APACHE_TCP_KEEP_ALIVE_ENABLED = "http-client.apache.tcp-keep-alive-enabled";
    public static final String HTTP_CLIENT_APACHE_USE_IDLE_CONNECTION_REAPER_ENABLED = "http-client.apache.use-idle-connection-reaper-enabled";
    public static final String S3_WRITE_TAGS_PREFIX = "s3.write.tags.";
    public static final String S3_WRITE_TABLE_TAG_ENABLED = "s3.write.table-tag-enabled";
    public static final boolean S3_WRITE_TABLE_TAG_ENABLED_DEFAULT = false;
    public static final String S3_WRITE_NAMESPACE_TAG_ENABLED = "s3.write.namespace-tag-enabled";
    public static final boolean S3_WRITE_NAMESPACE_TAG_ENABLED_DEFAULT = false;
    public static final String S3_TAG_ICEBERG_TABLE = "iceberg.table";
    public static final String S3_TAG_ICEBERG_NAMESPACE = "iceberg.namespace";
    public static final String S3_DELETE_TAGS_PREFIX = "s3.delete.tags.";
    public static final String S3FILEIO_DELETE_THREADS = "s3.delete.num-threads";
    public static final String S3_DELETE_ENABLED = "s3.delete-enabled";
    public static final boolean S3_DELETE_ENABLED_DEFAULT = true;
    public static final String S3_ACCELERATION_ENABLED = "s3.acceleration-enabled";
    public static final boolean S3_ACCELERATION_ENABLED_DEFAULT = false;
    public static final String S3_DUALSTACK_ENABLED = "s3.dualstack-enabled";
    public static final boolean S3_DUALSTACK_ENABLED_DEFAULT = false;
    public static final String S3_ACCESS_POINTS_PREFIX = "s3.access-points.";
    public static final String S3_PRELOAD_CLIENT_ENABLED = "s3.preload-client-enabled";
    public static final boolean S3_PRELOAD_CLIENT_ENABLED_DEFAULT = false;
    public static final String LAKE_FORMATION_TABLE_NAME = "lakeformation.table-name";
    public static final String LAKE_FORMATION_DB_NAME = "lakeformation.db-name";
    public static final String REST_SIGNER_REGION = "rest.signing-region";
    public static final String REST_SIGNING_NAME = "rest.signing-name";
    public static final String REST_SIGNING_NAME_DEFAULT = "execute-api";
    public static final String REST_ACCESS_KEY_ID = "rest.access-key-id";
    public static final String REST_SECRET_ACCESS_KEY = "rest.secret-access-key";
    public static final String REST_SESSION_TOKEN = "rest.session-token";
    private static final String HTTP_CLIENT_PREFIX = "http-client.";
    private String httpClientType;
    private final Map<String, String> httpClientProperties;
    private final Set<Tag> stsClientAssumeRoleTags;
    private String clientAssumeRoleArn;
    private String clientAssumeRoleExternalId;
    private int clientAssumeRoleTimeoutSec;
    private String clientAssumeRoleRegion;
    private String clientAssumeRoleSessionName;
    private String clientRegion;
    private String clientCredentialsProvider;
    private final Map<String, String> clientCredentialsProviderProperties;
    private String s3FileIoSseType;
    private String s3FileIoSseKey;
    private String s3FileIoSseMd5;
    private String s3AccessKeyId;
    private String s3SecretAccessKey;
    private String s3SessionToken;
    private int s3FileIoMultipartUploadThreads;
    private int s3FileIoMultiPartSize;
    private int s3FileIoDeleteBatchSize;
    private double s3FileIoMultipartThresholdFactor;
    private String s3fileIoStagingDirectory;
    private ObjectCannedACL s3FileIoAcl;
    private boolean isS3ChecksumEnabled;
    private final Set<software.amazon.awssdk.services.s3.model.Tag> s3WriteTags;
    private boolean s3WriteTableTagEnabled;
    private boolean s3WriteNamespaceTagEnabled;
    private final Set<software.amazon.awssdk.services.s3.model.Tag> s3DeleteTags;
    private int s3FileIoDeleteThreads;
    private boolean isS3DeleteEnabled;
    private final Map<String, String> s3BucketToAccessPointMapping;
    private boolean s3PreloadClientEnabled;
    private boolean s3DualStackEnabled;
    private boolean s3PathStyleAccess;
    private boolean s3UseArnRegionEnabled;
    private boolean s3AccelerationEnabled;
    private String s3Endpoint;
    private String glueEndpoint;
    private String glueCatalogId;
    private boolean glueCatalogSkipArchive;
    private boolean glueCatalogSkipNameValidation;
    private boolean glueLakeFormationEnabled;
    private String dynamoDbTableName;
    private String dynamoDbEndpoint;
    private final boolean s3RemoteSigningEnabled;
    private final Map<String, String> allProperties;
    private String restSigningRegion;
    private String restSigningName;
    private String restAccessKeyId;
    private String restSecretAccessKey;
    private String restSessionToken;

    public AwsProperties() {
        this.httpClientType = "urlconnection";
        this.httpClientProperties = Collections.emptyMap();
        this.stsClientAssumeRoleTags = Sets.newHashSet();
        this.clientAssumeRoleArn = null;
        this.clientAssumeRoleTimeoutSec = 3600;
        this.clientAssumeRoleExternalId = null;
        this.clientAssumeRoleRegion = null;
        this.clientAssumeRoleSessionName = null;
        this.clientRegion = null;
        this.clientCredentialsProvider = null;
        this.clientCredentialsProviderProperties = null;
        this.s3FileIoSseType = S3FILEIO_SSE_TYPE_NONE;
        this.s3FileIoSseKey = null;
        this.s3FileIoSseMd5 = null;
        this.s3AccessKeyId = null;
        this.s3SecretAccessKey = null;
        this.s3SessionToken = null;
        this.s3FileIoAcl = null;
        this.s3Endpoint = null;
        this.s3FileIoMultipartUploadThreads = Runtime.getRuntime().availableProcessors();
        this.s3FileIoMultiPartSize = 0x2000000;
        this.s3FileIoMultipartThresholdFactor = 1.5;
        this.s3FileIoDeleteBatchSize = 250;
        this.s3fileIoStagingDirectory = System.getProperty("java.io.tmpdir");
        this.isS3ChecksumEnabled = false;
        this.s3WriteTags = Sets.newHashSet();
        this.s3WriteTableTagEnabled = false;
        this.s3WriteNamespaceTagEnabled = false;
        this.s3DeleteTags = Sets.newHashSet();
        this.s3FileIoDeleteThreads = Runtime.getRuntime().availableProcessors();
        this.isS3DeleteEnabled = true;
        this.s3BucketToAccessPointMapping = Collections.emptyMap();
        this.s3PreloadClientEnabled = false;
        this.s3DualStackEnabled = false;
        this.s3PathStyleAccess = false;
        this.s3UseArnRegionEnabled = false;
        this.s3AccelerationEnabled = false;
        this.glueCatalogId = null;
        this.glueEndpoint = null;
        this.glueCatalogSkipArchive = true;
        this.glueCatalogSkipNameValidation = false;
        this.glueLakeFormationEnabled = false;
        this.dynamoDbEndpoint = null;
        this.dynamoDbTableName = DYNAMODB_TABLE_NAME_DEFAULT;
        this.s3RemoteSigningEnabled = false;
        this.allProperties = Maps.newHashMap();
        this.restSigningName = REST_SIGNING_NAME_DEFAULT;
        ValidationException.check(this.s3KeyIdAccessKeyBothConfigured(), "S3 client access key ID and secret access key must be set at the same time", new Object[0]);
    }

    public AwsProperties(Map<String, String> properties) {
        this.httpClientType = PropertyUtil.propertyAsString(properties, HTTP_CLIENT_TYPE, "urlconnection");
        this.httpClientProperties = PropertyUtil.filterProperties(properties, key -> key.startsWith(HTTP_CLIENT_PREFIX));
        this.stsClientAssumeRoleTags = this.toStsTags(properties, CLIENT_ASSUME_ROLE_TAGS_PREFIX);
        this.clientAssumeRoleArn = properties.get(CLIENT_ASSUME_ROLE_ARN);
        this.clientAssumeRoleTimeoutSec = PropertyUtil.propertyAsInt(properties, CLIENT_ASSUME_ROLE_TIMEOUT_SEC, 3600);
        this.clientAssumeRoleExternalId = properties.get(CLIENT_ASSUME_ROLE_EXTERNAL_ID);
        this.clientAssumeRoleRegion = properties.get(CLIENT_ASSUME_ROLE_REGION);
        this.clientAssumeRoleSessionName = properties.get(CLIENT_ASSUME_ROLE_SESSION_NAME);
        this.clientRegion = properties.get(CLIENT_REGION);
        this.clientCredentialsProvider = properties.get(CLIENT_CREDENTIALS_PROVIDER);
        this.clientCredentialsProviderProperties = PropertyUtil.propertiesWithPrefix(properties, CLIENT_CREDENTIAL_PROVIDER_PREFIX);
        this.s3FileIoSseType = properties.getOrDefault(S3FILEIO_SSE_TYPE, S3FILEIO_SSE_TYPE_NONE);
        this.s3FileIoSseKey = properties.get(S3FILEIO_SSE_KEY);
        this.s3FileIoSseMd5 = properties.get(S3FILEIO_SSE_MD5);
        this.s3AccessKeyId = properties.get(S3FILEIO_ACCESS_KEY_ID);
        this.s3SecretAccessKey = properties.get(S3FILEIO_SECRET_ACCESS_KEY);
        this.s3SessionToken = properties.get(S3FILEIO_SESSION_TOKEN);
        if (S3FILEIO_SSE_TYPE_CUSTOM.equals(this.s3FileIoSseType)) {
            Preconditions.checkNotNull(this.s3FileIoSseKey, "Cannot initialize SSE-C S3FileIO with null encryption key");
            Preconditions.checkNotNull(this.s3FileIoSseMd5, "Cannot initialize SSE-C S3FileIO with null encryption key MD5");
        }
        this.s3Endpoint = properties.get(S3FILEIO_ENDPOINT);
        this.glueEndpoint = properties.get(GLUE_CATALOG_ENDPOINT);
        this.glueCatalogId = properties.get(GLUE_CATALOG_ID);
        this.glueCatalogSkipArchive = PropertyUtil.propertyAsBoolean(properties, GLUE_CATALOG_SKIP_ARCHIVE, true);
        this.glueCatalogSkipNameValidation = PropertyUtil.propertyAsBoolean(properties, GLUE_CATALOG_SKIP_NAME_VALIDATION, false);
        this.glueLakeFormationEnabled = PropertyUtil.propertyAsBoolean(properties, GLUE_LAKEFORMATION_ENABLED, false);
        this.s3FileIoMultipartUploadThreads = PropertyUtil.propertyAsInt(properties, S3FILEIO_MULTIPART_UPLOAD_THREADS, Runtime.getRuntime().availableProcessors());
        this.s3PathStyleAccess = PropertyUtil.propertyAsBoolean(properties, S3FILEIO_PATH_STYLE_ACCESS, false);
        this.s3UseArnRegionEnabled = PropertyUtil.propertyAsBoolean(properties, S3_USE_ARN_REGION_ENABLED, false);
        this.s3AccelerationEnabled = PropertyUtil.propertyAsBoolean(properties, S3_ACCELERATION_ENABLED, false);
        this.s3DualStackEnabled = PropertyUtil.propertyAsBoolean(properties, S3_DUALSTACK_ENABLED, false);
        try {
            this.s3FileIoMultiPartSize = PropertyUtil.propertyAsInt(properties, S3FILEIO_MULTIPART_SIZE, 0x2000000);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Input malformed or exceeded maximum multipart upload size 5GB: %s", properties.get(S3FILEIO_MULTIPART_SIZE)));
        }
        this.s3FileIoMultipartThresholdFactor = PropertyUtil.propertyAsDouble(properties, S3FILEIO_MULTIPART_THRESHOLD_FACTOR, 1.5);
        Preconditions.checkArgument(this.s3FileIoMultipartThresholdFactor >= 1.0, "Multipart threshold factor must be >= to 1.0");
        Preconditions.checkArgument(this.s3FileIoMultiPartSize >= 0x500000, "Minimum multipart upload object size must be larger than 5 MB.");
        this.s3fileIoStagingDirectory = PropertyUtil.propertyAsString(properties, S3FILEIO_STAGING_DIRECTORY, System.getProperty("java.io.tmpdir"));
        String aclType = properties.get(S3FILEIO_ACL);
        this.s3FileIoAcl = ObjectCannedACL.fromValue((String)aclType);
        Preconditions.checkArgument(this.s3FileIoAcl == null || !this.s3FileIoAcl.equals((Object)ObjectCannedACL.UNKNOWN_TO_SDK_VERSION), "Cannot support S3 CannedACL " + aclType);
        this.isS3ChecksumEnabled = PropertyUtil.propertyAsBoolean(properties, S3_CHECKSUM_ENABLED, false);
        this.s3FileIoDeleteBatchSize = PropertyUtil.propertyAsInt(properties, S3FILEIO_DELETE_BATCH_SIZE, 250);
        Preconditions.checkArgument(this.s3FileIoDeleteBatchSize > 0 && this.s3FileIoDeleteBatchSize <= 1000, String.format("Deletion batch size must be between 1 and %s", 1000));
        this.s3WriteTags = this.toS3Tags(properties, S3_WRITE_TAGS_PREFIX);
        this.s3WriteTableTagEnabled = PropertyUtil.propertyAsBoolean(properties, S3_WRITE_TABLE_TAG_ENABLED, false);
        this.s3WriteNamespaceTagEnabled = PropertyUtil.propertyAsBoolean(properties, S3_WRITE_NAMESPACE_TAG_ENABLED, false);
        this.s3DeleteTags = this.toS3Tags(properties, S3_DELETE_TAGS_PREFIX);
        this.s3FileIoDeleteThreads = PropertyUtil.propertyAsInt(properties, S3FILEIO_DELETE_THREADS, Runtime.getRuntime().availableProcessors());
        this.isS3DeleteEnabled = PropertyUtil.propertyAsBoolean(properties, S3_DELETE_ENABLED, true);
        this.s3BucketToAccessPointMapping = PropertyUtil.propertiesWithPrefix(properties, S3_ACCESS_POINTS_PREFIX);
        this.s3PreloadClientEnabled = PropertyUtil.propertyAsBoolean(properties, S3_PRELOAD_CLIENT_ENABLED, false);
        this.dynamoDbEndpoint = properties.get(DYNAMODB_ENDPOINT);
        this.dynamoDbTableName = PropertyUtil.propertyAsString(properties, DYNAMODB_TABLE_NAME, DYNAMODB_TABLE_NAME_DEFAULT);
        this.s3RemoteSigningEnabled = PropertyUtil.propertyAsBoolean(properties, S3_REMOTE_SIGNING_ENABLED, false);
        this.allProperties = SerializableMap.copyOf(properties);
        this.restSigningRegion = properties.get(REST_SIGNER_REGION);
        this.restSigningName = properties.getOrDefault(REST_SIGNING_NAME, REST_SIGNING_NAME_DEFAULT);
        this.restAccessKeyId = properties.get(REST_ACCESS_KEY_ID);
        this.restSecretAccessKey = properties.get(REST_SECRET_ACCESS_KEY);
        this.restSessionToken = properties.get(REST_SESSION_TOKEN);
        ValidationException.check(this.s3KeyIdAccessKeyBothConfigured(), "S3 client access key ID and secret access key must be set at the same time", new Object[0]);
    }

    public Set<Tag> stsClientAssumeRoleTags() {
        return this.stsClientAssumeRoleTags;
    }

    public String clientAssumeRoleArn() {
        return this.clientAssumeRoleArn;
    }

    public int clientAssumeRoleTimeoutSec() {
        return this.clientAssumeRoleTimeoutSec;
    }

    public String clientAssumeRoleExternalId() {
        return this.clientAssumeRoleExternalId;
    }

    public String clientAssumeRoleRegion() {
        return this.clientAssumeRoleRegion;
    }

    public String clientAssumeRoleSessionName() {
        return this.clientAssumeRoleSessionName;
    }

    public String s3FileIoSseType() {
        return this.s3FileIoSseType;
    }

    public void setS3FileIoSseType(String sseType) {
        this.s3FileIoSseType = sseType;
    }

    public String s3FileIoSseKey() {
        return this.s3FileIoSseKey;
    }

    public int s3FileIoDeleteBatchSize() {
        return this.s3FileIoDeleteBatchSize;
    }

    public void setS3FileIoDeleteBatchSize(int deleteBatchSize) {
        this.s3FileIoDeleteBatchSize = deleteBatchSize;
    }

    public void setS3FileIoSseKey(String sseKey) {
        this.s3FileIoSseKey = sseKey;
    }

    public String s3FileIoSseMd5() {
        return this.s3FileIoSseMd5;
    }

    public void setS3FileIoSseMd5(String sseMd5) {
        this.s3FileIoSseMd5 = sseMd5;
    }

    public String glueCatalogId() {
        return this.glueCatalogId;
    }

    public void setGlueCatalogId(String id) {
        this.glueCatalogId = id;
    }

    public boolean glueCatalogSkipArchive() {
        return this.glueCatalogSkipArchive;
    }

    public void setGlueCatalogSkipArchive(boolean skipArchive) {
        this.glueCatalogSkipArchive = skipArchive;
    }

    public boolean glueCatalogSkipNameValidation() {
        return this.glueCatalogSkipNameValidation;
    }

    public void setGlueCatalogSkipNameValidation(boolean glueCatalogSkipNameValidation) {
        this.glueCatalogSkipNameValidation = glueCatalogSkipNameValidation;
    }

    public boolean glueLakeFormationEnabled() {
        return this.glueLakeFormationEnabled;
    }

    public void setGlueLakeFormationEnabled(boolean glueLakeFormationEnabled) {
        this.glueLakeFormationEnabled = glueLakeFormationEnabled;
    }

    public int s3FileIoMultipartUploadThreads() {
        return this.s3FileIoMultipartUploadThreads;
    }

    public void setS3FileIoMultipartUploadThreads(int threads) {
        this.s3FileIoMultipartUploadThreads = threads;
    }

    public int s3FileIoMultiPartSize() {
        return this.s3FileIoMultiPartSize;
    }

    public void setS3FileIoMultiPartSize(int size) {
        this.s3FileIoMultiPartSize = size;
    }

    public double s3FileIOMultipartThresholdFactor() {
        return this.s3FileIoMultipartThresholdFactor;
    }

    public void setS3FileIoMultipartThresholdFactor(double factor) {
        this.s3FileIoMultipartThresholdFactor = factor;
    }

    public String s3fileIoStagingDirectory() {
        return this.s3fileIoStagingDirectory;
    }

    public void setS3fileIoStagingDirectory(String directory) {
        this.s3fileIoStagingDirectory = directory;
    }

    public ObjectCannedACL s3FileIoAcl() {
        return this.s3FileIoAcl;
    }

    public void setS3FileIoAcl(ObjectCannedACL acl) {
        this.s3FileIoAcl = acl;
    }

    public void setS3PreloadClientEnabled(boolean s3PreloadClientEnabled) {
        this.s3PreloadClientEnabled = s3PreloadClientEnabled;
    }

    public boolean s3PreloadClientEnabled() {
        return this.s3PreloadClientEnabled;
    }

    public String dynamoDbTableName() {
        return this.dynamoDbTableName;
    }

    public void setDynamoDbTableName(String name) {
        this.dynamoDbTableName = name;
    }

    public boolean isS3ChecksumEnabled() {
        return this.isS3ChecksumEnabled;
    }

    public void setS3ChecksumEnabled(boolean eTagCheckEnabled) {
        this.isS3ChecksumEnabled = eTagCheckEnabled;
    }

    public Set<software.amazon.awssdk.services.s3.model.Tag> s3WriteTags() {
        return this.s3WriteTags;
    }

    public boolean s3WriteTableTagEnabled() {
        return this.s3WriteTableTagEnabled;
    }

    public void setS3WriteTableTagEnabled(boolean s3WriteTableNameTagEnabled) {
        this.s3WriteTableTagEnabled = s3WriteTableNameTagEnabled;
    }

    public boolean s3WriteNamespaceTagEnabled() {
        return this.s3WriteNamespaceTagEnabled;
    }

    public void setS3WriteNamespaceTagEnabled(boolean s3WriteNamespaceTagEnabled) {
        this.s3WriteNamespaceTagEnabled = s3WriteNamespaceTagEnabled;
    }

    public Set<software.amazon.awssdk.services.s3.model.Tag> s3DeleteTags() {
        return this.s3DeleteTags;
    }

    public int s3FileIoDeleteThreads() {
        return this.s3FileIoDeleteThreads;
    }

    public void setS3FileIoDeleteThreads(int threads) {
        this.s3FileIoDeleteThreads = threads;
    }

    public boolean isS3DeleteEnabled() {
        return this.isS3DeleteEnabled;
    }

    public void setS3DeleteEnabled(boolean s3DeleteEnabled) {
        this.isS3DeleteEnabled = s3DeleteEnabled;
    }

    public Map<String, String> s3BucketToAccessPointMapping() {
        return this.s3BucketToAccessPointMapping;
    }

    public Map<String, String> httpClientProperties() {
        return this.httpClientProperties;
    }

    public String clientRegion() {
        return this.clientRegion;
    }

    public void setClientRegion(String clientRegion) {
        this.clientRegion = clientRegion;
    }

    public <T extends S3ClientBuilder> void applyS3CredentialConfigurations(T builder) {
        builder.credentialsProvider((AwsCredentialsProvider)(this.s3RemoteSigningEnabled ? AnonymousCredentialsProvider.create() : this.credentialsProvider(this.s3AccessKeyId, this.s3SecretAccessKey, this.s3SessionToken)));
    }

    public <T extends AwsClientBuilder> void applyClientRegionConfiguration(T builder) {
        if (this.clientRegion != null) {
            builder.region(Region.of((String)this.clientRegion));
        }
    }

    public <T extends AwsClientBuilder> void applyClientCredentialConfigurations(T builder) {
        if (!Strings.isNullOrEmpty(this.clientCredentialsProvider)) {
            builder.credentialsProvider(this.credentialsProvider(this.clientCredentialsProvider));
        }
    }

    public <T extends S3ClientBuilder> void applyS3ServiceConfigurations(T builder) {
        ((S3ClientBuilder)builder.dualstackEnabled(Boolean.valueOf(this.s3DualStackEnabled))).serviceConfiguration((S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Boolean.valueOf(this.s3PathStyleAccess)).useArnRegionEnabled(Boolean.valueOf(this.s3UseArnRegionEnabled)).accelerateModeEnabled(Boolean.valueOf(this.s3AccelerationEnabled)).build());
    }

    public <T extends S3ClientBuilder> void applyS3SignerConfiguration(T builder) {
        if (this.s3RemoteSigningEnabled) {
            builder.overrideConfiguration(c -> c.putAdvancedOption(SdkAdvancedClientOption.SIGNER, (Object)S3V4RestSignerClient.create(this.allProperties)));
        }
    }

    public <T extends AwsSyncClientBuilder> void applyHttpClientConfigurations(T builder) {
        if (Strings.isNullOrEmpty(this.httpClientType)) {
            this.httpClientType = "urlconnection";
        }
        switch (this.httpClientType) {
            case "urlconnection": {
                UrlConnectionHttpClientConfigurations urlConnectionHttpClientConfigurations = (UrlConnectionHttpClientConfigurations)this.loadHttpClientConfigurations(UrlConnectionHttpClientConfigurations.class.getName());
                urlConnectionHttpClientConfigurations.configureHttpClientBuilder(builder);
                break;
            }
            case "apache": {
                ApacheHttpClientConfigurations apacheHttpClientConfigurations = (ApacheHttpClientConfigurations)this.loadHttpClientConfigurations(ApacheHttpClientConfigurations.class.getName());
                apacheHttpClientConfigurations.configureHttpClientBuilder(builder);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized HTTP client type " + this.httpClientType);
            }
        }
    }

    public <T extends S3ClientBuilder> void applyS3EndpointConfigurations(T builder) {
        this.configureEndpoint(builder, this.s3Endpoint);
    }

    public <T extends GlueClientBuilder> void applyGlueEndpointConfigurations(T builder) {
        this.configureEndpoint(builder, this.glueEndpoint);
    }

    public <T extends DynamoDbClientBuilder> void applyDynamoDbEndpointConfigurations(T builder) {
        this.configureEndpoint(builder, this.dynamoDbEndpoint);
    }

    public Region restSigningRegion() {
        if (this.restSigningRegion == null) {
            this.restSigningRegion = DefaultAwsRegionProviderChain.builder().build().getRegion().id();
        }
        return Region.of((String)this.restSigningRegion);
    }

    public String restSigningName() {
        return this.restSigningName;
    }

    public AwsCredentialsProvider restCredentialsProvider() {
        return this.credentialsProvider(this.restAccessKeyId, this.restSecretAccessKey, this.restSessionToken);
    }

    private Set<software.amazon.awssdk.services.s3.model.Tag> toS3Tags(Map<String, String> properties, String prefix) {
        return PropertyUtil.propertiesWithPrefix(properties, prefix).entrySet().stream().map(e -> (software.amazon.awssdk.services.s3.model.Tag)software.amazon.awssdk.services.s3.model.Tag.builder().key((String)e.getKey()).value((String)e.getValue()).build()).collect(Collectors.toSet());
    }

    private Set<Tag> toStsTags(Map<String, String> properties, String prefix) {
        return PropertyUtil.propertiesWithPrefix(properties, prefix).entrySet().stream().map(e -> (Tag)Tag.builder().key((String)e.getKey()).value((String)e.getValue()).build()).collect(Collectors.toSet());
    }

    private boolean s3KeyIdAccessKeyBothConfigured() {
        return this.s3AccessKeyId == null == (this.s3SecretAccessKey == null);
    }

    private AwsCredentialsProvider credentialsProvider(String accessKeyId, String secretAccessKey, String sessionToken) {
        if (accessKeyId != null) {
            if (sessionToken == null) {
                return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKeyId, (String)secretAccessKey));
            }
            return StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)accessKeyId, (String)secretAccessKey, (String)sessionToken));
        }
        if (!Strings.isNullOrEmpty(this.clientCredentialsProvider)) {
            return this.credentialsProvider(this.clientCredentialsProvider);
        }
        return DefaultCredentialsProvider.create();
    }

    private AwsCredentialsProvider credentialsProvider(String credentialsProviderClass) {
        Class providerClass;
        try {
            providerClass = DynClasses.builder().impl(credentialsProviderClass).buildChecked();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Cannot load class %s, it does not exist in the classpath", credentialsProviderClass), e);
        }
        Preconditions.checkArgument(AwsCredentialsProvider.class.isAssignableFrom(providerClass), String.format("Cannot initialize %s, it does not implement %s.", credentialsProviderClass, AwsCredentialsProvider.class.getName()));
        try {
            AwsCredentialsProvider provider;
            try {
                provider = (AwsCredentialsProvider)DynMethods.builder("create").hiddenImpl(providerClass, Map.class).buildStaticChecked().invoke(this.clientCredentialsProviderProperties);
            }
            catch (NoSuchMethodException e) {
                provider = (AwsCredentialsProvider)DynMethods.builder("create").hiddenImpl(providerClass, new Class[0]).buildStaticChecked().invoke(new Object[0]);
            }
            return provider;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot create an instance of %s, it does not contain a static 'create' or 'create(Map<String, String>)' method", credentialsProviderClass), e);
        }
    }

    private <T extends SdkClientBuilder> void configureEndpoint(T builder, String endpoint) {
        if (endpoint != null) {
            builder.endpointOverride(URI.create(endpoint));
        }
    }

    private <T> T loadHttpClientConfigurations(String impl) {
        try {
            Object httpClientConfigurations = DynMethods.builder("create").hiddenImpl(impl, Map.class).buildStaticChecked().invoke(this.httpClientProperties);
            return (T)httpClientConfigurations;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot create %s to generate and configure the http client builder", impl), e);
        }
    }
}

