/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestGroup;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StaticTableScan;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.SystemProperties;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.iceberg.types.Types;

public class PartitionsTable
extends BaseMetadataTable {
    private final Schema schema;
    static final boolean PLAN_SCANS_WITH_WORKER_POOL = SystemProperties.getBoolean("iceberg.scan.plan-in-worker-pool", true);

    PartitionsTable(Table table) {
        this(table, table.name() + ".partitions");
    }

    PartitionsTable(Table table, String name) {
        super(table, name);
        this.schema = new Schema(Types.NestedField.required(1, "partition", Partitioning.partitionType(table)), Types.NestedField.required(2, "record_count", Types.LongType.get()), Types.NestedField.required(3, "file_count", Types.IntegerType.get()), Types.NestedField.required(4, "spec_id", Types.IntegerType.get()));
    }

    @Override
    public TableScan newScan() {
        return new PartitionsScan(this.table());
    }

    @Override
    public Schema schema() {
        if (this.table().spec().fields().size() < 1) {
            return this.schema.select("record_count", "file_count");
        }
        return this.schema;
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.PARTITIONS;
    }

    private DataTask task(StaticTableScan scan) {
        Iterable<Partition> partitions = PartitionsTable.partitions(this.table(), scan);
        if (this.table().spec().fields().size() < 1) {
            return StaticDataTask.of(this.io().newInputFile(this.table().operations().current().metadataFileLocation()), this.schema(), scan.schema(), partitions, root -> StaticDataTask.Row.of(((Partition)root).recordCount, ((Partition)root).fileCount));
        }
        return StaticDataTask.of(this.io().newInputFile(this.table().operations().current().metadataFileLocation()), this.schema(), scan.schema(), partitions, PartitionsTable::convertPartition);
    }

    private static StaticDataTask.Row convertPartition(Partition partition) {
        return StaticDataTask.Row.of(partition.key, partition.recordCount, partition.fileCount, partition.specId);
    }

    private static Iterable<Partition> partitions(Table table, StaticTableScan scan) {
        CloseableIterable<FileScanTask> tasks = PartitionsTable.planFiles(scan);
        Types.StructType normalizedPartitionType = Partitioning.partitionType(table);
        PartitionMap partitions = new PartitionMap();
        HashMap<Integer, int[]> normalizedPositionsBySpec = Maps.newHashMapWithExpectedSize(table.specs().size());
        for (FileScanTask task : tasks) {
            PartitionData original = (PartitionData)((DataFile)task.file()).partition();
            int[] normalizedPositions = normalizedPositionsBySpec.computeIfAbsent(task.spec().specId(), specId -> PartitionsTable.normalizedPositions(table, specId, normalizedPartitionType));
            PartitionData normalized = PartitionsTable.normalizePartition(original, normalizedPartitionType, normalizedPositions);
            partitions.get(normalized).update((DataFile)task.file());
        }
        return partitions.all();
    }

    private static int[] normalizedPositions(Table table, int specId, Types.StructType normalizedType) {
        Types.StructType originalType = table.specs().get(specId).partitionType();
        int[] normalizedPositions = new int[originalType.fields().size()];
        for (int originalIndex = 0; originalIndex < originalType.fields().size(); ++originalIndex) {
            Types.NestedField normalizedField = normalizedType.field(originalType.fields().get(originalIndex).fieldId());
            normalizedPositions[originalIndex] = normalizedType.fields().indexOf(normalizedField);
        }
        return normalizedPositions;
    }

    private static PartitionData normalizePartition(PartitionData originalPartition, Types.StructType normalizedPartitionType, int[] normalizedPositions) {
        PartitionData normalizedPartition = new PartitionData(normalizedPartitionType);
        for (int originalIndex = 0; originalIndex < originalPartition.size(); ++originalIndex) {
            normalizedPartition.put(normalizedPositions[originalIndex], originalPartition.get(originalIndex));
        }
        return normalizedPartition;
    }

    @VisibleForTesting
    static CloseableIterable<FileScanTask> planFiles(StaticTableScan scan) {
        Table table = scan.table();
        Snapshot snapshot = table.snapshot(scan.snapshot().snapshotId());
        boolean caseSensitive = scan.isCaseSensitive();
        LoadingCache<Integer, ManifestEvaluator> evalCache = Caffeine.newBuilder().build(specId -> {
            PartitionSpec spec = table.specs().get(specId);
            PartitionSpec transformedSpec = PartitionsTable.transformSpec(scan.tableSchema(), spec);
            return ManifestEvaluator.forRowFilter(scan.filter(), transformedSpec, caseSensitive);
        });
        FileIO io = table.io();
        ManifestGroup manifestGroup = new ManifestGroup(io, snapshot.dataManifests(io), snapshot.deleteManifests(io)).caseSensitive(caseSensitive).filterManifests(m4 -> ((ManifestEvaluator)evalCache.get(m4.partitionSpecId())).eval((ManifestFile)m4)).select(scan.scanColumns()).specsById(scan.table().specs()).ignoreDeleted();
        if (scan.shouldIgnoreResiduals()) {
            manifestGroup = manifestGroup.ignoreResiduals();
        }
        if (scan.snapshot().dataManifests(io).size() > 1 && (PLAN_SCANS_WITH_WORKER_POOL || scan.context().planWithCustomizedExecutor())) {
            manifestGroup = manifestGroup.planWith(scan.context().planExecutor());
        }
        return manifestGroup.planFiles();
    }

    static class Partition {
        private final StructLike key;
        private long recordCount;
        private int fileCount;
        private int specId;

        Partition(StructLike key) {
            this.key = key;
            this.recordCount = 0L;
            this.fileCount = 0;
            this.specId = 0;
        }

        void update(DataFile file) {
            this.recordCount += file.recordCount();
            ++this.fileCount;
            this.specId = file.specId();
        }
    }

    static class PartitionMap {
        private final Map<PartitionData, Partition> partitions = Maps.newHashMap();

        PartitionMap() {
        }

        Partition get(PartitionData key) {
            Partition partition = this.partitions.get(key);
            if (partition == null) {
                partition = new Partition(key);
                this.partitions.put(key, partition);
            }
            return partition;
        }

        Iterable<Partition> all() {
            return this.partitions.values();
        }
    }

    private class PartitionsScan
    extends StaticTableScan {
        PartitionsScan(Table table) {
            super(table, PartitionsTable.this.schema(), MetadataTableType.PARTITIONS, (StaticTableScan x$0) -> PartitionsTable.this.task(x$0));
        }
    }
}

