/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseAllMetadataTableScan;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BaseMetadataTableScan;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetricsUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

abstract class BaseFilesTable
extends BaseMetadataTable {
    BaseFilesTable(Table table, String name) {
        super(table, name);
    }

    @Override
    public Schema schema() {
        Types.StructType partitionType = Partitioning.partitionType(this.table());
        Schema schema = new Schema(DataFile.getType(partitionType).fields());
        if (partitionType.fields().size() < 1) {
            schema = TypeUtil.selectNot(schema, Sets.newHashSet(102));
        }
        return TypeUtil.join(schema, MetricsUtil.readableMetricsSchema(this.table().schema(), schema));
    }

    private static CloseableIterable<FileScanTask> planFiles(Table table, CloseableIterable<ManifestFile> manifests, Schema tableSchema, Schema projectedSchema, TableScanContext context) {
        Expression rowFilter = context.rowFilter();
        boolean caseSensitive = context.caseSensitive();
        boolean ignoreResiduals = context.ignoreResiduals();
        LoadingCache<Integer, ManifestEvaluator> evalCache = Caffeine.newBuilder().build(specId -> {
            PartitionSpec spec = table.specs().get(specId);
            PartitionSpec transformedSpec = BaseFilesTable.transformSpec(tableSchema, spec);
            return ManifestEvaluator.forRowFilter(rowFilter, transformedSpec, caseSensitive);
        });
        CloseableIterable<ManifestFile> filteredManifests = CloseableIterable.filter(manifests, manifest -> ((ManifestEvaluator)evalCache.get(manifest.partitionSpecId())).eval((ManifestFile)manifest));
        String schemaString = SchemaParser.toJson(projectedSchema);
        String specString = PartitionSpecParser.toJson(PartitionSpec.unpartitioned());
        Expression filter = ignoreResiduals ? Expressions.alwaysTrue() : rowFilter;
        ResidualEvaluator residuals = ResidualEvaluator.unpartitioned(filter);
        return CloseableIterable.transform(filteredManifests, manifest -> new ManifestReadTask(table, (ManifestFile)manifest, projectedSchema, schemaString, specString, residuals));
    }

    static class ContentFileStructWithMetrics
    implements StructLike {
        private final StructLike fileAsStruct;
        private final MetricsUtil.ReadableMetricsStruct readableMetrics;
        private final int columnCount;
        private final int metricsPosition;

        ContentFileStructWithMetrics(int columnCount, int metricsPosition, StructLike fileAsStruct, MetricsUtil.ReadableMetricsStruct readableMetrics) {
            this.fileAsStruct = fileAsStruct;
            this.readableMetrics = readableMetrics;
            this.columnCount = columnCount;
            this.metricsPosition = metricsPosition;
        }

        @Override
        public int size() {
            return this.columnCount;
        }

        @Override
        public <T> T get(int pos, Class<T> javaClass) {
            if (pos < this.metricsPosition) {
                return this.fileAsStruct.get(pos, javaClass);
            }
            if (pos == this.metricsPosition) {
                return javaClass.cast(this.readableMetrics);
            }
            return this.fileAsStruct.get(pos - 1, javaClass);
        }

        @Override
        public <T> void set(int pos, T value) {
            throw new UnsupportedOperationException("ContentFileStructWithMetrics is read only");
        }
    }

    static class ManifestReadTask
    extends BaseFileScanTask
    implements DataTask {
        private final FileIO io;
        private final Map<Integer, PartitionSpec> specsById;
        private final ManifestFile manifest;
        private final Schema dataTableSchema;
        private final Schema projection;

        ManifestReadTask(Table table, ManifestFile manifest, Schema projection, String schemaString, String specString, ResidualEvaluator residuals) {
            super(DataFiles.fromManifest(manifest), null, schemaString, specString, residuals);
            this.io = table.io();
            this.specsById = Maps.newHashMap(table.specs());
            this.manifest = manifest;
            this.dataTableSchema = table.schema();
            this.projection = projection;
        }

        @Override
        public CloseableIterable<StructLike> rows() {
            Types.NestedField readableMetricsField = this.projection.findField("readable_metrics");
            if (readableMetricsField == null) {
                return CloseableIterable.transform(this.files(this.projection), file -> (StructLike)((Object)file));
            }
            Set<Integer> readableMetricsIds = TypeUtil.getProjectedIds(readableMetricsField.type());
            Schema fileProjection = TypeUtil.selectNot(this.projection, readableMetricsIds);
            int metricsPosition = this.projection.columns().indexOf(readableMetricsField);
            Schema projectionForReadableMetrics = new Schema(MetricsUtil.READABLE_METRIC_COLS.stream().map(MetricsUtil.ReadableMetricColDefinition::originalCol).collect(Collectors.toList()));
            Schema projectionForMetrics = TypeUtil.join(fileProjection, projectionForReadableMetrics);
            return CloseableIterable.transform(this.files(projectionForMetrics), f -> this.withReadableMetrics((ContentFile<?>)f, metricsPosition));
        }

        private CloseableIterable<? extends ContentFile<?>> files(Schema fileProjection) {
            switch (this.manifest.content()) {
                case DATA: {
                    return ManifestFiles.read(this.manifest, this.io, this.specsById).project(fileProjection);
                }
                case DELETES: {
                    return ManifestFiles.readDeleteManifest(this.manifest, this.io, this.specsById).project(fileProjection);
                }
            }
            throw new IllegalArgumentException("Unsupported manifest content type:" + (Object)((Object)this.manifest.content()));
        }

        private StructLike withReadableMetrics(ContentFile<?> file, int metricsPosition) {
            int columnCount = this.projection.columns().size();
            Types.StructType projectedMetricType = this.projection.findField("readable_metrics").type().asStructType();
            MetricsUtil.ReadableMetricsStruct readableMetrics = MetricsUtil.readableMetricsStruct(this.dataTableSchema, file, projectedMetricType);
            return new ContentFileStructWithMetrics(columnCount, metricsPosition, (StructLike)((Object)file), readableMetrics);
        }

        @Override
        public Iterable<FileScanTask> split(long splitSize) {
            return ImmutableList.of(this);
        }

        @VisibleForTesting
        ManifestFile manifest() {
            return this.manifest;
        }
    }

    static abstract class BaseAllFilesTableScan
    extends BaseAllMetadataTableScan {
        protected BaseAllFilesTableScan(Table table, Schema schema, MetadataTableType tableType) {
            super(table, schema, tableType);
        }

        protected BaseAllFilesTableScan(Table table, Schema schema, MetadataTableType tableType, TableScanContext context) {
            super(table, schema, tableType, context);
        }

        protected abstract CloseableIterable<ManifestFile> manifests();

        @Override
        protected CloseableIterable<FileScanTask> doPlanFiles() {
            return BaseFilesTable.planFiles(this.table(), this.manifests(), this.tableSchema(), this.schema(), this.context());
        }
    }

    static abstract class BaseFilesTableScan
    extends BaseMetadataTableScan {
        protected BaseFilesTableScan(Table table, Schema schema, MetadataTableType tableType) {
            super(table, schema, tableType);
        }

        protected BaseFilesTableScan(Table table, Schema schema, MetadataTableType tableType, TableScanContext context) {
            super(table, schema, tableType, context);
        }

        protected abstract CloseableIterable<ManifestFile> manifests();

        @Override
        protected CloseableIterable<FileScanTask> doPlanFiles() {
            return BaseFilesTable.planFiles(this.table(), this.manifests(), this.tableSchema(), this.schema(), this.context());
        }
    }
}

