/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.BaseFilesTable;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.GenericManifestEntry;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructProjection;

abstract class BaseEntriesTable
extends BaseMetadataTable {
    BaseEntriesTable(Table table, String name) {
        super(table, name);
    }

    @Override
    public Schema schema() {
        Types.StructType partitionType = Partitioning.partitionType(this.table());
        Schema schema = ManifestEntry.getSchema(partitionType);
        if (partitionType.fields().size() < 1) {
            return TypeUtil.selectNot(schema, Sets.newHashSet(102));
        }
        return schema;
    }

    static CloseableIterable<FileScanTask> planFiles(Table table, CloseableIterable<ManifestFile> manifests, Schema tableSchema, Schema projectedSchema, TableScanContext context) {
        Expression rowFilter = context.rowFilter();
        boolean caseSensitive = context.caseSensitive();
        boolean ignoreResiduals = context.ignoreResiduals();
        LoadingCache<Integer, ManifestEvaluator> evalCache = Caffeine.newBuilder().build(specId -> {
            PartitionSpec spec = table.specs().get(specId);
            PartitionSpec transformedSpec = BaseFilesTable.transformSpec(tableSchema, spec);
            return ManifestEvaluator.forRowFilter(rowFilter, transformedSpec, caseSensitive);
        });
        CloseableIterable<ManifestFile> filteredManifests = CloseableIterable.filter(manifests, manifest -> ((ManifestEvaluator)evalCache.get(manifest.partitionSpecId())).eval((ManifestFile)manifest));
        String schemaString = SchemaParser.toJson(projectedSchema);
        String specString = PartitionSpecParser.toJson(PartitionSpec.unpartitioned());
        Expression filter = ignoreResiduals ? Expressions.alwaysTrue() : rowFilter;
        ResidualEvaluator residuals = ResidualEvaluator.unpartitioned(filter);
        return CloseableIterable.transform(filteredManifests, manifest -> new ManifestReadTask(table, (ManifestFile)manifest, projectedSchema, schemaString, specString, residuals));
    }

    static class ManifestReadTask
    extends BaseFileScanTask
    implements DataTask {
        private final Schema schema;
        private final Schema fileSchema;
        private final FileIO io;
        private final ManifestFile manifest;
        private final Map<Integer, PartitionSpec> specsById;

        ManifestReadTask(Table table, ManifestFile manifest, Schema schema, String schemaString, String specString, ResidualEvaluator residuals) {
            super(DataFiles.fromManifest(manifest), null, schemaString, specString, residuals);
            this.schema = schema;
            this.io = table.io();
            this.manifest = manifest;
            this.specsById = Maps.newHashMap(table.specs());
            Type fileProjection = schema.findType("data_file");
            this.fileSchema = fileProjection != null ? new Schema(fileProjection.asStructType().fields()) : new Schema(new Types.NestedField[0]);
        }

        @VisibleForTesting
        ManifestFile manifest() {
            return this.manifest;
        }

        @Override
        public CloseableIterable<StructLike> rows() {
            CloseableIterable<StructLike> prunedRows = this.manifest.content() == ManifestContent.DATA ? CloseableIterable.transform(ManifestFiles.read(this.manifest, this.io).project(this.fileSchema).entries(), file -> (GenericManifestEntry)file) : CloseableIterable.transform(ManifestFiles.readDeleteManifest(this.manifest, this.io, this.specsById).project(this.fileSchema).entries(), file -> (GenericManifestEntry)file);
            Schema readSchema = ManifestEntry.wrapFileSchema(this.fileSchema.asStruct());
            StructProjection projection = StructProjection.create(readSchema, this.schema);
            return CloseableIterable.transform(prunedRows, projection::wrap);
        }

        @Override
        public Iterable<FileScanTask> split(long splitSize) {
            return ImmutableList.of(this);
        }
    }
}

