/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.util.v2api;

import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetNamespaceResult;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.client.builder.BaseGetNamespaceBuilder;
import org.projectnessie.error.NessieContentNotFoundException;
import org.projectnessie.error.NessieNamespaceNotFoundException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ContentResponse;
import org.projectnessie.model.Namespace;

public final class ClientSideGetNamespace
extends BaseGetNamespaceBuilder {
    private final NessieApiV2 api;

    public ClientSideGetNamespace(NessieApiV2 api) {
        this.api = api;
    }

    @Override
    public Namespace get() throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        return this.getWithResponse().getNamespace();
    }

    @Override
    public GetNamespaceResult getWithResponse() throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        ContentKey key = ContentKey.of(this.namespace.getElements());
        try {
            ContentResponse contentResponse = ((GetContentBuilder)((GetContentBuilder)this.api.getContent().refName(this.refName)).hashOnRef(this.hashOnRef)).getSingle(key);
            Content c = contentResponse.getContent();
            if (!(c instanceof Namespace)) {
                throw new NessieNamespaceNotFoundException(String.format("Namespace '%s' does not exist", key.toPathString()));
            }
            return GetNamespaceResult.of((Namespace)c, contentResponse.getEffectiveReference());
        }
        catch (NessieContentNotFoundException e) {
            throw new NessieNamespaceNotFoundException(String.format("Namespace '%s' does not exist", key.toPathString()));
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
    }
}

