/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.util.v2api;

import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.DeleteNamespaceResult;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.client.builder.BaseDeleteNamespaceBuilder;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieContentNotFoundException;
import org.projectnessie.error.NessieNamespaceNotEmptyException;
import org.projectnessie.error.NessieNamespaceNotFoundException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.CommitResponse;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ContentResponse;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;

public final class ClientSideDeleteNamespace
extends BaseDeleteNamespaceBuilder {
    private final NessieApiV2 api;

    public ClientSideDeleteNamespace(NessieApiV2 api) {
        this.api = api;
    }

    @Override
    public void delete() throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException, NessieNamespaceNotEmptyException {
        this.deleteWithResponse();
    }

    @Override
    public DeleteNamespaceResult deleteWithResponse() throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException, NessieNamespaceNotEmptyException {
        Content existing;
        Reference ref;
        ContentKey key = ContentKey.of(this.namespace.getElements());
        try {
            ContentResponse contentResponse = ((GetContentBuilder)((GetContentBuilder)this.api.getContent().refName(this.refName)).hashOnRef(this.hashOnRef)).getSingle(key);
            ref = contentResponse.getEffectiveReference();
            if (!(ref instanceof Branch)) {
                throw new NessieReferenceNotFoundException("Must only commit against a branch, but got " + ref);
            }
            existing = contentResponse.getContent();
        }
        catch (NessieContentNotFoundException e) {
            existing = null;
            ref = null;
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
        if (!(existing instanceof Namespace)) {
            throw new NessieNamespaceNotFoundException(String.format("Namespace '%s' does not exist", key.toPathString()));
        }
        try {
            if (((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().reference(ref)).filter(String.format("entry.encodedKey.startsWith('%s.')", this.namespace.name()))).stream().findAny().isPresent()) {
                throw new NessieNamespaceNotEmptyException(String.format("Namespace '%s' is not empty", key.toPathString()));
            }
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
        try {
            CommitResponse commit = ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branch((Branch)ref)).commitMeta(CommitMeta.fromMessage("delete namespace " + key)).operation(Operation.Delete.of(key)).commitWithResponse();
            return DeleteNamespaceResult.of(this.namespace, commit.getTargetBranch());
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
        catch (NessieConflictException e) {
            throw new IllegalStateException(e);
        }
    }
}

