/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.client.http.RequestContext;
import org.projectnessie.client.http.impl.HttpRuntimeConfig;

public abstract class BaseHttpRequest
extends HttpRequest {
    protected BaseHttpRequest(HttpRuntimeConfig config) {
        super(config);
    }

    protected boolean prepareRequest(RequestContext context) {
        boolean doesOutput;
        boolean postOrPut;
        this.headers.put("Accept", this.accept);
        HttpClient.Method method = context.getMethod();
        boolean bl = postOrPut = method == HttpClient.Method.PUT || method == HttpClient.Method.POST;
        if (postOrPut) {
            this.headers.put("Content-Type", this.contentsType);
        }
        boolean bl2 = doesOutput = postOrPut && context.getBody().isPresent();
        if (!this.config.isDisableCompression()) {
            this.headers.put("Accept-Encoding", "gzip;q=1.0, deflate;q=0.9");
            if (doesOutput) {
                this.headers.put("Content-Encoding", "gzip");
            }
        }
        this.config.getRequestFilters().forEach(a -> a.filter(context));
        return doesOutput;
    }

    protected void writeToOutputStream(RequestContext context, OutputStream outputStream) throws IOException {
        Object body = context.getBody().orElseThrow(NullPointerException::new);
        try (OutputStream out = this.wrapOutputStream(outputStream);){
            this.writeBody(this.config, out, body);
        }
        catch (JsonGenerationException | JsonMappingException e) {
            throw new HttpClientException(String.format("Cannot serialize body of %s request against '%s'. Unable to serialize %s", new Object[]{context.getMethod(), context.getUri(), body.getClass()}), e);
        }
    }

    private OutputStream wrapOutputStream(OutputStream base) throws IOException {
        return this.config.isDisableCompression() ? base : new GZIPOutputStream(base);
    }

    private void writeBody(HttpRuntimeConfig config, OutputStream out, Object body) throws IOException {
        Class<?> bodyType = body.getClass();
        if (bodyType != String.class) {
            ObjectWriter writer = config.getMapper().writer();
            if (config.getJsonView() != null) {
                writer = writer.withView(config.getJsonView());
            }
            writer.forType(bodyType).writeValue(out, body);
        } else {
            out.write(((String)body).getBytes(StandardCharsets.UTF_8));
        }
    }
}

