/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.projectnessie.api.v1.http.HttpConfigApi;
import org.projectnessie.api.v1.http.HttpContentApi;
import org.projectnessie.api.v1.http.HttpDiffApi;
import org.projectnessie.api.v1.http.HttpNamespaceApi;
import org.projectnessie.api.v1.http.HttpRefLogApi;
import org.projectnessie.api.v1.http.HttpTreeApi;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.HttpConfigClient;
import org.projectnessie.client.http.HttpContentClient;
import org.projectnessie.client.http.HttpDiffClient;
import org.projectnessie.client.http.HttpNamespaceClient;
import org.projectnessie.client.http.HttpRefLogClient;
import org.projectnessie.client.http.HttpTreeClient;
import org.projectnessie.client.http.NessieApiClient;
import org.projectnessie.client.http.OpentelemetryTracing;
import org.projectnessie.client.rest.NessieHttpResponseFilter;
import org.projectnessie.error.BaseNessieClientServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NessieHttpClient
extends NessieApiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(NessieHttpClient.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);

    NessieHttpClient(HttpAuthentication authentication, boolean enableTracing, HttpClient.Builder clientBuilder) {
        this(NessieHttpClient.buildClient(authentication, enableTracing, clientBuilder));
    }

    static HttpClient buildClient(HttpAuthentication authentication, boolean enableTracing, HttpClient.Builder clientBuilder) {
        clientBuilder.setObjectMapper(MAPPER);
        if (enableTracing) {
            NessieHttpClient.addTracing(clientBuilder);
        }
        if (authentication != null) {
            authentication.applyToHttpClient(clientBuilder);
        }
        clientBuilder.addResponseFilter(new NessieHttpResponseFilter(MAPPER));
        return clientBuilder.build();
    }

    private NessieHttpClient(HttpClient client) {
        super(NessieHttpClient.wrap(HttpConfigApi.class, new HttpConfigClient(client)), NessieHttpClient.wrap(HttpTreeApi.class, new HttpTreeClient(client)), NessieHttpClient.wrap(HttpContentApi.class, new HttpContentClient(client)), NessieHttpClient.wrap(HttpDiffApi.class, new HttpDiffClient(client)), NessieHttpClient.wrap(HttpRefLogApi.class, new HttpRefLogClient(client)), NessieHttpClient.wrap(HttpNamespaceApi.class, new HttpNamespaceClient(client)));
    }

    private static void addTracing(HttpClient.Builder httpClient) {
        try {
            OpentelemetryTracing.addTracing(httpClient);
        }
        catch (NoClassDefFoundError e) {
            LOGGER.warn("Failed to initialize tracing, the opentracing libraries are probably missing.", (Throwable)e);
        }
    }

    private static <T> T wrap(Class<T> iface, T delegate) {
        return (T)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)new ExceptionRewriter(delegate));
    }

    private static class ExceptionRewriter
    implements InvocationHandler {
        private final Object delegate;

        public ExceptionRewriter(Object delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(this.delegate, args);
            }
            catch (InvocationTargetException ex) {
                Throwable cause;
                Throwable targetException = ex.getTargetException();
                if (targetException instanceof HttpClientException && (cause = targetException.getCause()) instanceof BaseNessieClientServerException) {
                    throw cause;
                }
                if (targetException instanceof RuntimeException) {
                    throw targetException;
                }
                throw ex;
            }
        }
    }
}

