/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aliyun;

import java.io.Serializable;
import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.util.PropertyUtil;

public class AliyunProperties
implements Serializable {
    public static final String OSS_ENDPOINT = "oss.endpoint";
    public static final String CLIENT_ACCESS_KEY_ID = "client.access-key-id";
    public static final String CLIENT_ACCESS_KEY_SECRET = "client.access-key-secret";
    public static final String CLIENT_FACTORY = "client.factory-impl";
    public static final String OSS_STAGING_DIRECTORY = "oss.staging-dir";
    private final String ossEndpoint;
    private final String accessKeyId;
    private final String accessKeySecret;
    private final String ossStagingDirectory;

    public AliyunProperties() {
        this(ImmutableMap.of());
    }

    public AliyunProperties(Map<String, String> properties) {
        this.ossEndpoint = properties.get(OSS_ENDPOINT);
        this.accessKeyId = properties.get(CLIENT_ACCESS_KEY_ID);
        this.accessKeySecret = properties.get(CLIENT_ACCESS_KEY_SECRET);
        this.ossStagingDirectory = PropertyUtil.propertyAsString(properties, OSS_STAGING_DIRECTORY, System.getProperty("java.io.tmpdir"));
    }

    public String ossEndpoint() {
        return this.ossEndpoint;
    }

    public String accessKeyId() {
        return this.accessKeyId;
    }

    public String accessKeySecret() {
        return this.accessKeySecret;
    }

    public String ossStagingDirectory() {
        return this.ossStagingDirectory;
    }
}

