/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BasePositionDeletesScanTask;
import org.apache.iceberg.BatchScan;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.SnapshotScan;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ParallelIterable;
import org.apache.iceberg.util.TableScanUtil;

public class PositionDeletesTable
extends BaseMetadataTable {
    private final Schema schema = this.calculateSchema();
    private final int defaultSpecId;
    private final Map<Integer, PartitionSpec> specs;

    PositionDeletesTable(Table table) {
        this(table, table.name() + ".position_deletes");
    }

    PositionDeletesTable(Table table, String name) {
        super(table, name);
        this.defaultSpecId = table.spec().specId();
        this.specs = PositionDeletesTable.transformSpecs(this.schema(), table.specs());
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.POSITION_DELETES;
    }

    @Override
    public TableScan newScan() {
        throw new UnsupportedOperationException("Cannot create TableScan from table of type POSITION_DELETES");
    }

    @Override
    public BatchScan newBatchScan() {
        return new PositionDeletesBatchScan(this.table(), this.schema());
    }

    @Override
    public Schema schema() {
        return this.schema;
    }

    @Override
    public PartitionSpec spec() {
        return this.specs.get(this.defaultSpecId);
    }

    @Override
    public Map<Integer, PartitionSpec> specs() {
        return this.specs;
    }

    private Schema calculateSchema() {
        Types.StructType partitionType = Partitioning.partitionType(this.table());
        Schema result = new Schema(MetadataColumns.DELETE_FILE_PATH, MetadataColumns.DELETE_FILE_POS, Types.NestedField.optional(2147483544, "row", this.table().schema().asStruct(), "Deleted row values"), Types.NestedField.required(0x7FFFFFFA, "partition", partitionType, "Partition that position delete row belongs to"), Types.NestedField.required(0x7FFFFFFB, "spec_id", Types.IntegerType.get(), "Spec ID used to track the file containing a row"), Types.NestedField.required(0x7FFFFFFE, "delete_file_path", Types.StringType.get(), "Path of the file in which a row is stored"));
        if (partitionType.fields().size() > 0) {
            return result;
        }
        return TypeUtil.selectNot(result, Sets.newHashSet(0x7FFFFFFA));
    }

    public static class PositionDeletesBatchScan
    extends SnapshotScan<BatchScan, ScanTask, ScanTaskGroup<ScanTask>>
    implements BatchScan {
        protected PositionDeletesBatchScan(Table table, Schema schema) {
            super(table, schema, new TableScanContext());
        }

        protected PositionDeletesBatchScan(Table table, Schema schema, TableScanContext context) {
            super(table, schema, context);
        }

        @Override
        protected PositionDeletesBatchScan newRefinedScan(Table newTable, Schema newSchema, TableScanContext newContext) {
            return new PositionDeletesBatchScan(newTable, newSchema, newContext);
        }

        @Override
        public CloseableIterable<ScanTaskGroup<ScanTask>> planTasks() {
            return TableScanUtil.planTaskGroups(this.planFiles(), this.targetSplitSize(), this.splitLookback(), this.splitOpenFileCost());
        }

        @Override
        protected List<String> scanColumns() {
            return this.context().returnColumnStats() ? DELETE_SCAN_WITH_STATS_COLUMNS : DELETE_SCAN_COLUMNS;
        }

        @Override
        protected CloseableIterable<ScanTask> doPlanFiles() {
            String schemaString = SchemaParser.toJson(this.tableSchema());
            Map<Integer, PartitionSpec> transformedSpecs = BaseMetadataTable.transformSpecs(this.tableSchema(), this.table().specs());
            LoadingCache<Integer, ResidualEvaluator> residualCache = this.partitionCacheOf(transformedSpecs, spec -> ResidualEvaluator.of(spec, this.shouldIgnoreResiduals() ? Expressions.alwaysTrue() : this.filter(), this.isCaseSensitive()));
            LoadingCache<Integer, String> specStringCache = this.partitionCacheOf(transformedSpecs, PartitionSpecParser::toJson);
            LoadingCache<Integer, ManifestEvaluator> evalCache = this.partitionCacheOf(transformedSpecs, spec -> ManifestEvaluator.forRowFilter(this.filter(), spec, this.isCaseSensitive()));
            List<ManifestFile> manifests = this.snapshot().deleteManifests(this.table().io());
            CloseableIterable<ManifestFile> matchingManifests = CloseableIterable.filter(this.scanMetrics().skippedDeleteManifests(), CloseableIterable.withNoopClose(manifests), manifest -> ((ManifestEvaluator)evalCache.get(manifest.partitionSpecId())).eval((ManifestFile)manifest));
            matchingManifests = CloseableIterable.count(this.scanMetrics().scannedDeleteManifests(), matchingManifests);
            CloseableIterable tasks = CloseableIterable.transform(matchingManifests, manifest -> this.posDeletesScanTasks((ManifestFile)manifest, schemaString, transformedSpecs, residualCache, specStringCache));
            if (this.planExecutor() != null) {
                return new ParallelIterable<ScanTask>(tasks, this.planExecutor());
            }
            return CloseableIterable.concat(tasks);
        }

        private CloseableIterable<ScanTask> posDeletesScanTasks(final ManifestFile manifest, final String schemaString, final Map<Integer, PartitionSpec> transformedSpecs, final LoadingCache<Integer, ResidualEvaluator> residualCache, final LoadingCache<Integer, String> specStringCache) {
            return new CloseableIterable<ScanTask>(){
                private CloseableIterable<ScanTask> iterable;

                @Override
                public void close() throws IOException {
                    if (this.iterable != null) {
                        this.iterable.close();
                    }
                }

                @Override
                public CloseableIterator<ScanTask> iterator() {
                    CloseableIterable<ManifestEntry<DeleteFile>> deleteFileEntries = ManifestFiles.readDeleteManifest(manifest, this.table().io(), transformedSpecs).caseSensitive(this.isCaseSensitive()).select(this.scanColumns()).filterRows(this.filter()).scanMetrics(this.scanMetrics()).liveEntries();
                    CloseableIterable<ManifestEntry> positionDeleteEntries = CloseableIterable.filter(deleteFileEntries, entry -> ((DeleteFile)entry.file()).content().equals((Object)FileContent.POSITION_DELETES));
                    this.iterable = CloseableIterable.transform(positionDeleteEntries, entry -> {
                        int specId = ((DeleteFile)entry.file()).specId();
                        return new BasePositionDeletesScanTask((DeleteFile)((DeleteFile)entry.file()).copy(this.context().returnColumnStats()), schemaString, (String)specStringCache.get(specId), (ResidualEvaluator)residualCache.get(specId));
                    });
                    return this.iterable.iterator();
                }
            };
        }

        private <T> LoadingCache<Integer, T> partitionCacheOf(Map<Integer, PartitionSpec> specs, Function<PartitionSpec, T> constructor) {
            return Caffeine.newBuilder().build(specId -> {
                PartitionSpec spec = (PartitionSpec)specs.get(specId);
                return constructor.apply(spec);
            });
        }
    }
}

