/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SnapshotProducer;
import org.apache.iceberg.SnapshotSummary;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.InclusiveMetricsEvaluator;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.expressions.StrictMetricsEvaluator;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.CharSequenceWrapper;
import org.apache.iceberg.util.ManifestFileUtil;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.PartitionSet;
import org.apache.iceberg.util.StructLikeMap;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ManifestFilterManager<F extends ContentFile<F>> {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestFilterManager.class);
    private static final Joiner COMMA = Joiner.on(",");
    private final Map<Integer, PartitionSpec> specsById;
    private final PartitionSet deleteFilePartitions;
    private final PartitionSet dropPartitions;
    private final CharSequenceSet deletePaths = CharSequenceSet.empty();
    private Expression deleteExpression = Expressions.alwaysFalse();
    private long minSequenceNumber = 0L;
    private boolean hasPathOnlyDeletes = false;
    private boolean failAnyDelete = false;
    private boolean failMissingDeletePaths = false;
    private int duplicateDeleteCount = 0;
    private boolean caseSensitive = true;
    private final Map<ManifestFile, ManifestFile> filteredManifests = Maps.newConcurrentMap();
    private final Map<ManifestFile, Iterable<F>> filteredManifestToDeletedFiles = Maps.newConcurrentMap();
    private final Supplier<ExecutorService> workerPoolSupplier;

    protected ManifestFilterManager(Map<Integer, PartitionSpec> specsById, Supplier<ExecutorService> executorSupplier) {
        this.specsById = specsById;
        this.deleteFilePartitions = PartitionSet.create(specsById);
        this.dropPartitions = PartitionSet.create(specsById);
        this.workerPoolSupplier = executorSupplier;
    }

    protected abstract void deleteFile(String var1);

    protected abstract ManifestWriter<F> newManifestWriter(PartitionSpec var1);

    protected abstract ManifestReader<F> newManifestReader(ManifestFile var1);

    protected void failAnyDelete() {
        this.failAnyDelete = true;
    }

    protected void failMissingDeletePaths() {
        this.failMissingDeletePaths = true;
    }

    protected void deleteByRowFilter(Expression expr) {
        Preconditions.checkNotNull(expr, "Cannot delete files using filter: null");
        this.invalidateFilteredCache();
        this.deleteExpression = Expressions.or(this.deleteExpression, expr);
    }

    protected void dropPartition(int specId, StructLike partition) {
        Preconditions.checkNotNull(partition, "Cannot delete files in invalid partition: null");
        this.invalidateFilteredCache();
        this.dropPartitions.add(specId, partition);
    }

    protected void dropDeleteFilesOlderThan(long sequenceNumber) {
        Preconditions.checkArgument(sequenceNumber >= 0L, "Invalid minimum data sequence number: %s", sequenceNumber);
        this.minSequenceNumber = sequenceNumber;
    }

    void caseSensitive(boolean newCaseSensitive) {
        this.caseSensitive = newCaseSensitive;
    }

    void delete(F file) {
        Preconditions.checkNotNull(file, "Cannot delete file: null");
        this.invalidateFilteredCache();
        this.deletePaths.add(file.path());
        this.deleteFilePartitions.add(file.specId(), file.partition());
    }

    void delete(CharSequence path) {
        Preconditions.checkNotNull(path, "Cannot delete file path: null");
        this.invalidateFilteredCache();
        this.hasPathOnlyDeletes = true;
        this.deletePaths.add(path);
    }

    List<ManifestFile> filterManifests(Schema tableSchema, List<ManifestFile> manifests) {
        if (manifests == null || manifests.isEmpty()) {
            this.validateRequiredDeletes(new ManifestFile[0]);
            return ImmutableList.of();
        }
        ManifestFile[] filtered = new ManifestFile[manifests.size()];
        Tasks.range(filtered.length).stopOnFailure().throwFailureWhenFinished().executeWith(this.workerPoolSupplier.get()).run(index -> {
            ManifestFile manifest;
            filtered[index.intValue()] = manifest = this.filterManifest(tableSchema, (ManifestFile)manifests.get((int)index));
        });
        this.validateRequiredDeletes(filtered);
        return Arrays.asList(filtered);
    }

    SnapshotSummary.Builder buildSummary(Iterable<ManifestFile> manifests) {
        SnapshotSummary.Builder summaryBuilder = SnapshotSummary.builder();
        for (ManifestFile manifest : manifests) {
            PartitionSpec manifestSpec = this.specsById.get(manifest.partitionSpecId());
            Iterable<F> manifestDeletes = this.filteredManifestToDeletedFiles.get(manifest);
            if (manifestDeletes == null) continue;
            for (ContentFile file : manifestDeletes) {
                summaryBuilder.deletedFile(manifestSpec, file);
            }
        }
        summaryBuilder.incrementDuplicateDeletes(this.duplicateDeleteCount);
        return summaryBuilder;
    }

    private void validateRequiredDeletes(ManifestFile ... manifests) {
        if (this.failMissingDeletePaths) {
            CharSequenceSet deletedFiles = this.deletedFiles(manifests);
            ValidationException.check(deletedFiles.containsAll(this.deletePaths), "Missing required files to delete: %s", COMMA.join(Iterables.filter(this.deletePaths, path -> !deletedFiles.contains(path))));
        }
    }

    private CharSequenceSet deletedFiles(ManifestFile[] manifests) {
        CharSequenceSet deletedFiles = CharSequenceSet.empty();
        if (manifests != null) {
            for (ManifestFile manifest : manifests) {
                Iterable<F> manifestDeletes = this.filteredManifestToDeletedFiles.get(manifest);
                if (manifestDeletes == null) continue;
                for (ContentFile file : manifestDeletes) {
                    deletedFiles.add(file.path());
                }
            }
        }
        return deletedFiles;
    }

    void cleanUncommitted(Set<ManifestFile> committed) {
        ArrayList<Map.Entry<ManifestFile, ManifestFile>> filterEntries = Lists.newArrayList(this.filteredManifests.entrySet());
        for (Map.Entry entry : filterEntries) {
            ManifestFile manifest = (ManifestFile)entry.getKey();
            ManifestFile filtered = (ManifestFile)entry.getValue();
            if (committed.contains(filtered)) continue;
            if (!manifest.equals(filtered)) {
                this.deleteFile(filtered.path());
            }
            this.filteredManifests.remove(manifest);
        }
    }

    private void invalidateFilteredCache() {
        this.cleanUncommitted(SnapshotProducer.EMPTY_SET);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ManifestFile filterManifest(Schema tableSchema, ManifestFile manifest) {
        boolean hasLiveFiles;
        ManifestFile cached = this.filteredManifests.get(manifest);
        if (cached != null) {
            return cached;
        }
        boolean bl = hasLiveFiles = manifest.hasAddedFiles() || manifest.hasExistingFiles();
        if (!hasLiveFiles || !this.canContainDeletedFiles(manifest)) {
            this.filteredManifests.put(manifest, manifest);
            return manifest;
        }
        try (ManifestReader<F> reader = this.newManifestReader(manifest);){
            PartitionSpec spec = reader.spec();
            PartitionAndMetricsEvaluator evaluator = new PartitionAndMetricsEvaluator(tableSchema, spec, this.deleteExpression);
            boolean hasDeletedFiles = this.manifestHasDeletedFiles(evaluator, reader);
            if (!hasDeletedFiles) {
                this.filteredManifests.put(manifest, manifest);
                ManifestFile manifestFile = manifest;
                return manifestFile;
            }
            ManifestFile manifestFile = this.filterManifestWithDeletedFiles(evaluator, manifest, reader);
            return manifestFile;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to close manifest: %s", manifest);
        }
    }

    private boolean canContainDeletedFiles(ManifestFile manifest) {
        boolean canContainExpressionDeletes;
        if (this.deleteExpression != null && this.deleteExpression != Expressions.alwaysFalse()) {
            ManifestEvaluator manifestEvaluator = ManifestEvaluator.forRowFilter(this.deleteExpression, this.specsById.get(manifest.partitionSpecId()), this.caseSensitive);
            canContainExpressionDeletes = manifestEvaluator.eval(manifest);
        } else {
            canContainExpressionDeletes = false;
        }
        boolean canContainDroppedPartitions = this.dropPartitions.size() > 0 ? ManifestFileUtil.canContainAny(manifest, this.dropPartitions, this.specsById) : false;
        boolean canContainDroppedFiles = this.hasPathOnlyDeletes ? true : (this.deletePaths.size() > 0 ? ManifestFileUtil.canContainAny(manifest, this.deleteFilePartitions, this.specsById) : false);
        boolean canContainDropBySeq = manifest.content() == ManifestContent.DELETES && manifest.minSequenceNumber() < this.minSequenceNumber;
        return canContainExpressionDeletes || canContainDroppedPartitions || canContainDroppedFiles || canContainDropBySeq;
    }

    private boolean manifestHasDeletedFiles(PartitionAndMetricsEvaluator evaluator, ManifestReader<F> reader) {
        boolean isDelete = reader.isDeleteManifestReader();
        for (ManifestEntry manifestEntry : reader.liveEntries()) {
            boolean markedForDelete;
            Object file = manifestEntry.file();
            boolean bl = markedForDelete = this.deletePaths.contains(file.path()) || this.dropPartitions.contains(file.specId(), file.partition()) || isDelete && manifestEntry.isLive() && manifestEntry.dataSequenceNumber() > 0L && manifestEntry.dataSequenceNumber() < this.minSequenceNumber;
            if (!markedForDelete && !evaluator.rowsMightMatch(file)) continue;
            boolean allRowsMatch = markedForDelete || evaluator.rowsMustMatch(file);
            ValidationException.check(allRowsMatch || isDelete, "Cannot delete file where some, but not all, rows match filter %s: %s", this.deleteExpression, file.path());
            if (!allRowsMatch) continue;
            if (this.failAnyDelete) {
                throw new DeleteException(reader.spec().partitionToPath(file.partition()));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManifestFile filterManifestWithDeletedFiles(PartitionAndMetricsEvaluator evaluator, ManifestFile manifest, ManifestReader<F> reader) {
        boolean isDelete = reader.isDeleteManifestReader();
        ArrayList deletedFiles = Lists.newArrayList();
        HashSet deletedPaths = Sets.newHashSet();
        try {
            try (ManifestWriter<F> writer = this.newManifestWriter(reader.spec());){
                reader.entries().forEach(entry -> {
                    boolean markedForDelete;
                    Object file = entry.file();
                    boolean bl = markedForDelete = this.deletePaths.contains(file.path()) || this.dropPartitions.contains(file.specId(), file.partition()) || isDelete && entry.isLive() && entry.dataSequenceNumber() > 0L && entry.dataSequenceNumber() < this.minSequenceNumber;
                    if (entry.status() != ManifestEntry.Status.DELETED) {
                        if (markedForDelete || evaluator.rowsMightMatch(file)) {
                            boolean allRowsMatch = markedForDelete || evaluator.rowsMustMatch(file);
                            ValidationException.check(allRowsMatch || isDelete, "Cannot delete file where some, but not all, rows match filter %s: %s", this.deleteExpression, file.path());
                            if (allRowsMatch) {
                                writer.delete((ManifestEntry<F>)entry);
                                CharSequenceWrapper wrapper = CharSequenceWrapper.wrap(entry.file().path());
                                if (deletedPaths.contains(wrapper)) {
                                    LOG.warn("Deleting a duplicate path from manifest {}: {}", (Object)manifest.path(), (Object)wrapper.get());
                                    ++this.duplicateDeleteCount;
                                } else {
                                    deletedFiles.add((ContentFile)entry.file().copyWithoutStats());
                                }
                                deletedPaths.add(wrapper);
                            } else {
                                writer.existing((ManifestEntry<F>)entry);
                            }
                        } else {
                            writer.existing((ManifestEntry<F>)entry);
                        }
                    }
                });
            }
            ManifestFile filtered = writer.toManifestFile();
            this.filteredManifests.put(manifest, filtered);
            this.filteredManifestToDeletedFiles.put(filtered, deletedFiles);
            return filtered;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to close manifest writer", new Object[0]);
        }
    }

    private class PartitionAndMetricsEvaluator {
        private final Schema tableSchema;
        private final ResidualEvaluator residualEvaluator;
        private final StructLikeMap<Pair<InclusiveMetricsEvaluator, StrictMetricsEvaluator>> metricsEvaluators;

        PartitionAndMetricsEvaluator(Schema tableSchema, PartitionSpec spec, Expression expr) {
            this.tableSchema = tableSchema;
            this.residualEvaluator = ResidualEvaluator.of(spec, expr, ManifestFilterManager.this.caseSensitive);
            this.metricsEvaluators = StructLikeMap.create(spec.partitionType());
        }

        boolean rowsMightMatch(F file) {
            Pair<InclusiveMetricsEvaluator, StrictMetricsEvaluator> evaluators = this.metricsEvaluators(file);
            InclusiveMetricsEvaluator inclusiveMetricsEvaluator = evaluators.first();
            return inclusiveMetricsEvaluator.eval((ContentFile<?>)file);
        }

        boolean rowsMustMatch(F file) {
            Pair<InclusiveMetricsEvaluator, StrictMetricsEvaluator> evaluators = this.metricsEvaluators(file);
            StrictMetricsEvaluator strictMetricsEvaluator = evaluators.second();
            return strictMetricsEvaluator.eval((ContentFile<?>)file);
        }

        private Pair<InclusiveMetricsEvaluator, StrictMetricsEvaluator> metricsEvaluators(F file) {
            PartitionData partition = (PartitionData)file.partition();
            if (!this.metricsEvaluators.containsKey(partition)) {
                Expression residual = this.residualEvaluator.residualFor(partition);
                InclusiveMetricsEvaluator inclusive = new InclusiveMetricsEvaluator(this.tableSchema, residual, ManifestFilterManager.this.caseSensitive);
                StrictMetricsEvaluator strict = new StrictMetricsEvaluator(this.tableSchema, residual, ManifestFilterManager.this.caseSensitive);
                this.metricsEvaluators.put(partition.copy(), Pair.of(inclusive, strict));
            }
            return this.metricsEvaluators.get(partition);
        }
    }

    protected static class DeleteException
    extends ValidationException {
        private final String partition;

        private DeleteException(String partition) {
            super("Operation would delete existing data", new Object[0]);
            this.partition = partition;
        }

        public String partition() {
            return this.partition;
        }
    }
}

