/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.BaseIncrementalAppendScan;
import org.apache.iceberg.BaseIncrementalChangelogScan;
import org.apache.iceberg.BaseOverwriteFiles;
import org.apache.iceberg.BaseReplacePartitions;
import org.apache.iceberg.BaseReplaceSortOrder;
import org.apache.iceberg.BaseRewriteFiles;
import org.apache.iceberg.BaseRewriteManifests;
import org.apache.iceberg.BaseRowDelta;
import org.apache.iceberg.BaseUpdatePartitionSpec;
import org.apache.iceberg.DataTableScan;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.ExpireSnapshots;
import org.apache.iceberg.FastAppend;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.IncrementalAppendScan;
import org.apache.iceberg.IncrementalChangelogScan;
import org.apache.iceberg.ManageSnapshots;
import org.apache.iceberg.MergeAppend;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PropertiesUpdate;
import org.apache.iceberg.RemoveSnapshots;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaUpdate;
import org.apache.iceberg.SerializableTable;
import org.apache.iceberg.SetLocation;
import org.apache.iceberg.SetStatistics;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotManager;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.StreamingDelete;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.Transactions;
import org.apache.iceberg.UpdateLocation;
import org.apache.iceberg.UpdatePartitionSpec;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.UpdateStatistics;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.metrics.LoggingMetricsReporter;
import org.apache.iceberg.metrics.MetricsReporter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class BaseTable
implements Table,
HasTableOperations,
Serializable {
    private final TableOperations ops;
    private final String name;
    private final MetricsReporter reporter;

    public BaseTable(TableOperations ops, String name) {
        this(ops, name, LoggingMetricsReporter.instance());
    }

    public BaseTable(TableOperations ops, String name, MetricsReporter reporter) {
        Preconditions.checkNotNull(reporter, "reporter cannot be null");
        this.ops = ops;
        this.name = name;
        this.reporter = reporter;
    }

    @Override
    public TableOperations operations() {
        return this.ops;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void refresh() {
        this.ops.refresh();
    }

    @Override
    public TableScan newScan() {
        return new DataTableScan(this, this.schema(), new TableScanContext().reportWith(this.reporter));
    }

    @Override
    public IncrementalAppendScan newIncrementalAppendScan() {
        return new BaseIncrementalAppendScan(this, this.schema(), new TableScanContext().reportWith(this.reporter));
    }

    @Override
    public IncrementalChangelogScan newIncrementalChangelogScan() {
        return new BaseIncrementalChangelogScan(this);
    }

    @Override
    public Schema schema() {
        return this.ops.current().schema();
    }

    @Override
    public Map<Integer, Schema> schemas() {
        return this.ops.current().schemasById();
    }

    @Override
    public PartitionSpec spec() {
        return this.ops.current().spec();
    }

    @Override
    public Map<Integer, PartitionSpec> specs() {
        return this.ops.current().specsById();
    }

    @Override
    public SortOrder sortOrder() {
        return this.ops.current().sortOrder();
    }

    @Override
    public Map<Integer, SortOrder> sortOrders() {
        return this.ops.current().sortOrdersById();
    }

    @Override
    public Map<String, String> properties() {
        return this.ops.current().properties();
    }

    @Override
    public String location() {
        return this.ops.current().location();
    }

    @Override
    public Snapshot currentSnapshot() {
        return this.ops.current().currentSnapshot();
    }

    @Override
    public Snapshot snapshot(long snapshotId) {
        return this.ops.current().snapshot(snapshotId);
    }

    @Override
    public Iterable<Snapshot> snapshots() {
        return this.ops.current().snapshots();
    }

    @Override
    public List<HistoryEntry> history() {
        return this.ops.current().snapshotLog();
    }

    @Override
    public UpdateSchema updateSchema() {
        return new SchemaUpdate(this.ops);
    }

    @Override
    public UpdatePartitionSpec updateSpec() {
        return new BaseUpdatePartitionSpec(this.ops);
    }

    @Override
    public UpdateProperties updateProperties() {
        return new PropertiesUpdate(this.ops);
    }

    @Override
    public ReplaceSortOrder replaceSortOrder() {
        return new BaseReplaceSortOrder(this.ops);
    }

    @Override
    public UpdateLocation updateLocation() {
        return new SetLocation(this.ops);
    }

    @Override
    public AppendFiles newAppend() {
        return (AppendFiles)new MergeAppend(this.name, this.ops).reportWith(this.reporter);
    }

    @Override
    public AppendFiles newFastAppend() {
        return (AppendFiles)new FastAppend(this.name, this.ops).reportWith(this.reporter);
    }

    @Override
    public RewriteFiles newRewrite() {
        return (RewriteFiles)new BaseRewriteFiles(this.name, this.ops).reportWith(this.reporter);
    }

    @Override
    public RewriteManifests rewriteManifests() {
        return (RewriteManifests)new BaseRewriteManifests(this.ops).reportWith(this.reporter);
    }

    @Override
    public OverwriteFiles newOverwrite() {
        return (OverwriteFiles)new BaseOverwriteFiles(this.name, this.ops).reportWith(this.reporter);
    }

    @Override
    public RowDelta newRowDelta() {
        return (RowDelta)new BaseRowDelta(this.name, this.ops).reportWith(this.reporter);
    }

    @Override
    public ReplacePartitions newReplacePartitions() {
        return (ReplacePartitions)new BaseReplacePartitions(this.name, this.ops).reportWith(this.reporter);
    }

    @Override
    public DeleteFiles newDelete() {
        return (DeleteFiles)new StreamingDelete(this.name, this.ops).reportWith(this.reporter);
    }

    @Override
    public UpdateStatistics updateStatistics() {
        return new SetStatistics(this.ops);
    }

    @Override
    public ExpireSnapshots expireSnapshots() {
        return new RemoveSnapshots(this.ops);
    }

    @Override
    public ManageSnapshots manageSnapshots() {
        return new SnapshotManager(this.name, this.ops);
    }

    @Override
    public Transaction newTransaction() {
        return Transactions.newTransaction(this.name, this.ops, this.reporter);
    }

    @Override
    public FileIO io() {
        return this.ops.io();
    }

    @Override
    public EncryptionManager encryption() {
        return this.ops.encryption();
    }

    @Override
    public LocationProvider locationProvider() {
        return this.ops.locationProvider();
    }

    @Override
    public List<StatisticsFile> statisticsFiles() {
        return this.ops.current().statisticsFiles();
    }

    @Override
    public Map<String, SnapshotRef> refs() {
        return this.ops.current().refs();
    }

    public String toString() {
        return this.name();
    }

    Object writeReplace() {
        return SerializableTable.copyOf(this);
    }
}

