/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Iterator;
import org.roaringbitmap.ArrayContainer;
import org.roaringbitmap.ArraysShim;
import org.roaringbitmap.BitmapContainer;
import org.roaringbitmap.Container;
import org.roaringbitmap.ContainerBatchIterator;
import org.roaringbitmap.IntConsumer;
import org.roaringbitmap.PeekableCharIterator;
import org.roaringbitmap.PeekableCharRankIterator;
import org.roaringbitmap.RelativeRangeConsumer;
import org.roaringbitmap.ReverseRunContainerCharIterator;
import org.roaringbitmap.RunBatchIterator;
import org.roaringbitmap.RunContainerCharIterator;
import org.roaringbitmap.RunContainerCharRankIterator;
import org.roaringbitmap.Util;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableRunContainer;

public final class RunContainer
extends Container
implements Cloneable {
    private static final int DEFAULT_INIT_SIZE = 4;
    private static final boolean ENABLE_GALLOPING_AND = false;
    private static final long serialVersionUID = 1L;
    private char[] valueslength;
    int nbrruns = 0;

    private static int branchyUnsignedInterleavedBinarySearch(char[] array, int begin, int end, char k) {
        int low = begin;
        int high = end - 1;
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            char middleValue = array[2 * middleIndex];
            if (middleValue < k) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > k) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    private static int hybridUnsignedInterleavedBinarySearch(char[] array, int begin, int end, char k) {
        int x;
        int low = begin;
        int high = end - 1;
        while (low + 16 <= high) {
            int middleIndex = low + high >>> 1;
            char middleValue = array[2 * middleIndex];
            if (middleValue < k) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > k) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        for (x = low; x <= high; ++x) {
            char val = array[2 * x];
            if (val < k) continue;
            if (val != k) break;
            return x;
        }
        return -(x + 1);
    }

    protected static int serializedSizeInBytes(int numberOfRuns) {
        return 2 + 4 * numberOfRuns;
    }

    private static int unsignedInterleavedBinarySearch(char[] array, int begin, int end, char k) {
        return RunContainer.hybridUnsignedInterleavedBinarySearch(array, begin, end, k);
    }

    public RunContainer() {
        this(4);
    }

    protected RunContainer(ArrayContainer arr, int nbrRuns) {
        this.nbrruns = nbrRuns;
        this.valueslength = new char[2 * nbrRuns];
        if (nbrRuns == 0) {
            return;
        }
        int prevVal = -2;
        int runLen = 0;
        int runCount = 0;
        for (int i = 0; i < arr.cardinality; ++i) {
            int curVal = arr.content[i];
            if (curVal == prevVal + 1) {
                ++runLen;
            } else {
                if (runCount > 0) {
                    this.setLength(runCount - 1, (char)runLen);
                }
                this.setValue(runCount, (char)curVal);
                runLen = 0;
                ++runCount;
            }
            prevVal = curVal;
        }
        this.setLength(runCount - 1, (char)runLen);
    }

    public RunContainer(int firstOfRun, int lastOfRun) {
        this.nbrruns = 1;
        this.valueslength = new char[]{(char)firstOfRun, (char)(lastOfRun - 1 - firstOfRun)};
    }

    protected RunContainer(BitmapContainer bc, int nbrRuns) {
        this.nbrruns = nbrRuns;
        this.valueslength = new char[2 * nbrRuns];
        if (nbrRuns == 0) {
            return;
        }
        int longCtr = 0;
        long curWord = bc.bitmap[0];
        int runCount = 0;
        while (true) {
            int runEnd;
            if (curWord == 0L && longCtr < bc.bitmap.length - 1) {
                curWord = bc.bitmap[++longCtr];
                continue;
            }
            if (curWord == 0L) {
                return;
            }
            int localRunStart = Long.numberOfTrailingZeros(curWord);
            int runStart = localRunStart + 64 * longCtr;
            long curWordWith1s = curWord | curWord - 1L;
            while (curWordWith1s == -1L && longCtr < bc.bitmap.length - 1) {
                curWordWith1s = bc.bitmap[++longCtr];
            }
            if (curWordWith1s == -1L) {
                runEnd = 64 + longCtr * 64;
                this.setValue(runCount, (char)runStart);
                this.setLength(runCount, (char)(runEnd - runStart - 1));
                return;
            }
            int localRunEnd = Long.numberOfTrailingZeros(curWordWith1s ^ 0xFFFFFFFFFFFFFFFFL);
            runEnd = localRunEnd + longCtr * 64;
            this.setValue(runCount, (char)runStart);
            this.setLength(runCount, (char)(runEnd - runStart - 1));
            ++runCount;
            curWord = curWordWith1s & curWordWith1s + 1L;
        }
    }

    public RunContainer(int capacity) {
        this.valueslength = new char[2 * capacity];
    }

    private RunContainer(int nbrruns, char[] valueslength) {
        this.nbrruns = nbrruns;
        this.valueslength = Arrays.copyOf(valueslength, valueslength.length);
    }

    public RunContainer(MappeableRunContainer bc) {
        this.nbrruns = bc.numberOfRuns();
        this.valueslength = bc.toCharArray();
    }

    public RunContainer(char[] array, int numRuns) {
        if (array.length < 2 * numRuns) {
            throw new RuntimeException("Mismatch between buffer and numRuns");
        }
        this.nbrruns = numRuns;
        this.valueslength = array;
    }

    @Override
    public Container add(int begin, int end) {
        RunContainer rc = (RunContainer)this.clone();
        return rc.iadd(begin, end);
    }

    @Override
    public Container add(char k) {
        int index = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, k);
        if (index >= 0) {
            return this;
        }
        if ((index = -index - 2) >= 0) {
            char le;
            int offset = k - this.getValue(index);
            if (offset <= (le = this.getLength(index))) {
                return this;
            }
            if (offset == le + '\u0001') {
                if (index + 1 < this.nbrruns && this.getValue(index + 1) == k + '\u0001') {
                    this.setLength(index, (char)(this.getValue(index + 1) + this.getLength(index + 1) - this.getValue(index)));
                    this.recoverRoomAtIndex(index + 1);
                    return this;
                }
                this.incrementLength(index);
                return this;
            }
            if (index + 1 < this.nbrruns && this.getValue(index + 1) == k + '\u0001') {
                this.setValue(index + 1, k);
                this.setLength(index + 1, (char)(this.getLength(index + 1) + '\u0001'));
                return this;
            }
        }
        if (index == -1 && 0 < this.nbrruns && this.getValue(0) == k + '\u0001') {
            this.incrementLength(0);
            this.decrementValue(0);
            return this;
        }
        this.makeRoomAtIndex(index + 1);
        this.setValue(index + 1, k);
        this.setLength(index + 1, '\u0000');
        return this;
    }

    @Override
    public Container and(ArrayContainer x) {
        ArrayContainer ac = new ArrayContainer(x.cardinality);
        if (this.nbrruns == 0) {
            return ac;
        }
        int rlepos = 0;
        int arraypos = 0;
        char rleval = this.getValue(rlepos);
        char rlelength = this.getLength(rlepos);
        while (arraypos < x.cardinality) {
            char arrayval = x.content[arraypos];
            while (rleval + rlelength < arrayval) {
                if (++rlepos == this.nbrruns) {
                    return ac;
                }
                rleval = this.getValue(rlepos);
                rlelength = this.getLength(rlepos);
            }
            if (rleval > arrayval) {
                arraypos = Util.advanceUntil(x.content, arraypos, x.cardinality, rleval);
                continue;
            }
            ac.content[ac.cardinality] = arrayval;
            ++ac.cardinality;
            ++arraypos;
        }
        return ac;
    }

    @Override
    public Container and(BitmapContainer x) {
        int card = this.getCardinality();
        if (card <= 4096) {
            if (card > x.cardinality) {
                card = x.cardinality;
            }
            ArrayContainer answer = new ArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
                int runStart = this.getValue(rlepos);
                int runEnd = runStart + this.getLength(rlepos);
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    if (!x.contains((char)runValue)) continue;
                    answer.content[answer.cardinality++] = (char)runValue;
                }
            }
            return answer;
        }
        BitmapContainer answer = x.clone();
        int start = 0;
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            char end = this.getValue(rlepos);
            int prevOnes = answer.cardinalityInRange(start, end);
            Util.resetBitmapRange(answer.bitmap, start, end);
            answer.updateCardinality(prevOnes, 0);
            start = end + this.getLength(rlepos) + 1;
        }
        int ones = answer.cardinalityInRange(start, 65536);
        Util.resetBitmapRange(answer.bitmap, start, 65536);
        answer.updateCardinality(ones, 0);
        if (answer.getCardinality() > 4096) {
            return answer;
        }
        return answer.toArrayContainer();
    }

    @Override
    public Container and(RunContainer x) {
        int maxRunsAfterIntersection = this.nbrruns + x.nbrruns;
        RunContainer answer = new RunContainer(new char[2 * maxRunsAfterIntersection], 0);
        if (this.isEmpty()) {
            return answer;
        }
        int rlepos = 0;
        int xrlepos = 0;
        char start = this.getValue(rlepos);
        int end = start + this.getLength(rlepos) + 1;
        char xstart = x.getValue(xrlepos);
        int xend = xstart + x.getLength(xrlepos) + 1;
        while (rlepos < this.nbrruns && xrlepos < x.nbrruns) {
            int earliestend;
            if (end <= xstart) {
                if (++rlepos >= this.nbrruns) continue;
                start = this.getValue(rlepos);
                end = start + this.getLength(rlepos) + 1;
                continue;
            }
            if (xend <= start) {
                if (++xrlepos >= x.nbrruns) continue;
                xstart = x.getValue(xrlepos);
                xend = xstart + x.getLength(xrlepos) + 1;
                continue;
            }
            int lateststart = Math.max(start, xstart);
            if (end == xend) {
                earliestend = end;
                ++xrlepos;
                if (++rlepos < this.nbrruns) {
                    start = this.getValue(rlepos);
                    end = start + this.getLength(rlepos) + 1;
                }
                if (xrlepos < x.nbrruns) {
                    xstart = x.getValue(xrlepos);
                    xend = xstart + x.getLength(xrlepos) + 1;
                }
            } else if (end < xend) {
                earliestend = end;
                if (++rlepos < this.nbrruns) {
                    start = this.getValue(rlepos);
                    end = start + this.getLength(rlepos) + 1;
                }
            } else {
                earliestend = xend;
                if (++xrlepos < x.nbrruns) {
                    xstart = x.getValue(xrlepos);
                    xend = xstart + x.getLength(xrlepos) + 1;
                }
            }
            answer.valueslength[2 * answer.nbrruns] = (char)lateststart;
            answer.valueslength[2 * answer.nbrruns + 1] = (char)(earliestend - lateststart - 1);
            ++answer.nbrruns;
        }
        return answer.toEfficientContainer();
    }

    @Override
    public int andCardinality(ArrayContainer x) {
        if (this.nbrruns == 0) {
            return x.cardinality;
        }
        int rlepos = 0;
        int arraypos = 0;
        int andCardinality = 0;
        char rleval = this.getValue(rlepos);
        char rlelength = this.getLength(rlepos);
        while (arraypos < x.cardinality) {
            char arrayval = x.content[arraypos];
            while (rleval + rlelength < arrayval) {
                if (++rlepos == this.nbrruns) {
                    return andCardinality;
                }
                rleval = this.getValue(rlepos);
                rlelength = this.getLength(rlepos);
            }
            if (rleval > arrayval) {
                arraypos = Util.advanceUntil(x.content, arraypos, x.cardinality, this.getValue(rlepos));
                continue;
            }
            ++andCardinality;
            ++arraypos;
        }
        return andCardinality;
    }

    @Override
    public int andCardinality(BitmapContainer x) {
        int cardinality = 0;
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            char runStart = this.getValue(rlepos);
            int runEnd = runStart + this.getLength(rlepos);
            cardinality += x.cardinalityInRange(runStart, runEnd + 1);
        }
        return cardinality;
    }

    @Override
    public int andCardinality(RunContainer x) {
        int cardinality = 0;
        int rlepos = 0;
        int xrlepos = 0;
        char start = this.getValue(rlepos);
        int end = start + this.getLength(rlepos) + 1;
        char xstart = x.getValue(xrlepos);
        int xend = xstart + x.getLength(xrlepos) + 1;
        while (rlepos < this.nbrruns && xrlepos < x.nbrruns) {
            int earliestend;
            if (end <= xstart) {
                if (++rlepos >= this.nbrruns) continue;
                start = this.getValue(rlepos);
                end = start + this.getLength(rlepos) + 1;
                continue;
            }
            if (xend <= start) {
                if (++xrlepos >= x.nbrruns) continue;
                xstart = x.getValue(xrlepos);
                xend = xstart + x.getLength(xrlepos) + 1;
                continue;
            }
            int lateststart = Math.max(start, xstart);
            if (end == xend) {
                earliestend = end;
                ++xrlepos;
                if (++rlepos < this.nbrruns) {
                    start = this.getValue(rlepos);
                    end = start + this.getLength(rlepos) + 1;
                }
                if (xrlepos < x.nbrruns) {
                    xstart = x.getValue(xrlepos);
                    xend = xstart + x.getLength(xrlepos) + 1;
                }
            } else if (end < xend) {
                earliestend = end;
                if (++rlepos < this.nbrruns) {
                    start = this.getValue(rlepos);
                    end = start + this.getLength(rlepos) + 1;
                }
            } else {
                earliestend = xend;
                if (++xrlepos < x.nbrruns) {
                    xstart = x.getValue(xrlepos);
                    xend = xstart + x.getLength(xrlepos) + 1;
                }
            }
            cardinality += earliestend - lateststart;
        }
        return cardinality;
    }

    @Override
    public Container andNot(ArrayContainer x) {
        int arbitrary_threshold = 32;
        if (x.getCardinality() < 32) {
            return this.lazyandNot(x).toEfficientContainer();
        }
        int card = this.getCardinality();
        if (card <= 4096) {
            ArrayContainer ac = new ArrayContainer(card);
            ac.cardinality = Util.unsignedDifference(this.getCharIterator(), x.getCharIterator(), ac.content);
            return ac;
        }
        return this.toBitmapOrArrayContainer(card).iandNot(x);
    }

    @Override
    public Container andNot(BitmapContainer x) {
        int card = this.getCardinality();
        if (card <= 4096) {
            ArrayContainer answer = new ArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
                int runStart = this.getValue(rlepos);
                int runEnd = runStart + this.getLength(rlepos);
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    if (x.contains((char)runValue)) continue;
                    answer.content[answer.cardinality++] = (char)runValue;
                }
            }
            return answer;
        }
        BitmapContainer answer = x.clone();
        int lastPos = 0;
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            char start = this.getValue(rlepos);
            int end = start + this.getLength(rlepos) + 1;
            int prevOnes = answer.cardinalityInRange(lastPos, start);
            int flippedOnes = answer.cardinalityInRange(start, end);
            Util.resetBitmapRange(answer.bitmap, lastPos, start);
            Util.flipBitmapRange(answer.bitmap, start, end);
            answer.updateCardinality(prevOnes + flippedOnes, end - start - flippedOnes);
            lastPos = end;
        }
        int ones = answer.cardinalityInRange(lastPos, 65536);
        Util.resetBitmapRange(answer.bitmap, lastPos, 65536);
        answer.updateCardinality(ones, 0);
        if (answer.getCardinality() > 4096) {
            return answer;
        }
        return answer.toArrayContainer();
    }

    @Override
    public Container andNot(RunContainer x) {
        RunContainer answer = new RunContainer(new char[2 * (this.nbrruns + x.nbrruns)], 0);
        int rlepos = 0;
        int xrlepos = 0;
        int start = this.getValue(rlepos);
        int end = start + this.getLength(rlepos) + 1;
        char xstart = x.getValue(xrlepos);
        int xend = xstart + x.getLength(xrlepos) + 1;
        while (rlepos < this.nbrruns && xrlepos < x.nbrruns) {
            if (end <= xstart) {
                answer.valueslength[2 * answer.nbrruns] = (char)start;
                answer.valueslength[2 * answer.nbrruns + 1] = (char)(end - start - 1);
                ++answer.nbrruns;
                if (++rlepos >= this.nbrruns) continue;
                start = this.getValue(rlepos);
                end = start + this.getLength(rlepos) + 1;
                continue;
            }
            if (xend <= start) {
                if (++xrlepos >= x.nbrruns) continue;
                xstart = x.getValue(xrlepos);
                xend = xstart + x.getLength(xrlepos) + 1;
                continue;
            }
            if (start < xstart) {
                answer.valueslength[2 * answer.nbrruns] = (char)start;
                answer.valueslength[2 * answer.nbrruns + 1] = (char)(xstart - start - 1);
                ++answer.nbrruns;
            }
            if (xend < end) {
                start = xend;
                continue;
            }
            if (++rlepos >= this.nbrruns) continue;
            start = this.getValue(rlepos);
            end = start + this.getLength(rlepos) + 1;
        }
        if (rlepos < this.nbrruns) {
            answer.valueslength[2 * answer.nbrruns] = (char)start;
            answer.valueslength[2 * answer.nbrruns + 1] = (char)(end - start - 1);
            ++answer.nbrruns;
            if (++rlepos < this.nbrruns) {
                System.arraycopy(this.valueslength, 2 * rlepos, answer.valueslength, 2 * answer.nbrruns, 2 * (this.nbrruns - rlepos));
                answer.nbrruns = answer.nbrruns + this.nbrruns - rlepos;
            }
        }
        return answer.toEfficientContainer();
    }

    private void appendValueLength(int value, int index) {
        char length;
        char previousValue = this.getValue(index);
        int offset = value - previousValue;
        if (offset > (length = this.getLength(index))) {
            this.setLength(index, (char)offset);
        }
    }

    private boolean canPrependValueLength(int value, int index) {
        if (index < this.nbrruns) {
            char nextValue = this.getValue(index);
            return nextValue == value + 1;
        }
        return false;
    }

    @Override
    public void clear() {
        this.nbrruns = 0;
    }

    @Override
    public Container clone() {
        return new RunContainer(this.nbrruns, this.valueslength);
    }

    @Override
    public boolean isEmpty() {
        return this.nbrruns == 0;
    }

    private void closeValueLength(int value, int index) {
        char initialValue = this.getValue(index);
        this.setLength(index, (char)(value - initialValue));
    }

    @Override
    public boolean contains(char x) {
        int index = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, x);
        if (index >= 0) {
            return true;
        }
        if ((index = -index - 2) != -1) {
            char le;
            int offset = x - this.getValue(index);
            return offset <= (le = this.getLength(index));
        }
        return false;
    }

    @Override
    public boolean contains(int minimum, int supremum) {
        for (int i = 0; i < this.numberOfRuns(); ++i) {
            char start = this.getValue(i);
            char length = this.getLength(i);
            int stop = start + length + 1;
            if (start >= supremum) break;
            if (minimum < start || supremum > stop) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean contains(RunContainer runContainer) {
        int i1 = 0;
        int i2 = 0;
        while (i1 < this.numberOfRuns() && i2 < runContainer.numberOfRuns()) {
            char start1 = this.getValue(i1);
            int stop1 = start1 + this.getLength(i1);
            char start2 = runContainer.getValue(i2);
            int stop2 = start2 + runContainer.getLength(i2);
            if (start1 > start2) {
                return false;
            }
            if (stop1 > stop2) {
                ++i2;
                continue;
            }
            if (stop1 == stop2) {
                ++i1;
                ++i2;
                continue;
            }
            ++i1;
        }
        return i2 == runContainer.numberOfRuns();
    }

    @Override
    protected boolean contains(ArrayContainer arrayContainer) {
        int cardinality = this.getCardinality();
        int runCount = this.numberOfRuns();
        if (arrayContainer.getCardinality() > cardinality) {
            return false;
        }
        int ia = 0;
        int ir = 0;
        while (ia < arrayContainer.getCardinality() && ir < runCount) {
            char start = this.getValue(ir);
            int stop = start + this.getLength(ir);
            char ac = arrayContainer.content[ia];
            if (ac < start) {
                return false;
            }
            if (ac > stop) {
                ++ir;
                continue;
            }
            ++ia;
        }
        return ia == arrayContainer.getCardinality();
    }

    @Override
    protected boolean contains(BitmapContainer bitmapContainer) {
        int ib;
        int cardinality = this.getCardinality();
        if (bitmapContainer.getCardinality() != -1 && bitmapContainer.getCardinality() > cardinality) {
            return false;
        }
        int runCount = this.numberOfRuns();
        int ir = 0;
        for (ib = 0; ib < bitmapContainer.bitmap.length && ir < runCount; ib = (int)((char)(ib + 1))) {
            long w = bitmapContainer.bitmap[ib];
            while (w != 0L && ir < runCount) {
                char start = this.getValue(ir);
                int stop = start + this.getLength(ir);
                long t2 = w & -w;
                long r = (long)ib * 64L + (long)Long.numberOfTrailingZeros(w);
                if (r < (long)start) {
                    return false;
                }
                if (r > (long)stop) {
                    ir = (char)(ir + 1);
                    continue;
                }
                w ^= t2;
            }
            if (w == 0L) {
                continue;
            }
            return false;
        }
        if (ib < bitmapContainer.bitmap.length) {
            while (ib < bitmapContainer.bitmap.length) {
                if (bitmapContainer.bitmap[ib] != 0L) {
                    return false;
                }
                ib = (char)(ib + 1);
            }
        }
        return true;
    }

    private Container convertToLazyBitmapIfNeeded() {
        if (this.nbrruns > 4096) {
            BitmapContainer answer = new BitmapContainer();
            for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
                char start = this.getValue(rlepos);
                int end = start + this.getLength(rlepos) + 1;
                Util.setBitmapRange(answer.bitmap, start, end);
            }
            answer.cardinality = -1;
            return answer;
        }
        return this;
    }

    private void copyToOffset(int offset) {
        int minCapacity = 2 * (offset + this.nbrruns);
        if (this.valueslength.length < minCapacity) {
            int newCapacity = this.valueslength.length;
            while (newCapacity < minCapacity) {
                newCapacity = newCapacity == 0 ? 4 : (newCapacity < 64 ? newCapacity * 2 : (newCapacity < 1024 ? newCapacity * 3 / 2 : newCapacity * 5 / 4));
            }
            char[] newvalueslength = new char[newCapacity];
            this.copyValuesLength(this.valueslength, 0, newvalueslength, offset, this.nbrruns);
            this.valueslength = newvalueslength;
        } else {
            this.copyValuesLength(this.valueslength, 0, this.valueslength, offset, this.nbrruns);
        }
    }

    private void copyValuesLength(char[] src, int srcIndex, char[] dst, int dstIndex, int length) {
        System.arraycopy(src, 2 * srcIndex, dst, 2 * dstIndex, 2 * length);
    }

    private void decrementLength(int index) {
        int n = 2 * index + 1;
        this.valueslength[n] = (char)(this.valueslength[n] - '\u0001');
    }

    private void decrementValue(int index) {
        int n = 2 * index;
        this.valueslength[n] = (char)(this.valueslength[n] - '\u0001');
    }

    @Override
    public void deserialize(DataInput in) throws IOException {
        this.nbrruns = Character.reverseBytes(in.readChar());
        if (this.valueslength.length < 2 * this.nbrruns) {
            this.valueslength = new char[2 * this.nbrruns];
        }
        for (int k = 0; k < 2 * this.nbrruns; ++k) {
            this.valueslength[k] = Character.reverseBytes(in.readChar());
        }
    }

    void ensureCapacity(int minNbRuns) {
        int minCapacity = 2 * minNbRuns;
        if (this.valueslength.length < minCapacity) {
            int newCapacity = this.valueslength.length;
            while (newCapacity < minCapacity) {
                newCapacity = newCapacity == 0 ? 4 : (newCapacity < 64 ? newCapacity * 2 : (newCapacity < 1024 ? newCapacity * 3 / 2 : newCapacity * 5 / 4));
            }
            char[] nv = new char[newCapacity];
            this.copyValuesLength(this.valueslength, 0, nv, 0, this.nbrruns);
            this.valueslength = nv;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof RunContainer) {
            return this.equals((RunContainer)o);
        }
        if (o instanceof ArrayContainer) {
            return this.equals((ArrayContainer)o);
        }
        if (o instanceof Container) {
            if (((Container)o).getCardinality() != this.getCardinality()) {
                return false;
            }
            PeekableCharIterator me = this.getCharIterator();
            PeekableCharIterator you = ((Container)o).getCharIterator();
            while (me.hasNext()) {
                if (me.next() == you.next()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean equals(RunContainer rc) {
        return ArraysShim.equals(this.valueslength, 0, 2 * this.nbrruns, rc.valueslength, 0, 2 * rc.nbrruns);
    }

    private boolean equals(ArrayContainer arrayContainer) {
        int pos = 0;
        for (int i = 0; i < this.nbrruns; i = (int)((char)(i + 1))) {
            char runStart = this.getValue(i);
            char length = this.getLength(i);
            if (pos + length >= arrayContainer.getCardinality()) {
                return false;
            }
            if (arrayContainer.content[pos] != runStart) {
                return false;
            }
            if (arrayContainer.content[pos + length] != (char)(runStart + length)) {
                return false;
            }
            pos += length + '\u0001';
        }
        return pos == arrayContainer.getCardinality();
    }

    @Override
    public void fillLeastSignificant16bits(int[] x, int i, int mask) {
        int pos = i;
        for (int k = 0; k < this.nbrruns; ++k) {
            int limit = this.getLength(k);
            char base = this.getValue(k);
            for (int le = 0; le <= limit; ++le) {
                x[pos++] = base + le | mask;
            }
        }
    }

    @Override
    public Container flip(char x) {
        if (this.contains(x)) {
            return this.remove(x);
        }
        return this.add(x);
    }

    @Override
    public int getArraySizeInBytes() {
        return 2 + 4 * this.nbrruns;
    }

    @Override
    public int getCardinality() {
        int sum = this.nbrruns;
        for (int k = 0; k < this.nbrruns; ++k) {
            sum += this.getLength(k);
        }
        return sum;
    }

    public char getLength(int index) {
        return this.valueslength[2 * index + 1];
    }

    @Override
    public PeekableCharIterator getReverseCharIterator() {
        return new ReverseRunContainerCharIterator(this);
    }

    @Override
    public PeekableCharIterator getCharIterator() {
        return new RunContainerCharIterator(this);
    }

    @Override
    public PeekableCharRankIterator getCharRankIterator() {
        return new RunContainerCharRankIterator(this);
    }

    @Override
    public ContainerBatchIterator getBatchIterator() {
        return new RunBatchIterator(this);
    }

    @Override
    public int getSizeInBytes() {
        return this.nbrruns * 4 + 4;
    }

    public char getValue(int index) {
        return this.valueslength[2 * index];
    }

    public int hashCode() {
        int hash = 0;
        for (int k = 0; k < this.nbrruns * 2; ++k) {
            hash += 31 * hash + this.valueslength[k];
        }
        return hash;
    }

    @Override
    public Container iadd(int begin, int end) {
        if (end == begin) {
            return this;
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        if (begin == end - 1) {
            this.add((char)begin);
            return this;
        }
        int bIndex = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, (char)begin);
        int eIndex = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, (char)(end - 1));
        if (bIndex >= 0 && eIndex >= 0) {
            this.mergeValuesLength(bIndex, eIndex);
            return this;
        }
        if (bIndex >= 0) {
            if (this.canPrependValueLength(end - 1, (eIndex = -eIndex - 2) + 1)) {
                this.mergeValuesLength(bIndex, eIndex + 1);
                return this;
            }
            this.appendValueLength(end - 1, eIndex);
            this.mergeValuesLength(bIndex, eIndex);
            return this;
        }
        if (eIndex >= 0) {
            if ((bIndex = -bIndex - 2) >= 0 && this.valueLengthContains(begin - 1, bIndex)) {
                this.mergeValuesLength(bIndex, eIndex);
                return this;
            }
            this.prependValueLength(begin, bIndex + 1);
            this.mergeValuesLength(bIndex + 1, eIndex);
            return this;
        }
        bIndex = -bIndex - 2;
        if ((eIndex = -eIndex - 2) >= 0) {
            if (bIndex >= 0) {
                if (!this.valueLengthContains(begin - 1, bIndex)) {
                    if (bIndex == eIndex) {
                        if (this.canPrependValueLength(end - 1, eIndex + 1)) {
                            this.prependValueLength(begin, eIndex + 1);
                            return this;
                        }
                        this.makeRoomAtIndex(eIndex + 1);
                        this.setValue(eIndex + 1, (char)begin);
                        this.setLength(eIndex + 1, (char)(end - 1 - begin));
                        return this;
                    }
                    this.prependValueLength(begin, ++bIndex);
                }
            } else {
                bIndex = 0;
                this.prependValueLength(begin, bIndex);
            }
            if (this.canPrependValueLength(end - 1, eIndex + 1)) {
                this.mergeValuesLength(bIndex, eIndex + 1);
                return this;
            }
            this.appendValueLength(end - 1, eIndex);
            this.mergeValuesLength(bIndex, eIndex);
            return this;
        }
        if (this.canPrependValueLength(end - 1, 0)) {
            this.prependValueLength(begin, 0);
        } else {
            this.makeRoomAtIndex(0);
            this.setValue(0, (char)begin);
            this.setLength(0, (char)(end - 1 - begin));
        }
        return this;
    }

    @Override
    public Container iand(ArrayContainer x) {
        return this.and(x);
    }

    @Override
    public Container iand(BitmapContainer x) {
        return this.and(x);
    }

    @Override
    public Container iand(RunContainer x) {
        return this.and(x);
    }

    @Override
    public Container iandNot(ArrayContainer x) {
        return this.andNot(x);
    }

    @Override
    public Container iandNot(BitmapContainer x) {
        return this.andNot(x);
    }

    @Override
    public Container iandNot(RunContainer x) {
        return this.andNot(x);
    }

    Container ilazyor(ArrayContainer x) {
        if (this.isFull()) {
            return this;
        }
        return this.ilazyorToRun(x);
    }

    private Container ilazyorToRun(ArrayContainer x) {
        if (this.isFull()) {
            return RunContainer.full();
        }
        int nbrruns = this.nbrruns;
        int offset = Math.max(nbrruns, x.getCardinality());
        this.copyToOffset(offset);
        int rlepos = 0;
        this.nbrruns = 0;
        PeekableCharIterator i = x.getCharIterator();
        while (i.hasNext() && rlepos < nbrruns) {
            if (this.getValue(rlepos + offset) - i.peekNext() <= 0) {
                this.smartAppend(this.getValue(rlepos + offset), this.getLength(rlepos + offset));
                ++rlepos;
                continue;
            }
            this.smartAppend(i.next());
        }
        if (i.hasNext()) {
            while (i.hasNext()) {
                this.smartAppend(i.next());
            }
        } else {
            while (rlepos < nbrruns) {
                this.smartAppend(this.getValue(rlepos + offset), this.getLength(rlepos + offset));
                ++rlepos;
            }
        }
        return this.convertToLazyBitmapIfNeeded();
    }

    private void increaseCapacity() {
        int newCapacity = this.valueslength.length == 0 ? 4 : (this.valueslength.length < 64 ? this.valueslength.length * 2 : (this.valueslength.length < 1024 ? this.valueslength.length * 3 / 2 : this.valueslength.length * 5 / 4));
        char[] nv = new char[newCapacity];
        System.arraycopy(this.valueslength, 0, nv, 0, 2 * this.nbrruns);
        this.valueslength = nv;
    }

    private void incrementLength(int index) {
        int n = 2 * index + 1;
        this.valueslength[n] = (char)(this.valueslength[n] + '\u0001');
    }

    private void incrementValue(int index) {
        int n = 2 * index;
        this.valueslength[n] = (char)(this.valueslength[n] + '\u0001');
    }

    private void initValueLength(int value, int index) {
        char initialValue = this.getValue(index);
        char length = this.getLength(index);
        this.setValue(index, (char)value);
        this.setLength(index, (char)(length - (value - initialValue)));
    }

    @Override
    public Container inot(int rangeStart, int rangeEnd) {
        int k;
        if (rangeEnd <= rangeStart) {
            return this;
        }
        if (this.valueslength.length <= 2 * this.nbrruns + 1) {
            boolean firstValueInRange;
            boolean lastValueBeforeRange = false;
            boolean firstValuePastRange = false;
            if (rangeStart > 0) {
                lastValueBeforeRange = this.contains((char)(rangeStart - 1));
            }
            if (lastValueBeforeRange == (firstValueInRange = this.contains((char)rangeStart))) {
                boolean lastValueInRange = this.contains((char)(rangeEnd - 1));
                if (rangeEnd != 65536) {
                    firstValuePastRange = this.contains((char)rangeEnd);
                }
                if (lastValueInRange == firstValuePastRange) {
                    return this.not(rangeStart, rangeEnd);
                }
            }
        }
        int myNbrRuns = this.nbrruns;
        RunContainer ans = this;
        ans.nbrruns = 0;
        for (k = 0; k < myNbrRuns && this.getValue(k) < rangeStart; ++k) {
            ++ans.nbrruns;
        }
        char bufferedValue = '\u0000';
        char bufferedLength = '\u0000';
        char nextValue = '\u0000';
        char nextLength = '\u0000';
        if (k < myNbrRuns) {
            bufferedValue = this.getValue(k);
            bufferedLength = this.getLength(k);
        }
        ans.smartAppendExclusive((char)rangeStart, (char)(rangeEnd - rangeStart - 1));
        while (k < myNbrRuns) {
            if (ans.nbrruns > k + 1) {
                throw new RuntimeException("internal error in inot, writer has overtaken reader!! " + k + " " + ans.nbrruns);
            }
            if (k + 1 < myNbrRuns) {
                nextValue = this.getValue(k + 1);
                nextLength = this.getLength(k + 1);
            }
            ans.smartAppendExclusive(bufferedValue, bufferedLength);
            bufferedValue = nextValue;
            bufferedLength = nextLength;
            ++k;
        }
        return ans.toEfficientContainer();
    }

    @Override
    public boolean intersects(ArrayContainer x) {
        if (this.nbrruns == 0) {
            return false;
        }
        int rlepos = 0;
        int arraypos = 0;
        char rleval = this.getValue(rlepos);
        char rlelength = this.getLength(rlepos);
        while (arraypos < x.cardinality) {
            char arrayval = x.content[arraypos];
            while (rleval + rlelength < arrayval) {
                if (++rlepos == this.nbrruns) {
                    return false;
                }
                rleval = this.getValue(rlepos);
                rlelength = this.getLength(rlepos);
            }
            if (rleval > arrayval) {
                arraypos = Util.advanceUntil(x.content, arraypos, x.cardinality, this.getValue(rlepos));
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(BitmapContainer x) {
        for (int run = 0; run < this.nbrruns; ++run) {
            int runEnd;
            char runStart = this.getValue(run);
            if (!x.intersects(runStart, (runEnd = runStart + this.getLength(run)) + 1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(RunContainer x) {
        int rlepos = 0;
        int xrlepos = 0;
        char start = this.getValue(rlepos);
        int end = start + this.getLength(rlepos) + 1;
        char xstart = x.getValue(xrlepos);
        int xend = xstart + x.getLength(xrlepos) + 1;
        while (rlepos < this.nbrruns && xrlepos < x.nbrruns) {
            if (end <= xstart) {
                if (++rlepos >= this.nbrruns) continue;
                start = this.getValue(rlepos);
                end = start + this.getLength(rlepos) + 1;
                continue;
            }
            if (xend <= start) {
                if (++xrlepos >= x.nbrruns) continue;
                xstart = x.getValue(xrlepos);
                xend = xstart + x.getLength(xrlepos) + 1;
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(int minimum, int supremum) {
        if (minimum < 0 || supremum < minimum || supremum > 65536) {
            throw new RuntimeException("This should never happen (bug).");
        }
        for (int i = 0; i < this.numberOfRuns(); ++i) {
            char runFirstValue = this.getValue(i);
            int runLastValue = (char)(runFirstValue + this.getLength(i)) + '\u0001';
            if (supremum <= runFirstValue || minimum >= runLastValue) continue;
            return true;
        }
        return false;
    }

    @Override
    public Container ior(ArrayContainer x) {
        if (this.isFull()) {
            return this;
        }
        int nbrruns = this.nbrruns;
        int offset = Math.max(nbrruns, x.getCardinality());
        this.copyToOffset(offset);
        int rlepos = 0;
        this.nbrruns = 0;
        PeekableCharIterator i = x.getCharIterator();
        while (i.hasNext() && rlepos < nbrruns) {
            if (this.getValue(rlepos + offset) - i.peekNext() <= 0) {
                this.smartAppend(this.getValue(rlepos + offset), this.getLength(rlepos + offset));
                ++rlepos;
                continue;
            }
            this.smartAppend(i.next());
        }
        if (i.hasNext()) {
            while (i.hasNext()) {
                this.smartAppend(i.next());
            }
        } else {
            while (rlepos < nbrruns) {
                this.smartAppend(this.getValue(rlepos + offset), this.getLength(rlepos + offset));
                ++rlepos;
            }
        }
        return this.toEfficientContainer();
    }

    @Override
    public Container ior(BitmapContainer x) {
        if (this.isFull()) {
            return this;
        }
        return this.or(x);
    }

    @Override
    public Container ior(RunContainer x) {
        if (this.isFull()) {
            return this;
        }
        int nbrruns = this.nbrruns;
        int xnbrruns = x.nbrruns;
        int offset = Math.max(nbrruns, xnbrruns);
        this.copyToOffset(offset);
        this.nbrruns = 0;
        int rlepos = 0;
        int xrlepos = 0;
        while (rlepos < nbrruns && xrlepos < xnbrruns) {
            char value = this.getValue(offset + rlepos);
            char xvalue = x.getValue(xrlepos);
            char length = this.getLength(offset + rlepos);
            char xlength = x.getLength(xrlepos);
            if (value - xvalue <= 0) {
                this.smartAppend(value, length);
                ++rlepos;
                continue;
            }
            this.smartAppend(xvalue, xlength);
            ++xrlepos;
        }
        while (rlepos < nbrruns) {
            this.smartAppend(this.getValue(offset + rlepos), this.getLength(offset + rlepos));
            ++rlepos;
        }
        while (xrlepos < xnbrruns) {
            this.smartAppend(x.getValue(xrlepos), x.getLength(xrlepos));
            ++xrlepos;
        }
        return this.toBitmapIfNeeded();
    }

    @Override
    public Container iremove(int begin, int end) {
        if (end == begin) {
            return this;
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        if (begin == end - 1) {
            this.remove((char)begin);
            return this;
        }
        int bIndex = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, (char)begin);
        int eIndex = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, (char)(end - 1));
        if (bIndex >= 0) {
            if (eIndex < 0) {
                eIndex = -eIndex - 2;
            }
            if (this.valueLengthContains(end, eIndex)) {
                this.initValueLength(end, eIndex);
                this.recoverRoomsInRange(bIndex - 1, eIndex - 1);
            } else {
                this.recoverRoomsInRange(bIndex - 1, eIndex);
            }
        } else if (eIndex >= 0) {
            if ((bIndex = -bIndex - 2) >= 0 && this.valueLengthContains(begin, bIndex)) {
                this.closeValueLength(begin - 1, bIndex);
            }
            if (this.getLength(eIndex) == '\u0000') {
                this.recoverRoomsInRange(eIndex - 1, eIndex);
            } else {
                this.incrementValue(eIndex);
                this.decrementLength(eIndex);
            }
            this.recoverRoomsInRange(bIndex, eIndex - 1);
        } else {
            bIndex = -bIndex - 2;
            if ((eIndex = -eIndex - 2) >= 0) {
                if (bIndex >= 0) {
                    if (bIndex == eIndex) {
                        if (this.valueLengthContains(begin, bIndex)) {
                            if (this.valueLengthContains(end, eIndex)) {
                                this.makeRoomAtIndex(bIndex);
                                this.closeValueLength(begin - 1, bIndex);
                                this.initValueLength(end, bIndex + 1);
                                return this;
                            }
                            this.closeValueLength(begin - 1, bIndex);
                        }
                    } else {
                        if (this.valueLengthContains(begin, bIndex)) {
                            this.closeValueLength(begin - 1, bIndex);
                        }
                        if (this.valueLengthContains(end, eIndex)) {
                            this.initValueLength(end, eIndex);
                            --eIndex;
                        }
                        this.recoverRoomsInRange(bIndex, eIndex);
                    }
                } else if (this.valueLengthContains(end, eIndex)) {
                    this.initValueLength(end, eIndex);
                    this.recoverRoomsInRange(bIndex, eIndex - 1);
                } else {
                    this.recoverRoomsInRange(bIndex, eIndex);
                }
            }
        }
        return this;
    }

    @Override
    public boolean isFull() {
        return this.nbrruns == 1 && this.getValue(0) == '\u0000' && this.getLength(0) == '\uffff';
    }

    public static RunContainer full() {
        return new RunContainer(0, 65536);
    }

    @Override
    public Iterator<Character> iterator() {
        final PeekableCharIterator i = this.getCharIterator();
        return new Iterator<Character>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Character next() {
                return Character.valueOf(i.next());
            }

            @Override
            public void remove() {
                i.remove();
            }
        };
    }

    @Override
    public Container ixor(ArrayContainer x) {
        return this.xor(x);
    }

    @Override
    public Container ixor(BitmapContainer x) {
        return this.xor(x);
    }

    @Override
    public Container ixor(RunContainer x) {
        return this.xor(x);
    }

    private RunContainer lazyandNot(ArrayContainer x) {
        if (x.isEmpty()) {
            return this;
        }
        RunContainer answer = new RunContainer(new char[2 * (this.nbrruns + x.cardinality)], 0);
        int rlepos = 0;
        int xrlepos = 0;
        int start = this.getValue(rlepos);
        int end = start + this.getLength(rlepos) + 1;
        char xstart = x.content[xrlepos];
        while (rlepos < this.nbrruns && xrlepos < x.cardinality) {
            if (end <= xstart) {
                answer.valueslength[2 * answer.nbrruns] = (char)start;
                answer.valueslength[2 * answer.nbrruns + 1] = (char)(end - start - 1);
                ++answer.nbrruns;
                if (++rlepos >= this.nbrruns) continue;
                start = this.getValue(rlepos);
                end = start + this.getLength(rlepos) + 1;
                continue;
            }
            if (xstart + '\u0001' <= start) {
                if (++xrlepos >= x.cardinality) continue;
                xstart = x.content[xrlepos];
                continue;
            }
            if (start < xstart) {
                answer.valueslength[2 * answer.nbrruns] = (char)start;
                answer.valueslength[2 * answer.nbrruns + 1] = (char)(xstart - start - 1);
                ++answer.nbrruns;
            }
            if (xstart + '\u0001' < end) {
                start = xstart + '\u0001';
                continue;
            }
            if (++rlepos >= this.nbrruns) continue;
            start = this.getValue(rlepos);
            end = start + this.getLength(rlepos) + 1;
        }
        if (rlepos < this.nbrruns) {
            answer.valueslength[2 * answer.nbrruns] = (char)start;
            answer.valueslength[2 * answer.nbrruns + 1] = (char)(end - start - 1);
            ++answer.nbrruns;
            if (++rlepos < this.nbrruns) {
                System.arraycopy(this.valueslength, 2 * rlepos, answer.valueslength, 2 * answer.nbrruns, 2 * (this.nbrruns - rlepos));
                answer.nbrruns = answer.nbrruns + this.nbrruns - rlepos;
            }
        }
        return answer;
    }

    protected Container lazyor(ArrayContainer x) {
        return this.lazyorToRun(x);
    }

    private Container lazyorToRun(ArrayContainer x) {
        if (this.isFull()) {
            return RunContainer.full();
        }
        RunContainer answer = new RunContainer(new char[2 * (this.nbrruns + x.getCardinality())], 0);
        int rlepos = 0;
        PeekableCharIterator i = x.getCharIterator();
        while (i.hasNext() && rlepos < this.nbrruns) {
            if (this.getValue(rlepos) - i.peekNext() <= 0) {
                answer.smartAppend(this.getValue(rlepos), this.getLength(rlepos));
                ++rlepos;
                continue;
            }
            answer.smartAppend(i.next());
        }
        if (i.hasNext()) {
            while (i.hasNext()) {
                answer.smartAppend(i.next());
            }
        } else {
            while (rlepos < this.nbrruns) {
                answer.smartAppend(this.getValue(rlepos), this.getLength(rlepos));
                ++rlepos;
            }
        }
        if (answer.isFull()) {
            return RunContainer.full();
        }
        return answer.convertToLazyBitmapIfNeeded();
    }

    private Container lazyxor(ArrayContainer x) {
        if (x.isEmpty()) {
            return this;
        }
        if (this.nbrruns == 0) {
            return x;
        }
        RunContainer answer = new RunContainer(new char[2 * (this.nbrruns + x.getCardinality())], 0);
        int rlepos = 0;
        PeekableCharIterator i = x.getCharIterator();
        char cv = i.next();
        while (true) {
            if (this.getValue(rlepos) < cv) {
                answer.smartAppendExclusive(this.getValue(rlepos), this.getLength(rlepos));
                if (++rlepos != this.nbrruns) continue;
                answer.smartAppendExclusive(cv);
                while (i.hasNext()) {
                    answer.smartAppendExclusive(i.next());
                }
                break;
            }
            answer.smartAppendExclusive(cv);
            if (!i.hasNext()) {
                while (rlepos < this.nbrruns) {
                    answer.smartAppendExclusive(this.getValue(rlepos), this.getLength(rlepos));
                    ++rlepos;
                }
                break;
            }
            cv = i.next();
        }
        return answer;
    }

    @Override
    public Container limit(int maxcardinality) {
        int r;
        if (maxcardinality >= this.getCardinality()) {
            return this.clone();
        }
        int cardinality = 0;
        for (r = 0; r < this.nbrruns && maxcardinality > (cardinality += this.getLength(r) + '\u0001'); ++r) {
        }
        RunContainer rc = new RunContainer(Arrays.copyOf(this.valueslength, 2 * (r + 1)), r + 1);
        rc.setLength(r, (char)(rc.getLength(r) - cardinality + maxcardinality));
        return rc;
    }

    private void makeRoomAtIndex(int index) {
        if (2 * (this.nbrruns + 1) > this.valueslength.length) {
            this.increaseCapacity();
        }
        this.copyValuesLength(this.valueslength, index, this.valueslength, index + 1, this.nbrruns - index);
        ++this.nbrruns;
    }

    private void mergeValuesLength(int begin, int end) {
        if (begin < end) {
            char bValue = this.getValue(begin);
            char eValue = this.getValue(end);
            char eLength = this.getLength(end);
            int newLength = eValue - bValue + eLength;
            this.setLength(begin, (char)newLength);
            this.recoverRoomsInRange(begin, end);
        }
    }

    @Override
    public Container not(int rangeStart, int rangeEnd) {
        int k;
        if (rangeEnd <= rangeStart) {
            return this.clone();
        }
        RunContainer ans = new RunContainer(this.nbrruns + 1);
        for (k = 0; k < this.nbrruns && this.getValue(k) < rangeStart; ++k) {
            ans.valueslength[2 * k] = this.valueslength[2 * k];
            ans.valueslength[2 * k + 1] = this.valueslength[2 * k + 1];
            ++ans.nbrruns;
        }
        ans.smartAppendExclusive((char)rangeStart, (char)(rangeEnd - rangeStart - 1));
        while (k < this.nbrruns) {
            ans.smartAppendExclusive(this.getValue(k), this.getLength(k));
            ++k;
        }
        return ans.toEfficientContainer();
    }

    @Override
    public int numberOfRuns() {
        return this.nbrruns;
    }

    @Override
    public Container or(ArrayContainer x) {
        return this.lazyor(x).repairAfterLazy();
    }

    @Override
    public Container or(BitmapContainer x) {
        if (this.isFull()) {
            return RunContainer.full();
        }
        BitmapContainer answer = x.clone();
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            char start = this.getValue(rlepos);
            int end = start + this.getLength(rlepos) + 1;
            int prevOnesInRange = answer.cardinalityInRange(start, end);
            Util.setBitmapRange(answer.bitmap, start, end);
            answer.updateCardinality(prevOnesInRange, end - start);
        }
        if (answer.isFull()) {
            return RunContainer.full();
        }
        return answer;
    }

    @Override
    public Container or(RunContainer x) {
        if (this.isFull()) {
            return RunContainer.full();
        }
        if (x.isFull()) {
            return RunContainer.full();
        }
        RunContainer answer = new RunContainer(new char[2 * (this.nbrruns + x.nbrruns)], 0);
        int rlepos = 0;
        int xrlepos = 0;
        while (xrlepos < x.nbrruns && rlepos < this.nbrruns) {
            if (this.getValue(rlepos) - x.getValue(xrlepos) <= 0) {
                answer.smartAppend(this.getValue(rlepos), this.getLength(rlepos));
                ++rlepos;
                continue;
            }
            answer.smartAppend(x.getValue(xrlepos), x.getLength(xrlepos));
            ++xrlepos;
        }
        while (xrlepos < x.nbrruns) {
            answer.smartAppend(x.getValue(xrlepos), x.getLength(xrlepos));
            ++xrlepos;
        }
        while (rlepos < this.nbrruns) {
            answer.smartAppend(this.getValue(rlepos), this.getLength(rlepos));
            ++rlepos;
        }
        if (answer.isFull()) {
            return RunContainer.full();
        }
        return answer.toBitmapIfNeeded();
    }

    private void prependValueLength(int value, int index) {
        char initialValue = this.getValue(index);
        char length = this.getLength(index);
        this.setValue(index, (char)value);
        this.setLength(index, (char)(initialValue - value + length));
    }

    @Override
    public int rank(char lowbits) {
        int answer = 0;
        for (int k = 0; k < this.nbrruns; ++k) {
            char value = this.getValue(k);
            char length = this.getLength(k);
            if (lowbits < value) {
                return answer;
            }
            if (value + length + 1 > lowbits) {
                return answer + lowbits - value + 1;
            }
            answer += length + '\u0001';
        }
        return answer;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.deserialize(in);
    }

    private void recoverRoomAtIndex(int index) {
        this.copyValuesLength(this.valueslength, index + 1, this.valueslength, index, this.nbrruns - index - 1);
        --this.nbrruns;
    }

    private void recoverRoomsInRange(int begin, int end) {
        if (end + 1 < this.nbrruns) {
            this.copyValuesLength(this.valueslength, end + 1, this.valueslength, begin + 1, this.nbrruns - 1 - end);
        }
        this.nbrruns -= end - begin;
    }

    @Override
    public Container remove(int begin, int end) {
        RunContainer rc = (RunContainer)this.clone();
        return rc.iremove(begin, end);
    }

    @Override
    public Container remove(char x) {
        int index = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, x);
        if (index >= 0) {
            if (this.getLength(index) == '\u0000') {
                this.recoverRoomAtIndex(index);
            } else {
                this.incrementValue(index);
                this.decrementLength(index);
            }
            return this;
        }
        if ((index = -index - 2) >= 0) {
            char le;
            int offset = x - this.getValue(index);
            if (offset < (le = this.getLength(index))) {
                this.setLength(index, (char)(offset - 1));
                int newvalue = x + '\u0001';
                int newlength = le - offset - 1;
                this.makeRoomAtIndex(index + 1);
                this.setValue(index + 1, (char)newvalue);
                this.setLength(index + 1, (char)newlength);
                return this;
            }
            if (offset == le) {
                this.decrementLength(index);
            }
        }
        return this;
    }

    @Override
    public Container repairAfterLazy() {
        return this.toEfficientContainer();
    }

    @Override
    public Container runOptimize() {
        return this.toEfficientContainer();
    }

    @Override
    public char select(int j) {
        int offset = 0;
        for (int k = 0; k < this.nbrruns; ++k) {
            int nextOffset = offset + this.getLength(k) + 1;
            if (nextOffset > j) {
                return (char)(this.getValue(k) + (j - offset));
            }
            offset = nextOffset;
        }
        throw new IllegalArgumentException("Cannot select " + j + " since cardinality is " + this.getCardinality());
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        this.writeArray(out);
    }

    @Override
    public int serializedSizeInBytes() {
        return RunContainer.serializedSizeInBytes(this.nbrruns);
    }

    private void setLength(int index, char v) {
        this.setLength(this.valueslength, index, v);
    }

    private void setLength(char[] valueslength, int index, char v) {
        valueslength[2 * index + 1] = v;
    }

    private void setValue(int index, char v) {
        this.setValue(this.valueslength, index, v);
    }

    private void setValue(char[] valueslength, int index, char v) {
        valueslength[2 * index] = v;
    }

    private int skipAhead(RunContainer skippingOn, int pos, int targetToExceed) {
        int probePos;
        int end;
        int left = pos;
        int span = 1;
        do {
            if ((probePos = left + span) >= skippingOn.nbrruns - 1 && (end = skippingOn.getValue(probePos = skippingOn.nbrruns - 1) + skippingOn.getLength(probePos) + 1) <= targetToExceed) {
                return skippingOn.nbrruns;
            }
            end = skippingOn.getValue(probePos) + skippingOn.getLength(probePos) + 1;
            span *= 2;
        } while (end <= targetToExceed);
        int right = probePos;
        while (right - left > 1) {
            int mid = (right + left) / 2;
            int midVal = skippingOn.getValue(mid) + skippingOn.getLength(mid) + 1;
            if (midVal > targetToExceed) {
                right = mid;
                continue;
            }
            left = mid;
        }
        return right;
    }

    private void smartAppend(char val) {
        int oldend;
        if (this.nbrruns == 0 || val > (oldend = this.valueslength[2 * (this.nbrruns - 1)] + this.valueslength[2 * (this.nbrruns - 1) + 1]) + 1) {
            this.valueslength[2 * this.nbrruns] = val;
            this.valueslength[2 * this.nbrruns + 1] = '\u0000';
            ++this.nbrruns;
            return;
        }
        if (val == (char)(oldend + 1)) {
            int n = 2 * (this.nbrruns - 1) + 1;
            this.valueslength[n] = (char)(this.valueslength[n] + '\u0001');
        }
    }

    void smartAppend(char start, char length) {
        int oldend;
        if (this.nbrruns == 0 || start > (oldend = this.getValue(this.nbrruns - 1) + this.getLength(this.nbrruns - 1)) + 1) {
            this.ensureCapacity(this.nbrruns + 1);
            this.valueslength[2 * this.nbrruns] = start;
            this.valueslength[2 * this.nbrruns + 1] = length;
            ++this.nbrruns;
            return;
        }
        int newend = start + length + 1;
        if (newend > oldend) {
            this.setLength(this.nbrruns - 1, (char)(newend - 1 - this.getValue(this.nbrruns - 1)));
        }
    }

    private void smartAppendExclusive(char val) {
        int oldend;
        if (this.nbrruns == 0 || val > (oldend = this.getValue(this.nbrruns - 1) + this.getLength(this.nbrruns - 1) + 1)) {
            this.valueslength[2 * this.nbrruns] = val;
            this.valueslength[2 * this.nbrruns + 1] = '\u0000';
            ++this.nbrruns;
            return;
        }
        if (oldend == val) {
            int n = 2 * (this.nbrruns - 1) + 1;
            this.valueslength[n] = (char)(this.valueslength[n] + '\u0001');
            return;
        }
        int newend = val + '\u0001';
        if (val == this.getValue(this.nbrruns - 1)) {
            if (newend != oldend) {
                this.setValue(this.nbrruns - 1, (char)newend);
                this.setLength(this.nbrruns - 1, (char)(oldend - newend - 1));
                return;
            }
            --this.nbrruns;
            return;
        }
        this.setLength(this.nbrruns - 1, (char)(val - this.getValue(this.nbrruns - 1) - 1));
        if (newend < oldend) {
            this.setValue(this.nbrruns, (char)newend);
            this.setLength(this.nbrruns, (char)(oldend - newend - 1));
            ++this.nbrruns;
        }
    }

    private void smartAppendExclusive(char start, char length) {
        int oldend;
        if (this.nbrruns == 0 || start > (oldend = this.getValue(this.nbrruns - 1) + this.getLength(this.nbrruns - 1) + 1)) {
            this.valueslength[2 * this.nbrruns] = start;
            this.valueslength[2 * this.nbrruns + 1] = length;
            ++this.nbrruns;
            return;
        }
        if (oldend == start) {
            int n = 2 * (this.nbrruns - 1) + 1;
            this.valueslength[n] = (char)(this.valueslength[n] + (length + '\u0001'));
            return;
        }
        int newend = start + length + 1;
        if (start == this.getValue(this.nbrruns - 1)) {
            if (newend < oldend) {
                this.setValue(this.nbrruns - 1, (char)newend);
                this.setLength(this.nbrruns - 1, (char)(oldend - newend - 1));
                return;
            }
            if (newend > oldend) {
                this.setValue(this.nbrruns - 1, (char)oldend);
                this.setLength(this.nbrruns - 1, (char)(newend - oldend - 1));
                return;
            }
            --this.nbrruns;
            return;
        }
        this.setLength(this.nbrruns - 1, (char)(start - this.getValue(this.nbrruns - 1) - 1));
        if (newend < oldend) {
            this.setValue(this.nbrruns, (char)newend);
            this.setLength(this.nbrruns, (char)(oldend - newend - 1));
            ++this.nbrruns;
        } else if (newend > oldend) {
            this.setValue(this.nbrruns, (char)oldend);
            this.setLength(this.nbrruns, (char)(newend - oldend - 1));
            ++this.nbrruns;
        }
    }

    private Container toBitmapIfNeeded() {
        int sizeAsRunContainer = RunContainer.serializedSizeInBytes(this.nbrruns);
        int sizeAsBitmapContainer = BitmapContainer.serializedSizeInBytes(0);
        if (sizeAsBitmapContainer > sizeAsRunContainer) {
            return this;
        }
        return this.toBitmapContainer();
    }

    Container toBitmapOrArrayContainer(int card) {
        if (card <= 4096) {
            ArrayContainer answer = new ArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
                int runStart = this.getValue(rlepos);
                int runEnd = runStart + this.getLength(rlepos);
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    answer.content[answer.cardinality++] = (char)runValue;
                }
            }
            return answer;
        }
        BitmapContainer answer = new BitmapContainer();
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            char start = this.getValue(rlepos);
            int end = start + this.getLength(rlepos) + 1;
            Util.setBitmapRange(answer.bitmap, start, end);
        }
        answer.cardinality = card;
        return answer;
    }

    private Container toEfficientContainer() {
        int card;
        int sizeAsArrayContainer;
        int sizeAsBitmapContainer;
        int sizeAsRunContainer = RunContainer.serializedSizeInBytes(this.nbrruns);
        if (sizeAsRunContainer <= Math.min(sizeAsBitmapContainer = BitmapContainer.serializedSizeInBytes(0), sizeAsArrayContainer = ArrayContainer.serializedSizeInBytes(card = this.getCardinality()))) {
            return this;
        }
        return this.toBitmapOrArrayContainer(card);
    }

    @Override
    public MappeableContainer toMappeableContainer() {
        return new MappeableRunContainer(this);
    }

    public CharBuffer toCharBuffer() {
        CharBuffer sb = CharBuffer.allocate(this.nbrruns * 2);
        sb.put(this.valueslength, 0, this.nbrruns * 2);
        return sb;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int k = 0; k < this.nbrruns; ++k) {
            sb.append("[");
            sb.append((int)this.getValue(k));
            sb.append(",");
            sb.append(this.getValue(k) + this.getLength(k));
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public void trim() {
        if (this.valueslength.length == 2 * this.nbrruns) {
            return;
        }
        this.valueslength = Arrays.copyOf(this.valueslength, 2 * this.nbrruns);
    }

    private boolean valueLengthContains(int value, int index) {
        char length;
        char initialValue = this.getValue(index);
        return value <= initialValue + (length = this.getLength(index));
    }

    @Override
    public void writeArray(DataOutput out) throws IOException {
        out.writeShort(Character.reverseBytes((char)this.nbrruns));
        for (int k = 0; k < 2 * this.nbrruns; ++k) {
            out.writeShort(Character.reverseBytes(this.valueslength[k]));
        }
    }

    @Override
    public void writeArray(ByteBuffer buffer) {
        assert (buffer.order() == ByteOrder.LITTLE_ENDIAN);
        CharBuffer buf = buffer.asCharBuffer();
        buf.put((char)this.nbrruns);
        buf.put(this.valueslength, 0, this.nbrruns * 2);
        int bytesWritten = (this.nbrruns * 2 + 1) * 2;
        buffer.position(buffer.position() + bytesWritten);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public Container xor(ArrayContainer x) {
        int arbitrary_threshold = 32;
        if (x.getCardinality() < 32) {
            return this.lazyxor(x).repairAfterLazy();
        }
        int card = this.getCardinality();
        if (card <= 4096) {
            return x.xor(this.getCharIterator());
        }
        return this.toBitmapOrArrayContainer(card).ixor(x);
    }

    @Override
    public Container xor(BitmapContainer x) {
        BitmapContainer answer = x.clone();
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            char start = this.getValue(rlepos);
            int end = start + this.getLength(rlepos) + 1;
            int prevOnes = answer.cardinalityInRange(start, end);
            Util.flipBitmapRange(answer.bitmap, start, end);
            answer.updateCardinality(prevOnes, end - start - prevOnes);
        }
        if (answer.getCardinality() > 4096) {
            return answer;
        }
        return answer.toArrayContainer();
    }

    @Override
    public Container xor(RunContainer x) {
        RunContainer answer;
        block6: {
            if (x.nbrruns == 0) {
                return this.clone();
            }
            if (this.nbrruns == 0) {
                return x.clone();
            }
            answer = new RunContainer(new char[2 * (this.nbrruns + x.nbrruns)], 0);
            int rlepos = 0;
            int xrlepos = 0;
            while (true) {
                if (this.getValue(rlepos) < x.getValue(xrlepos)) {
                    answer.smartAppendExclusive(this.getValue(rlepos), this.getLength(rlepos));
                    if (++rlepos != this.nbrruns) continue;
                    while (xrlepos < x.nbrruns) {
                        answer.smartAppendExclusive(x.getValue(xrlepos), x.getLength(xrlepos));
                        ++xrlepos;
                    }
                    break block6;
                }
                answer.smartAppendExclusive(x.getValue(xrlepos), x.getLength(xrlepos));
                if (++xrlepos == x.nbrruns) break;
            }
            while (rlepos < this.nbrruns) {
                answer.smartAppendExclusive(this.getValue(rlepos), this.getLength(rlepos));
                ++rlepos;
            }
        }
        return answer.toEfficientContainer();
    }

    @Override
    public void forEach(char msb, IntConsumer ic) {
        int high = msb << 16;
        for (int k = 0; k < this.nbrruns; ++k) {
            int base = this.getValue(k) | high;
            char le = this.getLength(k);
            int l = base;
            while (l - le <= base) {
                ic.accept(l);
                ++l;
            }
        }
    }

    @Override
    public void forAll(int offset, RelativeRangeConsumer rrc) {
        int next = 0;
        for (int run = 0; run < this.nbrruns; ++run) {
            int runPos = run << 1;
            int runStart = this.valueslength[runPos];
            char runLength = this.valueslength[runPos + 1];
            if (next < runStart) {
                rrc.acceptAllAbsent(offset + next, offset + runStart);
            }
            rrc.acceptAllPresent(offset + runStart, offset + runStart + runLength + 1);
            next = runStart + runLength + 1;
        }
        if (next <= 65535) {
            rrc.acceptAllAbsent(offset + next, offset + 65535 + 1);
        }
    }

    @Override
    public void forAllFrom(char startValue, RelativeRangeConsumer rrc) {
        int startOffset = startValue;
        int next = startValue;
        for (int run = 0; run < this.nbrruns; ++run) {
            int runPos = run << 1;
            char runStart = this.valueslength[runPos];
            char runLength = this.valueslength[runPos + 1];
            int runEnd = runStart + runLength;
            if (runEnd < startValue) continue;
            if (runStart < next) {
                assert (next == startValue);
                rrc.acceptAllPresent(0, runStart + runLength + 1 - startOffset);
            } else {
                if (next < runStart) {
                    rrc.acceptAllAbsent(next - startOffset, runStart - startOffset);
                }
                rrc.acceptAllPresent(runStart - startOffset, runStart + runLength + 1 - startOffset);
            }
            next = runStart + runLength + 1;
        }
        if (next <= 65535) {
            rrc.acceptAllAbsent(next - startOffset, 65536 - startOffset);
        }
    }

    @Override
    public void forAllUntil(int offset, char endValue, RelativeRangeConsumer rrc) {
        int next = 0;
        for (int run = 0; run < this.nbrruns; ++run) {
            int runEnd;
            int runPos = run << 1;
            char runStart = this.valueslength[runPos];
            char runLength = this.valueslength[runPos + 1];
            if (endValue <= runStart) break;
            if (next < runStart) {
                rrc.acceptAllAbsent(offset + next, offset + runStart);
            }
            if (endValue < (runEnd = runStart + runLength)) {
                rrc.acceptAllPresent(offset + runStart, offset + endValue);
                return;
            }
            rrc.acceptAllPresent(offset + runStart, offset + runEnd + 1);
            next = runEnd + 1;
        }
        if (next < endValue) {
            rrc.acceptAllAbsent(offset + next, offset + endValue);
        }
    }

    @Override
    public void forAllInRange(char startValue, char endValue, RelativeRangeConsumer rrc) {
        if (endValue <= startValue) {
            throw new IllegalArgumentException("startValue (" + (char)startValue + ") must be less than endValue (" + endValue + ")");
        }
        int startOffset = startValue;
        int next = startValue;
        for (int run = 0; run < this.nbrruns; ++run) {
            int runPos = run << 1;
            char runStart = this.valueslength[runPos];
            char runLength = this.valueslength[runPos + 1];
            int runEnd = runStart + runLength;
            if (runEnd < startValue) continue;
            if (endValue <= runStart) break;
            if (runStart < next) {
                assert (next == startValue);
                if (endValue < runEnd) {
                    rrc.acceptAllPresent(0, endValue - startOffset);
                    return;
                }
                rrc.acceptAllPresent(0, runStart + runLength + 1 - startOffset);
            } else {
                if (next < runStart) {
                    rrc.acceptAllAbsent(next - startOffset, runStart - startOffset);
                }
                if (endValue <= runEnd) {
                    rrc.acceptAllPresent(runStart - startOffset, endValue - startOffset);
                    return;
                }
                rrc.acceptAllPresent(runStart - startOffset, runStart + runLength + 1 - startOffset);
            }
            next = runStart + runLength + 1;
        }
        if (next < endValue) {
            rrc.acceptAllAbsent(next - startOffset, endValue - startOffset);
        }
    }

    @Override
    public BitmapContainer toBitmapContainer() {
        int card = this.getCardinality();
        BitmapContainer answer = new BitmapContainer();
        for (int rlepos = 0; rlepos < this.nbrruns; ++rlepos) {
            char start = this.getValue(rlepos);
            int end = start + this.getLength(rlepos) + 1;
            Util.setBitmapRange(answer.bitmap, start, end);
        }
        answer.cardinality = card;
        return answer;
    }

    @Override
    public int nextValue(char fromValue) {
        char le;
        int effectiveIndex;
        int index = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, fromValue);
        int n = effectiveIndex = index >= 0 ? index : -index - 2;
        if (effectiveIndex == -1) {
            return this.first();
        }
        char startValue = this.getValue(effectiveIndex);
        int offset = fromValue - startValue;
        if (offset <= (le = this.getLength(effectiveIndex))) {
            return fromValue;
        }
        if (effectiveIndex + 1 < this.numberOfRuns()) {
            return this.getValue(effectiveIndex + 1);
        }
        return -1;
    }

    @Override
    public int previousValue(char fromValue) {
        int effectiveIndex;
        int index = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, fromValue);
        int n = effectiveIndex = index >= 0 ? index : -index - 2;
        if (effectiveIndex == -1) {
            return -1;
        }
        char startValue = this.getValue(effectiveIndex);
        int offset = fromValue - startValue;
        char le = this.getLength(effectiveIndex);
        if (offset >= 0 && offset <= le) {
            return fromValue;
        }
        return startValue + le;
    }

    @Override
    public int nextAbsentValue(char fromValue) {
        char le;
        int effectiveIndex;
        int index = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, (char)fromValue);
        int n = effectiveIndex = index >= 0 ? index : -index - 2;
        if (effectiveIndex == -1) {
            return fromValue;
        }
        char startValue = this.getValue(effectiveIndex);
        int offset = fromValue - startValue;
        return offset <= (le = this.getLength(effectiveIndex)) ? startValue + le + 1 : fromValue;
    }

    @Override
    public int previousAbsentValue(char fromValue) {
        char le;
        int effectiveIndex;
        int index = RunContainer.unsignedInterleavedBinarySearch(this.valueslength, 0, this.nbrruns, (char)fromValue);
        int n = effectiveIndex = index >= 0 ? index : -index - 2;
        if (effectiveIndex == -1) {
            return fromValue;
        }
        char startValue = this.getValue(effectiveIndex);
        int offset = fromValue - startValue;
        return offset <= (le = this.getLength(effectiveIndex)) ? startValue - '\u0001' : fromValue;
    }

    @Override
    public int first() {
        this.assertNonEmpty(this.numberOfRuns() == 0);
        return this.valueslength[0];
    }

    @Override
    public int last() {
        this.assertNonEmpty(this.numberOfRuns() == 0);
        int index = this.numberOfRuns() - 1;
        char start = this.getValue(index);
        char length = this.getLength(index);
        return start + length;
    }
}

