/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import org.projectnessie.model.Content;
import org.projectnessie.model.types.ContentTypeBundle;

public final class ContentTypes {
    public static Content.Type[] all() {
        return Registry.all();
    }

    public static Content.Type forName(String name) {
        return Registry.forName(name);
    }

    private static final class DefaultContentTypeImpl
    implements Content.Type {
        private DefaultContentTypeImpl() {
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public String toString() {
            return this.name();
        }

        @Override
        public String name() {
            return "UNKNOWN";
        }

        @Override
        public Class<? extends Content> type() {
            throw new IllegalStateException("UNKNOWN Content.Type has no type");
        }
    }

    private static final class ContentTypeImpl
    implements Content.Type {
        private final String name;
        private final Class<? extends Content> type;

        private ContentTypeImpl(String name, Class<? extends Content> type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Class<? extends Content> type() {
            return this.type;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ContentTypeImpl)) {
                return false;
            }
            ContentTypeImpl that = (ContentTypeImpl)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private static final class Registry {
        private static final Content.Type[] all;
        private static final Map<String, Content.Type> byName;

        private Registry() {
        }

        private static Content.Type[] all() {
            return (Content.Type[])all.clone();
        }

        private static Content.Type forName(String name) {
            return Objects.requireNonNull(byName.get(name), "No content type registered for name " + name);
        }

        static {
            ArrayList<DefaultContentTypeImpl> list = new ArrayList<DefaultContentTypeImpl>();
            HashMap<String, DefaultContentTypeImpl> names = new HashMap<String, DefaultContentTypeImpl>();
            DefaultContentTypeImpl unknownContentType = new DefaultContentTypeImpl();
            list.add(unknownContentType);
            names.put(unknownContentType.name(), unknownContentType);
            for (ContentTypeBundle bundle : ServiceLoader.load(ContentTypeBundle.class)) {
                bundle.register((name, type) -> {
                    if (name == null || name.trim().isEmpty() || !name.trim().equals(name) || type == null) {
                        throw new IllegalArgumentException(String.format("Illegal content-type registration: name=%s, type=%s", name, type));
                    }
                    ContentTypeImpl contentType = new ContentTypeImpl(name, type);
                    Content.Type ex = (Content.Type)names.get(name);
                    if (ex != null) {
                        throw new IllegalStateException(String.format("Duplicate content type registration for %s/%s, existing: %s/%s", name, type, ex.name(), ex.type()));
                    }
                    list.add((DefaultContentTypeImpl)((Object)contentType));
                    names.put(name, (DefaultContentTypeImpl)((Object)contentType));
                });
            }
            byName = Collections.unmodifiableMap(names);
            all = list.toArray(new Content.Type[0]);
        }
    }

    public static interface Registrar {
        public void register(String var1, Class<? extends Content> var2);
    }
}

