/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.DiscriminatorMapping;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ImmutableDelete;
import org.projectnessie.model.ImmutablePut;
import org.projectnessie.model.ImmutableUnchanged;

@Schema(type=SchemaType.OBJECT, title="Operation", oneOf={Put.class, Unchanged.class, Delete.class}, discriminatorMapping={@DiscriminatorMapping(value="PUT", schema=Put.class), @DiscriminatorMapping(value="UNCHANGED", schema=Unchanged.class), @DiscriminatorMapping(value="DELETE", schema=Delete.class)}, discriminatorProperty="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Put.class), @JsonSubTypes.Type(value=Delete.class), @JsonSubTypes.Type(value=Unchanged.class)})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public interface Operation {
    @NotNull
    public ContentKey getKey();

    @JsonSerialize(as=ImmutableUnchanged.class)
    @JsonDeserialize(as=ImmutableUnchanged.class)
    @JsonTypeName(value="UNCHANGED")
    @Value.Immutable
    public static interface Unchanged
    extends Operation {
        public static Unchanged of(ContentKey key) {
            return ImmutableUnchanged.builder().key(key).build();
        }
    }

    @JsonSerialize(as=ImmutableDelete.class)
    @JsonDeserialize(as=ImmutableDelete.class)
    @JsonTypeName(value="DELETE")
    @Value.Immutable
    public static interface Delete
    extends Operation {
        public static Delete of(ContentKey key) {
            return ImmutableDelete.builder().key(key).build();
        }
    }

    @Schema(type=SchemaType.OBJECT, title="Put-'Content'-operation for a 'ContentKey'.", description="Add or replace (put) a 'Content' object for a 'ContentKey'. If the actual table type tracks the 'global state' of individual tables (Iceberg as of today), every 'Put'-operation must contain a non-null value for 'expectedContent'.")
    @JsonSerialize(as=ImmutablePut.class)
    @JsonDeserialize(as=ImmutablePut.class)
    @JsonTypeName(value="PUT")
    @Value.Immutable
    public static interface Put
    extends Operation {
        @NotNull
        public Content getContent();

        @Nullable
        public Content getExpectedContent();

        public static Put of(ContentKey key, Content content) {
            return ImmutablePut.builder().key(key).content(content).build();
        }

        public static Put of(ContentKey key, Content content, Content expectedContent) {
            return ImmutablePut.builder().key(key).content(content).expectedContent(expectedContent).build();
        }
    }
}

