/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.GenericMetadata;
import org.projectnessie.model.IcebergContent;
import org.projectnessie.model.IcebergView;

@ParametersAreNonnullByDefault
@Generated(from="IcebergView", generator="Immutables")
@Immutable
public final class ImmutableIcebergView
extends IcebergView {
    @Nullable
    private final String id;
    private final String metadataLocation;
    private final int versionId;
    private final int schemaId;
    private final String sqlText;
    @Nullable
    private final String dialect;
    @Nullable
    private final GenericMetadata metadata;

    private ImmutableIcebergView(@Nullable String id, String metadataLocation, int versionId, int schemaId, String sqlText, @Nullable String dialect, @Nullable GenericMetadata metadata) {
        this.id = id;
        this.metadataLocation = metadataLocation;
        this.versionId = versionId;
        this.schemaId = schemaId;
        this.sqlText = sqlText;
        this.dialect = dialect;
        this.metadata = metadata;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="metadataLocation")
    public String getMetadataLocation() {
        return this.metadataLocation;
    }

    @Override
    @JsonProperty(value="versionId")
    public int getVersionId() {
        return this.versionId;
    }

    @Override
    @JsonProperty(value="schemaId")
    public int getSchemaId() {
        return this.schemaId;
    }

    @Override
    @JsonProperty(value="sqlText")
    public String getSqlText() {
        return this.sqlText;
    }

    @Override
    @JsonProperty(value="dialect")
    @Nullable
    public String getDialect() {
        return this.dialect;
    }

    @Override
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Deprecated
    @Nullable
    public GenericMetadata getMetadata() {
        return this.metadata;
    }

    public final ImmutableIcebergView withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableIcebergView(value, this.metadataLocation, this.versionId, this.schemaId, this.sqlText, this.dialect, this.metadata);
    }

    public final ImmutableIcebergView withMetadataLocation(String value) {
        String newValue = Objects.requireNonNull(value, "metadataLocation");
        if (this.metadataLocation.equals(newValue)) {
            return this;
        }
        return new ImmutableIcebergView(this.id, newValue, this.versionId, this.schemaId, this.sqlText, this.dialect, this.metadata);
    }

    public final ImmutableIcebergView withVersionId(int value) {
        if (this.versionId == value) {
            return this;
        }
        return new ImmutableIcebergView(this.id, this.metadataLocation, value, this.schemaId, this.sqlText, this.dialect, this.metadata);
    }

    public final ImmutableIcebergView withSchemaId(int value) {
        if (this.schemaId == value) {
            return this;
        }
        return new ImmutableIcebergView(this.id, this.metadataLocation, this.versionId, value, this.sqlText, this.dialect, this.metadata);
    }

    public final ImmutableIcebergView withSqlText(String value) {
        String newValue = Objects.requireNonNull(value, "sqlText");
        if (this.sqlText.equals(newValue)) {
            return this;
        }
        return new ImmutableIcebergView(this.id, this.metadataLocation, this.versionId, this.schemaId, newValue, this.dialect, this.metadata);
    }

    public final ImmutableIcebergView withDialect(@Nullable String value) {
        if (Objects.equals(this.dialect, value)) {
            return this;
        }
        return new ImmutableIcebergView(this.id, this.metadataLocation, this.versionId, this.schemaId, this.sqlText, value, this.metadata);
    }

    @Deprecated
    public final ImmutableIcebergView withMetadata(@Nullable GenericMetadata value) {
        if (this.metadata == value) {
            return this;
        }
        return new ImmutableIcebergView(this.id, this.metadataLocation, this.versionId, this.schemaId, this.sqlText, this.dialect, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIcebergView && this.equalTo(0, (ImmutableIcebergView)another);
    }

    private boolean equalTo(int synthetic, ImmutableIcebergView another) {
        return Objects.equals(this.id, another.id) && this.metadataLocation.equals(another.metadataLocation) && this.versionId == another.versionId && this.schemaId == another.schemaId && this.sqlText.equals(another.sqlText) && Objects.equals(this.dialect, another.dialect) && Objects.equals(this.metadata, another.metadata);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.id);
        h2 += (h2 << 5) + this.metadataLocation.hashCode();
        h2 += (h2 << 5) + this.versionId;
        h2 += (h2 << 5) + this.schemaId;
        h2 += (h2 << 5) + this.sqlText.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.dialect);
        h2 += (h2 << 5) + Objects.hashCode(this.metadata);
        return h2;
    }

    public String toString() {
        return "IcebergView{id=" + this.id + ", metadataLocation=" + this.metadataLocation + ", versionId=" + this.versionId + ", schemaId=" + this.schemaId + ", sqlText=" + this.sqlText + ", dialect=" + this.dialect + ", metadata=" + this.metadata + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableIcebergView fromJson(Json json) {
        Builder builder = ImmutableIcebergView.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.metadataLocation != null) {
            builder.metadataLocation(json.metadataLocation);
        }
        if (json.versionIdIsSet) {
            builder.versionId(json.versionId);
        }
        if (json.schemaIdIsSet) {
            builder.schemaId(json.schemaId);
        }
        if (json.sqlText != null) {
            builder.sqlText(json.sqlText);
        }
        if (json.dialect != null) {
            builder.dialect(json.dialect);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        return builder.build();
    }

    public static ImmutableIcebergView copyOf(IcebergView instance) {
        if (instance instanceof ImmutableIcebergView) {
            return (ImmutableIcebergView)instance;
        }
        return ImmutableIcebergView.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IcebergView", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_METADATA_LOCATION = 1L;
        private static final long INIT_BIT_VERSION_ID = 2L;
        private static final long INIT_BIT_SCHEMA_ID = 4L;
        private static final long INIT_BIT_SQL_TEXT = 8L;
        private long initBits = 15L;
        @Nullable
        private String id;
        @Nullable
        private String metadataLocation;
        private int versionId;
        private int schemaId;
        @Nullable
        private String sqlText;
        @Nullable
        private String dialect;
        @Nullable
        private GenericMetadata metadata;

        private Builder() {
        }

        public final Builder from(IcebergContent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IcebergView instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Content instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String idValue;
            Content instance;
            long bits = 0L;
            if (object instanceof IcebergContent) {
                instance = (IcebergContent)object;
                if ((bits & 1L) == 0L) {
                    idValue = instance.getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof IcebergView) {
                instance = (IcebergView)object;
                this.metadataLocation(((IcebergView)instance).getMetadataLocation());
                this.sqlText(((IcebergView)instance).getSqlText());
                GenericMetadata metadataValue = ((IcebergView)instance).getMetadata();
                if (metadataValue != null) {
                    this.metadata(metadataValue);
                }
                this.versionId(((IcebergView)instance).getVersionId());
                String dialectValue = ((IcebergView)instance).getDialect();
                if (dialectValue != null) {
                    this.dialect(dialectValue);
                }
                this.schemaId(((IcebergView)instance).getSchemaId());
            }
            if (object instanceof Content) {
                instance = (Content)object;
                if ((bits & 1L) == 0L) {
                    idValue = instance.getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="id")
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="metadataLocation")
        public final Builder metadataLocation(String metadataLocation) {
            this.metadataLocation = Objects.requireNonNull(metadataLocation, "metadataLocation");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="versionId")
        public final Builder versionId(int versionId) {
            this.versionId = versionId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="schemaId")
        public final Builder schemaId(int schemaId) {
            this.schemaId = schemaId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="sqlText")
        public final Builder sqlText(String sqlText) {
            this.sqlText = Objects.requireNonNull(sqlText, "sqlText");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="dialect")
        public final Builder dialect(@Nullable String dialect) {
            this.dialect = dialect;
            return this;
        }

        @JsonProperty(value="metadata")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Deprecated
        public final Builder metadata(@Nullable GenericMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public ImmutableIcebergView build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIcebergView(this.id, this.metadataLocation, this.versionId, this.schemaId, this.sqlText, this.dialect, this.metadata);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("metadataLocation");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("versionId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("schemaId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("sqlText");
            }
            return "Cannot build IcebergView, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="IcebergView", generator="Immutables")
    static final class Json
    extends IcebergView {
        @Nullable
        String id;
        @Nullable
        String metadataLocation;
        int versionId;
        boolean versionIdIsSet;
        int schemaId;
        boolean schemaIdIsSet;
        @Nullable
        String sqlText;
        @Nullable
        String dialect;
        @Nullable
        GenericMetadata metadata;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="metadataLocation")
        public void setMetadataLocation(String metadataLocation) {
            this.metadataLocation = metadataLocation;
        }

        @JsonProperty(value="versionId")
        public void setVersionId(int versionId) {
            this.versionId = versionId;
            this.versionIdIsSet = true;
        }

        @JsonProperty(value="schemaId")
        public void setSchemaId(int schemaId) {
            this.schemaId = schemaId;
            this.schemaIdIsSet = true;
        }

        @JsonProperty(value="sqlText")
        public void setSqlText(String sqlText) {
            this.sqlText = sqlText;
        }

        @JsonProperty(value="dialect")
        public void setDialect(@Nullable String dialect) {
            this.dialect = dialect;
        }

        @JsonProperty(value="metadata")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setMetadata(@Nullable GenericMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMetadataLocation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getVersionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getSchemaId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSqlText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDialect() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GenericMetadata getMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

