/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.DiscriminatorMapping;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.DeltaLakeTable;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Util;
import org.projectnessie.model.types.ContentTypeIdResolver;
import org.projectnessie.model.types.ContentTypes;

@Schema(type=SchemaType.OBJECT, title="Content", oneOf={IcebergTable.class, DeltaLakeTable.class, IcebergView.class, Namespace.class}, discriminatorMapping={@DiscriminatorMapping(value="ICEBERG_TABLE", schema=IcebergTable.class), @DiscriminatorMapping(value="DELTA_LAKE_TABLE", schema=DeltaLakeTable.class), @DiscriminatorMapping(value="ICEBERG_VIEW", schema=IcebergView.class), @DiscriminatorMapping(value="NAMESPACE", schema=Namespace.class)}, discriminatorProperty="type")
@JsonTypeIdResolver(value=ContentTypeIdResolver.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="type")
public abstract class Content {
    @Nullable
    public abstract String getId();

    @JsonIgnore
    @Value.Redacted
    public abstract Type getType();

    public <T> Optional<T> unwrap(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        if (clazz.isAssignableFrom(this.getClass())) {
            return Optional.of(clazz.cast(this));
        }
        return Optional.empty();
    }

    @JsonDeserialize(using=Util.ContentTypeDeserializer.class)
    @JsonSerialize(using=Util.ContentTypeSerializer.class)
    public static interface Type {
        public static final Type UNKNOWN = ContentTypes.forName("UNKNOWN");
        public static final Type ICEBERG_TABLE = ContentTypes.forName("ICEBERG_TABLE");
        public static final Type DELTA_LAKE_TABLE = ContentTypes.forName("DELTA_LAKE_TABLE");
        public static final Type ICEBERG_VIEW = ContentTypes.forName("ICEBERG_VIEW");
        public static final Type NAMESPACE = ContentTypes.forName("NAMESPACE");

        public String name();

        public Class<? extends Content> type();
    }
}

