/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.v1api;

import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.projectnessie.api.params.ImmutableNamespaceUpdate;
import org.projectnessie.api.params.NamespaceParams;
import org.projectnessie.api.params.NamespaceParamsBuilder;
import org.projectnessie.client.api.UpdateNamespaceBuilder;
import org.projectnessie.client.http.NessieApiClient;
import org.projectnessie.client.http.v1api.BaseHttpRequest;
import org.projectnessie.error.NessieNamespaceNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.Namespace;

final class HttpUpdateNamespace
extends BaseHttpRequest
implements UpdateNamespaceBuilder {
    private final NamespaceParamsBuilder builder = NamespaceParams.builder();
    private final ImmutableNamespaceUpdate.Builder updateBuilder = ImmutableNamespaceUpdate.builder();

    HttpUpdateNamespace(NessieApiClient client) {
        super(client);
    }

    @Override
    public UpdateNamespaceBuilder namespace(Namespace namespace) {
        this.builder.namespace(namespace);
        return this;
    }

    @Override
    public UpdateNamespaceBuilder refName(String refName) {
        this.builder.refName(refName);
        return this;
    }

    @Override
    public UpdateNamespaceBuilder hashOnRef(@Nullable String hashOnRef) {
        this.builder.hashOnRef(hashOnRef);
        return this;
    }

    @Override
    public UpdateNamespaceBuilder removeProperties(Set<String> propertyRemovals) {
        this.updateBuilder.addAllPropertyRemovals(propertyRemovals);
        return this;
    }

    @Override
    public UpdateNamespaceBuilder updateProperty(String key, String value) {
        this.updateBuilder.putPropertyUpdates(key, value);
        return this;
    }

    @Override
    public UpdateNamespaceBuilder removeProperty(String key) {
        this.updateBuilder.addPropertyRemovals(key);
        return this;
    }

    @Override
    public UpdateNamespaceBuilder updateProperties(Map<String, String> propertyUpdates) {
        this.updateBuilder.putAllPropertyUpdates(propertyUpdates);
        return this;
    }

    @Override
    public void update() throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        this.client.getNamespaceApi().updateProperties(this.builder.build(), this.updateBuilder.build());
    }
}

