/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.net.ssl.SSLContext;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;
import org.projectnessie.client.http.RequestFilter;
import org.projectnessie.client.http.ResponseFilter;
import org.projectnessie.client.http.impl.HttpRuntimeConfig;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HttpRuntimeConfig", generator="Immutables")
@Immutable
public final class ImmutableHttpRuntimeConfig
implements HttpRuntimeConfig {
    private final URI baseUri;
    private final ObjectMapper mapper;
    private final int readTimeoutMillis;
    private final int connectionTimeoutMillis;
    private final boolean isDisableCompression;
    private final SSLContext sslContext;
    private final List<RequestFilter> requestFilters;
    private final List<ResponseFilter> responseFilters;

    private ImmutableHttpRuntimeConfig(URI baseUri, ObjectMapper mapper, int readTimeoutMillis, int connectionTimeoutMillis, boolean isDisableCompression, SSLContext sslContext, List<RequestFilter> requestFilters, List<ResponseFilter> responseFilters) {
        this.baseUri = baseUri;
        this.mapper = mapper;
        this.readTimeoutMillis = readTimeoutMillis;
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        this.isDisableCompression = isDisableCompression;
        this.sslContext = sslContext;
        this.requestFilters = requestFilters;
        this.responseFilters = responseFilters;
    }

    @Override
    public URI getBaseUri() {
        return this.baseUri;
    }

    @Override
    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    @Override
    public int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    @Override
    public boolean isDisableCompression() {
        return this.isDisableCompression;
    }

    @Override
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    @Override
    public List<RequestFilter> getRequestFilters() {
        return this.requestFilters;
    }

    @Override
    public List<ResponseFilter> getResponseFilters() {
        return this.responseFilters;
    }

    public final ImmutableHttpRuntimeConfig withBaseUri(URI value) {
        if (this.baseUri == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "baseUri");
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(newValue, this.mapper, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, this.requestFilters, this.responseFilters));
    }

    public final ImmutableHttpRuntimeConfig withMapper(ObjectMapper value) {
        if (this.mapper == value) {
            return this;
        }
        ObjectMapper newValue = Objects.requireNonNull(value, "mapper");
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, newValue, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, this.requestFilters, this.responseFilters));
    }

    public final ImmutableHttpRuntimeConfig withReadTimeoutMillis(int value) {
        if (this.readTimeoutMillis == value) {
            return this;
        }
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, value, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, this.requestFilters, this.responseFilters));
    }

    public final ImmutableHttpRuntimeConfig withConnectionTimeoutMillis(int value) {
        if (this.connectionTimeoutMillis == value) {
            return this;
        }
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.readTimeoutMillis, value, this.isDisableCompression, this.sslContext, this.requestFilters, this.responseFilters));
    }

    public final ImmutableHttpRuntimeConfig withIsDisableCompression(boolean value) {
        if (this.isDisableCompression == value) {
            return this;
        }
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.readTimeoutMillis, this.connectionTimeoutMillis, value, this.sslContext, this.requestFilters, this.responseFilters));
    }

    public final ImmutableHttpRuntimeConfig withSslContext(SSLContext value) {
        if (this.sslContext == value) {
            return this;
        }
        SSLContext newValue = Objects.requireNonNull(value, "sslContext");
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, newValue, this.requestFilters, this.responseFilters));
    }

    public final ImmutableHttpRuntimeConfig withRequestFilters(RequestFilter ... elements) {
        List<RequestFilter> newValue = ImmutableHttpRuntimeConfig.createUnmodifiableList(false, ImmutableHttpRuntimeConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, newValue, this.responseFilters));
    }

    public final ImmutableHttpRuntimeConfig withRequestFilters(Iterable<? extends RequestFilter> elements) {
        if (this.requestFilters == elements) {
            return this;
        }
        List<RequestFilter> newValue = ImmutableHttpRuntimeConfig.createUnmodifiableList(false, ImmutableHttpRuntimeConfig.createSafeList(elements, true, false));
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, newValue, this.responseFilters));
    }

    public final ImmutableHttpRuntimeConfig withResponseFilters(ResponseFilter ... elements) {
        List<ResponseFilter> newValue = ImmutableHttpRuntimeConfig.createUnmodifiableList(false, ImmutableHttpRuntimeConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, this.requestFilters, newValue));
    }

    public final ImmutableHttpRuntimeConfig withResponseFilters(Iterable<? extends ResponseFilter> elements) {
        if (this.responseFilters == elements) {
            return this;
        }
        List<ResponseFilter> newValue = ImmutableHttpRuntimeConfig.createUnmodifiableList(false, ImmutableHttpRuntimeConfig.createSafeList(elements, true, false));
        return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, this.requestFilters, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHttpRuntimeConfig && this.equalTo(0, (ImmutableHttpRuntimeConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableHttpRuntimeConfig another) {
        return this.baseUri.equals(another.baseUri) && this.mapper.equals(another.mapper) && this.readTimeoutMillis == another.readTimeoutMillis && this.connectionTimeoutMillis == another.connectionTimeoutMillis && this.isDisableCompression == another.isDisableCompression && this.sslContext.equals(another.sslContext) && this.requestFilters.equals(another.requestFilters) && this.responseFilters.equals(another.responseFilters);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.baseUri.hashCode();
        h2 += (h2 << 5) + this.mapper.hashCode();
        h2 += (h2 << 5) + this.readTimeoutMillis;
        h2 += (h2 << 5) + this.connectionTimeoutMillis;
        h2 += (h2 << 5) + Boolean.hashCode(this.isDisableCompression);
        h2 += (h2 << 5) + this.sslContext.hashCode();
        h2 += (h2 << 5) + this.requestFilters.hashCode();
        h2 += (h2 << 5) + this.responseFilters.hashCode();
        return h2;
    }

    public String toString() {
        return "HttpRuntimeConfig{baseUri=" + this.baseUri + ", mapper=" + this.mapper + ", readTimeoutMillis=" + this.readTimeoutMillis + ", connectionTimeoutMillis=" + this.connectionTimeoutMillis + ", isDisableCompression=" + this.isDisableCompression + ", sslContext=" + this.sslContext + ", requestFilters=" + this.requestFilters + ", responseFilters=" + this.responseFilters + "}";
    }

    private static ImmutableHttpRuntimeConfig validate(ImmutableHttpRuntimeConfig instance) {
        instance.check();
        return instance;
    }

    public static ImmutableHttpRuntimeConfig copyOf(HttpRuntimeConfig instance) {
        if (instance instanceof ImmutableHttpRuntimeConfig) {
            return (ImmutableHttpRuntimeConfig)instance;
        }
        return ImmutableHttpRuntimeConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="HttpRuntimeConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BASE_URI = 1L;
        private static final long INIT_BIT_MAPPER = 2L;
        private static final long INIT_BIT_READ_TIMEOUT_MILLIS = 4L;
        private static final long INIT_BIT_CONNECTION_TIMEOUT_MILLIS = 8L;
        private static final long INIT_BIT_IS_DISABLE_COMPRESSION = 16L;
        private static final long INIT_BIT_SSL_CONTEXT = 32L;
        private long initBits = 63L;
        @Nullable
        private URI baseUri;
        @Nullable
        private ObjectMapper mapper;
        private int readTimeoutMillis;
        private int connectionTimeoutMillis;
        private boolean isDisableCompression;
        @Nullable
        private SSLContext sslContext;
        private List<RequestFilter> requestFilters = new ArrayList<RequestFilter>();
        private List<ResponseFilter> responseFilters = new ArrayList<ResponseFilter>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HttpRuntimeConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.baseUri(instance.getBaseUri());
            this.mapper(instance.getMapper());
            this.readTimeoutMillis(instance.getReadTimeoutMillis());
            this.connectionTimeoutMillis(instance.getConnectionTimeoutMillis());
            this.isDisableCompression(instance.isDisableCompression());
            this.sslContext(instance.getSslContext());
            this.addAllRequestFilters(instance.getRequestFilters());
            this.addAllResponseFilters(instance.getResponseFilters());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder baseUri(URI baseUri) {
            this.baseUri = Objects.requireNonNull(baseUri, "baseUri");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mapper(ObjectMapper mapper) {
            this.mapper = Objects.requireNonNull(mapper, "mapper");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder readTimeoutMillis(int readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder connectionTimeoutMillis(int connectionTimeoutMillis) {
            this.connectionTimeoutMillis = connectionTimeoutMillis;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isDisableCompression(boolean isDisableCompression) {
            this.isDisableCompression = isDisableCompression;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sslContext(SSLContext sslContext) {
            this.sslContext = Objects.requireNonNull(sslContext, "sslContext");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRequestFilters(RequestFilter element) {
            this.requestFilters.add(Objects.requireNonNull(element, "requestFilters element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRequestFilters(RequestFilter ... elements) {
            for (RequestFilter element : elements) {
                this.requestFilters.add(Objects.requireNonNull(element, "requestFilters element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder requestFilters(Iterable<? extends RequestFilter> elements) {
            this.requestFilters.clear();
            return this.addAllRequestFilters(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRequestFilters(Iterable<? extends RequestFilter> elements) {
            for (RequestFilter requestFilter : elements) {
                this.requestFilters.add(Objects.requireNonNull(requestFilter, "requestFilters element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addResponseFilters(ResponseFilter element) {
            this.responseFilters.add(Objects.requireNonNull(element, "responseFilters element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addResponseFilters(ResponseFilter ... elements) {
            for (ResponseFilter element : elements) {
                this.responseFilters.add(Objects.requireNonNull(element, "responseFilters element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder responseFilters(Iterable<? extends ResponseFilter> elements) {
            this.responseFilters.clear();
            return this.addAllResponseFilters(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllResponseFilters(Iterable<? extends ResponseFilter> elements) {
            for (ResponseFilter responseFilter : elements) {
                this.responseFilters.add(Objects.requireNonNull(responseFilter, "responseFilters element"));
            }
            return this;
        }

        public ImmutableHttpRuntimeConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableHttpRuntimeConfig.validate(new ImmutableHttpRuntimeConfig(this.baseUri, this.mapper, this.readTimeoutMillis, this.connectionTimeoutMillis, this.isDisableCompression, this.sslContext, ImmutableHttpRuntimeConfig.createUnmodifiableList(true, this.requestFilters), ImmutableHttpRuntimeConfig.createUnmodifiableList(true, this.responseFilters)));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("baseUri");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("mapper");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("readTimeoutMillis");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("connectionTimeoutMillis");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("isDisableCompression");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("sslContext");
            }
            return "Cannot build HttpRuntimeConfig, some of required attributes are not set " + attributes;
        }
    }
}

