/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.client.http.RequestContext;
import org.projectnessie.client.http.impl.HttpRuntimeConfig;

public abstract class BaseHttpRequest
extends HttpRequest {
    protected BaseHttpRequest(HttpRuntimeConfig config) {
        super(config);
    }

    protected boolean prepareRequest(RequestContext context) {
        boolean doesOutput;
        boolean postOrPut;
        this.headers.put("Accept", this.accept);
        HttpClient.Method method = context.getMethod();
        boolean bl = postOrPut = method == HttpClient.Method.PUT || method == HttpClient.Method.POST;
        if (postOrPut) {
            this.headers.put("Content-Type", this.contentsType);
        }
        boolean bl2 = doesOutput = postOrPut && context.getBody().isPresent();
        if (!this.config.isDisableCompression()) {
            this.headers.put("Accept-Encoding", "gzip;q=1.0, deflate;q=0.9");
            if (doesOutput) {
                this.headers.put("Content-Encoding", "gzip");
            }
        }
        this.config.getRequestFilters().forEach(a -> a.filter(context));
        return doesOutput;
    }

    protected OutputStream wrapOutputStream(OutputStream base) throws IOException {
        return this.config.isDisableCompression() ? new BufferedOutputStream(base) : new GZIPOutputStream(base);
    }

    protected void writeBody(HttpRuntimeConfig config, OutputStream out, Object body) throws IOException {
        Class<?> bodyType = body.getClass();
        if (bodyType != String.class) {
            config.getMapper().writerFor(bodyType).writeValue(out, body);
        } else {
            out.write(((String)body).getBytes(StandardCharsets.UTF_8));
        }
    }
}

