/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class PropertyUtil {
    private PropertyUtil() {
    }

    public static boolean propertyAsBoolean(Map<String, String> properties, String property, boolean defaultValue) {
        String value = properties.get(property);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public static Boolean propertyAsNullableBoolean(Map<String, String> properties, String property) {
        String value = properties.get(property);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    public static double propertyAsDouble(Map<String, String> properties, String property, double defaultValue) {
        String value = properties.get(property);
        if (value != null) {
            return Double.parseDouble(value);
        }
        return defaultValue;
    }

    public static int propertyAsInt(Map<String, String> properties, String property, int defaultValue) {
        String value = properties.get(property);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public static Integer propertyAsNullableInt(Map<String, String> properties, String property) {
        String value = properties.get(property);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return null;
    }

    public static long propertyAsLong(Map<String, String> properties, String property, long defaultValue) {
        String value = properties.get(property);
        if (value != null) {
            return Long.parseLong(value);
        }
        return defaultValue;
    }

    public static Long propertyAsNullableLong(Map<String, String> properties, String property) {
        String value = properties.get(property);
        if (value != null) {
            return Long.parseLong(value);
        }
        return null;
    }

    public static String propertyAsString(Map<String, String> properties, String property, String defaultValue) {
        String value = properties.get(property);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static Map<String, String> propertiesWithPrefix(Map<String, String> properties, String prefix) {
        if (properties == null || properties.isEmpty()) {
            return Collections.emptyMap();
        }
        Preconditions.checkArgument(prefix != null, "Invalid prefix: null");
        return properties.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix)).collect(Collectors.toMap(e -> ((String)e.getKey()).replaceFirst(prefix, ""), Map.Entry::getValue));
    }

    public static Map<String, String> applySchemaChanges(Map<String, String> properties, List<String> deletedColumns, Map<String, String> renamedColumns, Set<String> columnProperties) {
        if (properties.keySet().stream().noneMatch(key -> columnProperties.stream().anyMatch(key::startsWith))) {
            return properties;
        }
        HashMap<String, String> updatedProperties = Maps.newHashMap();
        properties.keySet().forEach(key -> {
            String prefix = columnProperties.stream().filter(key::startsWith).findFirst().orElse(null);
            if (prefix != null) {
                String columnAlias = key.replaceFirst(prefix, "");
                if (renamedColumns.get(columnAlias) != null) {
                    String newKey = prefix + (String)renamedColumns.get(columnAlias);
                    updatedProperties.put(newKey, (String)properties.get(key));
                } else if (!deletedColumns.contains(columnAlias)) {
                    updatedProperties.put((String)key, (String)properties.get(key));
                }
            } else {
                updatedProperties.put((String)key, (String)properties.get(key));
            }
        });
        return updatedProperties;
    }
}

