/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.orc.storage.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.iceberg.shaded.org.apache.orc.storage.common.ValidTxnList;
import org.apache.iceberg.shaded.org.apache.orc.storage.common.util.SuppressFBWarnings;

public class ValidReadTxnList
implements ValidTxnList {
    private static final int MIN_RANGE_LENGTH = 5;
    protected long[] exceptions;
    protected BitSet abortedBits;
    private long minOpenTxn = Long.MAX_VALUE;
    protected long highWatermark;

    public ValidReadTxnList() {
        this(new long[0], new BitSet(), Long.MAX_VALUE, Long.MAX_VALUE);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Ref external obj for efficiency")
    public ValidReadTxnList(long[] exceptions, BitSet abortedBits, long highWatermark, long minOpenTxn) {
        if (exceptions.length > 0) {
            this.minOpenTxn = minOpenTxn;
        }
        this.exceptions = exceptions;
        this.abortedBits = abortedBits;
        this.highWatermark = highWatermark;
    }

    public ValidReadTxnList(String value) {
        this.readFromString(value);
    }

    @Override
    public void removeException(long txnId) {
        this.exceptions = ArrayUtils.remove((long[])this.exceptions, (int)Arrays.binarySearch(this.exceptions, txnId));
    }

    @Override
    public boolean isTxnValid(long txnid) {
        if (txnid > this.highWatermark) {
            return false;
        }
        return Arrays.binarySearch(this.exceptions, txnid) < 0;
    }

    @Override
    public ValidTxnList.RangeResponse isTxnRangeValid(long minTxnId, long maxTxnId) {
        if (minTxnId > this.highWatermark) {
            return ValidTxnList.RangeResponse.NONE;
        }
        if (this.exceptions.length > 0 && this.exceptions[0] > maxTxnId) {
            return ValidTxnList.RangeResponse.ALL;
        }
        long count = Math.max(0L, maxTxnId - this.highWatermark);
        for (long txn : this.exceptions) {
            if (minTxnId > txn || txn > maxTxnId) continue;
            ++count;
        }
        if (count == 0L) {
            return ValidTxnList.RangeResponse.ALL;
        }
        if (count == maxTxnId - minTxnId + 1L) {
            return ValidTxnList.RangeResponse.NONE;
        }
        return ValidTxnList.RangeResponse.SOME;
    }

    public String toString() {
        return this.writeToString();
    }

    @Override
    public String writeToString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.highWatermark);
        buf.append(':');
        buf.append(this.minOpenTxn);
        if (this.exceptions.length == 0) {
            buf.append(':');
            buf.append(':');
        } else {
            StringBuilder open = new StringBuilder();
            StringBuilder abort = new StringBuilder();
            long abortedMin = -1L;
            long abortedMax = -1L;
            long openedMin = -1L;
            long openedMax = -1L;
            for (int i = 0; i < this.exceptions.length; ++i) {
                if (this.abortedBits.get(i)) {
                    if (abortedMax + 1L == this.exceptions[i]) {
                        ++abortedMax;
                        continue;
                    }
                    this.writeTxnRange(abort, abortedMin, abortedMax);
                    abortedMin = abortedMax = this.exceptions[i];
                    continue;
                }
                if (openedMax + 1L == this.exceptions[i]) {
                    ++openedMax;
                    continue;
                }
                this.writeTxnRange(open, openedMin, openedMax);
                openedMin = openedMax = this.exceptions[i];
            }
            this.writeTxnRange(abort, abortedMin, abortedMax);
            this.writeTxnRange(open, openedMin, openedMax);
            buf.append(':');
            buf.append((CharSequence)open);
            buf.append(':');
            buf.append((CharSequence)abort);
        }
        return buf.toString();
    }

    private void writeTxnRange(StringBuilder builder, long txnMin, long txnMax) {
        if (txnMax >= 0L) {
            if (builder.length() > 0) {
                builder.append(',');
            }
            if (txnMin == txnMax) {
                builder.append(txnMin);
            } else if (txnMin + 5L - 1L > txnMax) {
                for (long txn = txnMin; txn <= txnMax; ++txn) {
                    builder.append(txn);
                    if (txn == txnMax) continue;
                    builder.append(',');
                }
            } else {
                builder.append(txnMin).append('-').append(txnMax);
            }
        }
    }

    @Override
    public void readFromString(String src) {
        if (StringUtils.isEmpty((String)src)) {
            this.highWatermark = Long.MAX_VALUE;
            this.exceptions = new long[0];
            this.abortedBits = new BitSet();
            return;
        }
        String[] values = src.split(":");
        this.highWatermark = Long.parseLong(values[0]);
        this.minOpenTxn = Long.parseLong(values[1]);
        List<Object> openTxns = new ArrayList();
        List<Object> abortedTxns = new ArrayList();
        if (values.length == 3) {
            if (!values[2].isEmpty()) {
                openTxns = this.readTxnListFromRangeString(values[2]);
            }
        } else if (values.length > 3) {
            if (!values[2].isEmpty()) {
                openTxns = this.readTxnListFromRangeString(values[2]);
            }
            if (!values[3].isEmpty()) {
                abortedTxns = this.readTxnListFromRangeString(values[3]);
            }
        }
        this.exceptions = new long[openTxns.size() + abortedTxns.size()];
        this.abortedBits = new BitSet(this.exceptions.length);
        int exceptionIndex = 0;
        int openIndex = 0;
        int abortIndex = 0;
        while (openIndex < openTxns.size() || abortIndex < abortedTxns.size()) {
            if (abortIndex == abortedTxns.size() || openIndex < openTxns.size() && (Long)openTxns.get(openIndex) < (Long)abortedTxns.get(abortIndex)) {
                this.exceptions[exceptionIndex++] = (Long)openTxns.get(openIndex++);
                continue;
            }
            this.abortedBits.set(exceptionIndex);
            this.exceptions[exceptionIndex++] = (Long)abortedTxns.get(abortIndex++);
        }
    }

    private List<Long> readTxnListFromRangeString(String txnListString) {
        ArrayList<Long> txnList = new ArrayList<Long>();
        for (String txnRange : txnListString.split(",")) {
            if (txnRange.indexOf(45) < 0) {
                txnList.add(Long.parseLong(txnRange));
                continue;
            }
            String[] parts = txnRange.split("-");
            long txn = Long.parseLong(parts[0]);
            long txnEnd = Long.parseLong(parts[1]);
            while (txn <= txnEnd) {
                txnList.add(txn++);
            }
        }
        return txnList;
    }

    @Override
    public long getHighWatermark() {
        return this.highWatermark;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expose internal rep for efficiency")
    public long[] getInvalidTransactions() {
        return this.exceptions;
    }

    @Override
    public Long getMinOpenTxn() {
        return this.minOpenTxn == Long.MAX_VALUE ? null : Long.valueOf(this.minOpenTxn);
    }

    @Override
    public boolean isTxnAborted(long txnid) {
        int index = Arrays.binarySearch(this.exceptions, txnid);
        return index >= 0 && this.abortedBits.get(index);
    }

    @Override
    public ValidTxnList.RangeResponse isTxnRangeAborted(long minTxnId, long maxTxnId) {
        long abortedTxnId;
        if (this.highWatermark < minTxnId) {
            return ValidTxnList.RangeResponse.NONE;
        }
        int count = 0;
        int i = this.abortedBits.nextSetBit(0);
        while (i >= 0 && (abortedTxnId = this.exceptions[i]) <= maxTxnId) {
            if (abortedTxnId >= minTxnId && abortedTxnId <= maxTxnId) {
                ++count;
            }
            i = this.abortedBits.nextSetBit(i + 1);
        }
        if (count == 0) {
            return ValidTxnList.RangeResponse.NONE;
        }
        if ((long)count == maxTxnId - minTxnId + 1L) {
            return ValidTxnList.RangeResponse.ALL;
        }
        return ValidTxnList.RangeResponse.SOME;
    }
}

