/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.orc.OrcMetrics;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.MoreExecutors;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.iceberg.util.Tasks;

public class TableMigrationUtil {
    private static final PathFilter HIDDEN_PATH_FILTER = p -> !p.getName().startsWith("_") && !p.getName().startsWith(".");

    private TableMigrationUtil() {
    }

    public static List<DataFile> listPartition(Map<String, String> partition, String uri, String format, PartitionSpec spec, Configuration conf, MetricsConfig metricsConfig, NameMapping mapping) {
        return TableMigrationUtil.listPartition(partition, uri, format, spec, conf, metricsConfig, mapping, 1);
    }

    public static List<DataFile> listPartition(Map<String, String> partitionPath, String partitionUri, String format, PartitionSpec spec, Configuration conf, MetricsConfig metricsSpec, NameMapping mapping, int parallelism) {
        ExecutorService service = null;
        try {
            String partitionKey = spec.fields().stream().map(PartitionField::name).map(name -> String.format("%s=%s", name, partitionPath.get(name))).collect(Collectors.joining("/"));
            Path partition = new Path(partitionUri);
            FileSystem fs = partition.getFileSystem(conf);
            List fileStatus = Arrays.stream(fs.listStatus(partition, HIDDEN_PATH_FILTER)).filter(FileStatus::isFile).collect(Collectors.toList());
            DataFile[] datafiles = new DataFile[fileStatus.size()];
            Tasks.Builder<Integer> task = Tasks.range(fileStatus.size()).stopOnFailure().throwFailureWhenFinished();
            if (parallelism > 1) {
                service = TableMigrationUtil.migrationService(parallelism);
                task.executeWith(service);
            }
            if (format.contains("avro")) {
                task.run(index -> {
                    Metrics metrics = TableMigrationUtil.getAvroMetrics(((FileStatus)fileStatus.get((int)index)).getPath(), conf);
                    datafiles[index.intValue()] = TableMigrationUtil.buildDataFile((FileStatus)fileStatus.get((int)index), partitionKey, spec, metrics, "avro");
                });
            } else if (format.contains("parquet")) {
                task.run(index -> {
                    Metrics metrics = TableMigrationUtil.getParquetMetrics(((FileStatus)fileStatus.get((int)index)).getPath(), conf, metricsSpec, mapping);
                    datafiles[index.intValue()] = TableMigrationUtil.buildDataFile((FileStatus)fileStatus.get((int)index), partitionKey, spec, metrics, "parquet");
                });
            } else if (format.contains("orc")) {
                task.run(index -> {
                    Metrics metrics = TableMigrationUtil.getOrcMetrics(((FileStatus)fileStatus.get((int)index)).getPath(), conf, metricsSpec, mapping);
                    datafiles[index.intValue()] = TableMigrationUtil.buildDataFile((FileStatus)fileStatus.get((int)index), partitionKey, spec, metrics, "orc");
                });
            } else {
                throw new UnsupportedOperationException("Unknown partition format: " + format);
            }
            List<DataFile> list = Arrays.asList(datafiles);
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to list files in partition: " + partitionUri, e);
        }
        finally {
            if (service != null) {
                service.shutdown();
            }
        }
    }

    private static Metrics getAvroMetrics(Path path, Configuration conf) {
        try {
            HadoopInputFile file = HadoopInputFile.fromPath(path, conf);
            long rowCount = Avro.rowCount(file);
            return new Metrics(rowCount, null, null, null, null);
        }
        catch (UncheckedIOException e) {
            throw new RuntimeException("Unable to read Avro file: " + path, e);
        }
    }

    private static Metrics getParquetMetrics(Path path, Configuration conf, MetricsConfig metricsSpec, NameMapping mapping) {
        try {
            HadoopInputFile file = HadoopInputFile.fromPath(path, conf);
            return ParquetUtil.fileMetrics(file, metricsSpec, mapping);
        }
        catch (UncheckedIOException e) {
            throw new RuntimeException("Unable to read the metrics of the Parquet file: " + path, e);
        }
    }

    private static Metrics getOrcMetrics(Path path, Configuration conf, MetricsConfig metricsSpec, NameMapping mapping) {
        try {
            return OrcMetrics.fromInputFile(HadoopInputFile.fromPath(path, conf), metricsSpec, mapping);
        }
        catch (UncheckedIOException e) {
            throw new RuntimeException("Unable to read the metrics of the Orc file: " + path, e);
        }
    }

    private static DataFile buildDataFile(FileStatus stat, String partitionKey, PartitionSpec spec, Metrics metrics, String format) {
        return DataFiles.builder(spec).withPath(stat.getPath().toString()).withFormat(format).withFileSizeInBytes(stat.getLen()).withMetrics(metrics).withPartitionPath(partitionKey).build();
    }

    private static ExecutorService migrationService(int concurrentDeletes) {
        return MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)Executors.newFixedThreadPool(concurrentDeletes, new ThreadFactoryBuilder().setNameFormat("table-migration-%d").build()));
    }
}

