/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.actions.BaseSnapshotUpdateAction;
import org.apache.iceberg.actions.RewriteDataFilesActionResult;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.ListMultimap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Multimaps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.StructLikeWrapper;
import org.apache.iceberg.util.TableScanUtil;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRewriteDataFilesAction<ThisT>
extends BaseSnapshotUpdateAction<ThisT, RewriteDataFilesActionResult> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseRewriteDataFilesAction.class);
    private final Table table;
    private final FileIO fileIO;
    private final EncryptionManager encryptionManager;
    private boolean caseSensitive;
    private PartitionSpec spec;
    private Expression filter;
    private long targetSizeInBytes;
    private int splitLookback;
    private long splitOpenFileCost;

    protected BaseRewriteDataFilesAction(Table table) {
        this.table = table;
        this.spec = table.spec();
        this.filter = Expressions.alwaysTrue();
        this.caseSensitive = false;
        long splitSize = PropertyUtil.propertyAsLong(table.properties(), "read.split.target-size", 0x8000000L);
        long targetFileSize = PropertyUtil.propertyAsLong(table.properties(), "write.target-file-size-bytes", 0x20000000L);
        this.targetSizeInBytes = Math.min(splitSize, targetFileSize);
        this.splitLookback = PropertyUtil.propertyAsInt(table.properties(), "read.split.planning-lookback", 10);
        this.splitOpenFileCost = PropertyUtil.propertyAsLong(table.properties(), "read.split.open-file-cost", 0x400000L);
        this.fileIO = this.fileIO();
        this.encryptionManager = table.encryption();
    }

    @Override
    protected Table table() {
        return this.table;
    }

    protected PartitionSpec spec() {
        return this.spec;
    }

    protected EncryptionManager encryptionManager() {
        return this.encryptionManager;
    }

    protected boolean caseSensitive() {
        return this.caseSensitive;
    }

    public BaseRewriteDataFilesAction<ThisT> caseSensitive(boolean newCaseSensitive) {
        this.caseSensitive = newCaseSensitive;
        return this;
    }

    public BaseRewriteDataFilesAction<ThisT> outputSpecId(int specId) {
        Preconditions.checkArgument(this.table.specs().containsKey(specId), "Invalid spec id %s", specId);
        this.spec = this.table.specs().get(specId);
        return this;
    }

    public BaseRewriteDataFilesAction<ThisT> targetSizeInBytes(long targetSize) {
        Preconditions.checkArgument(targetSize > 0L, "Invalid target rewrite data file size in bytes %s", targetSize);
        this.targetSizeInBytes = targetSize;
        return this;
    }

    public BaseRewriteDataFilesAction<ThisT> splitLookback(int lookback) {
        Preconditions.checkArgument((long)lookback > 0L, "Invalid split lookback %s", lookback);
        this.splitLookback = lookback;
        return this;
    }

    public BaseRewriteDataFilesAction<ThisT> splitOpenFileCost(long openFileCost) {
        Preconditions.checkArgument(openFileCost > 0L, "Invalid split openFileCost %s", openFileCost);
        this.splitOpenFileCost = openFileCost;
        return this;
    }

    public BaseRewriteDataFilesAction<ThisT> filter(Expression expr) {
        this.filter = Expressions.and(this.filter, expr);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RewriteDataFilesActionResult execute() {
        CloseableIterable fileScanTasks = null;
        if (this.table.currentSnapshot() == null) {
            return RewriteDataFilesActionResult.empty();
        }
        long startingSnapshotId = this.table.currentSnapshot().snapshotId();
        try {
            fileScanTasks = ((TableScan)((TableScan)((TableScan)this.table.newScan().useSnapshot(startingSnapshotId).caseSensitive(this.caseSensitive)).ignoreResiduals()).filter(this.filter)).planFiles();
        }
        finally {
            try {
                if (fileScanTasks != null) {
                    fileScanTasks.close();
                }
            }
            catch (IOException ioe) {
                LOG.warn("Failed to close task iterable", (Throwable)ioe);
            }
        }
        Map<StructLikeWrapper, Collection<FileScanTask>> groupedTasks = this.groupTasksByPartition((CloseableIterator<FileScanTask>)fileScanTasks.iterator());
        Map<StructLikeWrapper, Collection> filteredGroupedTasks = groupedTasks.entrySet().stream().filter((? super T kv) -> ((Collection)kv.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (filteredGroupedTasks.isEmpty()) {
            return RewriteDataFilesActionResult.empty();
        }
        List<CombinedScanTask> combinedScanTasks = filteredGroupedTasks.values().stream().map(scanTasks -> {
            CloseableIterable<FileScanTask> splitTasks = TableScanUtil.splitFiles(CloseableIterable.withNoopClose(scanTasks), this.targetSizeInBytes);
            return TableScanUtil.planTasks(splitTasks, this.targetSizeInBytes, this.splitLookback, this.splitOpenFileCost);
        }).flatMap(Streams::stream).filter((? super T task) -> task.files().size() > 1 || this.isPartialFileScan((CombinedScanTask)task)).collect(Collectors.toList());
        if (combinedScanTasks.isEmpty()) {
            return RewriteDataFilesActionResult.empty();
        }
        List<DataFile> addedDataFiles = this.rewriteDataForTasks(combinedScanTasks);
        List<DataFile> currentDataFiles = combinedScanTasks.stream().flatMap(tasks -> tasks.files().stream().map(ContentScanTask::file)).collect(Collectors.toList());
        this.replaceDataFiles(currentDataFiles, addedDataFiles, startingSnapshotId);
        return new RewriteDataFilesActionResult(currentDataFiles, addedDataFiles);
    }

    private Map<StructLikeWrapper, Collection<FileScanTask>> groupTasksByPartition(CloseableIterator<FileScanTask> tasksIter) {
        ListMultimap tasksGroupedByPartition = Multimaps.newListMultimap(Maps.newHashMap(), Lists::newArrayList);
        StructLikeWrapper partitionWrapper = StructLikeWrapper.forType(this.spec.partitionType());
        try (CloseableIterator<FileScanTask> iterator = tasksIter;){
            iterator.forEachRemaining(task -> {
                StructLikeWrapper structLike = partitionWrapper.copyFor(((DataFile)task.file()).partition());
                tasksGroupedByPartition.put(structLike, task);
            });
        }
        catch (IOException e) {
            LOG.warn("Failed to close task iterator", (Throwable)e);
        }
        return tasksGroupedByPartition.asMap();
    }

    private void replaceDataFiles(Iterable<DataFile> deletedDataFiles, Iterable<DataFile> addedDataFiles, long startingSnapshotId) {
        try {
            this.doReplace(deletedDataFiles, addedDataFiles, startingSnapshotId);
        }
        catch (CommitStateUnknownException e) {
            LOG.warn("Commit state unknown, cannot clean up files that may have been committed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.warn("Failed to commit rewrite, cleaning up rewritten files", (Throwable)e);
            Tasks.foreach(Iterables.transform(addedDataFiles, f -> f.path().toString())).noRetry().suppressFailureWhenFinished().onFailure((location, exc) -> LOG.warn("Failed to delete: {}", location, (Object)exc)).run(this.fileIO::deleteFile);
            throw e;
        }
    }

    @VisibleForTesting
    void doReplace(Iterable<DataFile> deletedDataFiles, Iterable<DataFile> addedDataFiles, long startingSnapshotId) {
        RewriteFiles rewriteFiles = this.table.newRewrite().validateFromSnapshot(startingSnapshotId).rewriteFiles(Sets.newHashSet(deletedDataFiles), Sets.newHashSet(addedDataFiles));
        this.commit(rewriteFiles);
    }

    private boolean isPartialFileScan(CombinedScanTask task) {
        if (task.files().size() == 1) {
            FileScanTask fileScanTask = task.files().iterator().next();
            return ((DataFile)fileScanTask.file()).fileSizeInBytes() != fileScanTask.length();
        }
        return false;
    }

    protected abstract FileIO fileIO();

    protected abstract List<DataFile> rewriteDataForTasks(List<CombinedScanTask> var1);
}

