/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BaseTableScan;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StaticTableScan;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.Types;

public class RefsTable
extends BaseMetadataTable {
    private static final Schema SNAPSHOT_REF_SCHEMA = new Schema(Types.NestedField.required(1, "name", Types.StringType.get()), Types.NestedField.required(2, "type", Types.StringType.get()), Types.NestedField.required(3, "snapshot_id", Types.LongType.get()), Types.NestedField.optional(4, "max_reference_age_in_ms", Types.LongType.get()), Types.NestedField.optional(5, "min_snapshots_to_keep", Types.IntegerType.get()), Types.NestedField.optional(6, "max_snapshot_age_in_ms", Types.LongType.get()));

    RefsTable(TableOperations ops, Table table) {
        this(ops, table, table.name() + ".refs");
    }

    RefsTable(TableOperations ops, Table table, String name) {
        super(ops, table, name);
    }

    @Override
    public TableScan newScan() {
        return new RefsTableScan(this.operations(), this.table());
    }

    @Override
    public Schema schema() {
        return SNAPSHOT_REF_SCHEMA;
    }

    private DataTask task(BaseTableScan scan) {
        TableOperations ops = this.operations();
        Set<String> refNames = ops.current().refs().keySet();
        return StaticDataTask.of(ops.io().newInputFile(ops.current().metadataFileLocation()), this.schema(), scan.schema(), refNames, RefsTable.referencesToRows(ops.current().refs()));
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.REFS;
    }

    private static Function<String, StaticDataTask.Row> referencesToRows(Map<String, SnapshotRef> refs) {
        return refName -> StaticDataTask.Row.of(refName, ((SnapshotRef)refs.get(refName)).type().name(), ((SnapshotRef)refs.get(refName)).snapshotId(), ((SnapshotRef)refs.get(refName)).maxRefAgeMs(), ((SnapshotRef)refs.get(refName)).minSnapshotsToKeep(), ((SnapshotRef)refs.get(refName)).maxSnapshotAgeMs());
    }

    private class RefsTableScan
    extends StaticTableScan {
        RefsTableScan(TableOperations ops, Table table) {
            super(ops, table, SNAPSHOT_REF_SCHEMA, MetadataTableType.REFS, (StaticTableScan x$0) -> RefsTable.this.task(x$0));
        }

        RefsTableScan(TableOperations ops, Table table, TableScanContext context) {
            super(ops, table, SNAPSHOT_REF_SCHEMA, MetadataTableType.REFS, x$0 -> RefsTable.this.task(x$0), context);
        }

        @Override
        protected TableScan newRefinedScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            return new RefsTableScan(ops, table, context);
        }

        @Override
        public CloseableIterable<FileScanTask> planFiles() {
            return CloseableIterable.withNoopClose(RefsTable.this.task(this));
        }
    }
}

