/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.SnapshotRefType;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.UnboundPartitionSpec;
import org.apache.iceberg.UnboundSortOrder;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;

public interface MetadataUpdate
extends Serializable {
    public void applyTo(TableMetadata.Builder var1);

    public static class SetLocation
    implements MetadataUpdate {
        private final String location;

        public SetLocation(String location) {
            this.location = location;
        }

        public String location() {
            return this.location;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.setLocation(this.location);
        }
    }

    public static class RemoveProperties
    implements MetadataUpdate {
        private final Set<String> removed;

        public RemoveProperties(Set<String> removed) {
            this.removed = removed;
        }

        public Set<String> removed() {
            return this.removed;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.removeProperties(this.removed);
        }
    }

    public static class SetProperties
    implements MetadataUpdate {
        private final Map<String, String> updated;

        public SetProperties(Map<String, String> updated) {
            this.updated = updated;
        }

        public Map<String, String> updated() {
            return this.updated;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.setProperties(this.updated);
        }
    }

    public static class SetSnapshotRef
    implements MetadataUpdate {
        private final String refName;
        private final Long snapshotId;
        private final SnapshotRefType type;
        private Integer minSnapshotsToKeep;
        private Long maxSnapshotAgeMs;
        private Long maxRefAgeMs;

        public SetSnapshotRef(String refName, Long snapshotId, SnapshotRefType type, Integer minSnapshotsToKeep, Long maxSnapshotAgeMs, Long maxRefAgeMs) {
            this.refName = refName;
            this.snapshotId = snapshotId;
            this.type = type;
            this.minSnapshotsToKeep = minSnapshotsToKeep;
            this.maxSnapshotAgeMs = maxSnapshotAgeMs;
            this.maxRefAgeMs = maxRefAgeMs;
        }

        public String name() {
            return this.refName;
        }

        public String type() {
            return this.type.name().toLowerCase(Locale.ROOT);
        }

        public long snapshotId() {
            return this.snapshotId;
        }

        public Integer minSnapshotsToKeep() {
            return this.minSnapshotsToKeep;
        }

        public Long maxSnapshotAgeMs() {
            return this.maxSnapshotAgeMs;
        }

        public Long maxRefAgeMs() {
            return this.maxRefAgeMs;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            SnapshotRef ref = SnapshotRef.builderFor(this.snapshotId, this.type).minSnapshotsToKeep(this.minSnapshotsToKeep).maxSnapshotAgeMs(this.maxSnapshotAgeMs).maxRefAgeMs(this.maxRefAgeMs).build();
            metadataBuilder.setRef(this.refName, ref);
        }
    }

    public static class RemoveSnapshotRef
    implements MetadataUpdate {
        private final String refName;

        public RemoveSnapshotRef(String refName) {
            this.refName = refName;
        }

        public String name() {
            return this.refName;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.removeRef(this.refName);
        }
    }

    public static class RemoveSnapshot
    implements MetadataUpdate {
        private final long snapshotId;

        public RemoveSnapshot(long snapshotId) {
            this.snapshotId = snapshotId;
        }

        public long snapshotId() {
            return this.snapshotId;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.removeSnapshots(ImmutableSet.of(Long.valueOf(this.snapshotId)));
        }
    }

    public static class AddSnapshot
    implements MetadataUpdate {
        private final Snapshot snapshot;

        public AddSnapshot(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.addSnapshot(this.snapshot);
        }
    }

    public static class RemoveStatistics
    implements MetadataUpdate {
        private final long snapshotId;

        public RemoveStatistics(long snapshotId) {
            this.snapshotId = snapshotId;
        }

        public long snapshotId() {
            return this.snapshotId;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.removeStatistics(this.snapshotId);
        }
    }

    public static class SetStatistics
    implements MetadataUpdate {
        private final long snapshotId;
        private final StatisticsFile statisticsFile;

        public SetStatistics(long snapshotId, StatisticsFile statisticsFile) {
            this.snapshotId = snapshotId;
            this.statisticsFile = statisticsFile;
        }

        public long snapshotId() {
            return this.snapshotId;
        }

        public StatisticsFile statisticsFile() {
            return this.statisticsFile;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.setStatistics(this.snapshotId, this.statisticsFile);
        }
    }

    public static class SetDefaultSortOrder
    implements MetadataUpdate {
        private final int sortOrderId;

        public SetDefaultSortOrder(int sortOrderId) {
            this.sortOrderId = sortOrderId;
        }

        public int sortOrderId() {
            return this.sortOrderId;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.setDefaultSortOrder(this.sortOrderId);
        }
    }

    public static class AddSortOrder
    implements MetadataUpdate {
        private final UnboundSortOrder sortOrder;

        public AddSortOrder(SortOrder sortOrder) {
            this(sortOrder.toUnbound());
        }

        public AddSortOrder(UnboundSortOrder sortOrder) {
            this.sortOrder = sortOrder;
        }

        public UnboundSortOrder sortOrder() {
            return this.sortOrder;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.addSortOrder(this.sortOrder);
        }
    }

    public static class SetDefaultPartitionSpec
    implements MetadataUpdate {
        private final int specId;

        public SetDefaultPartitionSpec(int schemaId) {
            this.specId = schemaId;
        }

        public int specId() {
            return this.specId;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.setDefaultPartitionSpec(this.specId);
        }
    }

    public static class AddPartitionSpec
    implements MetadataUpdate {
        private final UnboundPartitionSpec spec;

        public AddPartitionSpec(PartitionSpec spec) {
            this(spec.toUnbound());
        }

        public AddPartitionSpec(UnboundPartitionSpec spec) {
            this.spec = spec;
        }

        public UnboundPartitionSpec spec() {
            return this.spec;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.addPartitionSpec(this.spec);
        }
    }

    public static class SetCurrentSchema
    implements MetadataUpdate {
        private final int schemaId;

        public SetCurrentSchema(int schemaId) {
            this.schemaId = schemaId;
        }

        public int schemaId() {
            return this.schemaId;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.setCurrentSchema(this.schemaId);
        }
    }

    public static class AddSchema
    implements MetadataUpdate {
        private final Schema schema;
        private final int lastColumnId;

        public AddSchema(Schema schema, int lastColumnId) {
            this.schema = schema;
            this.lastColumnId = lastColumnId;
        }

        public Schema schema() {
            return this.schema;
        }

        public int lastColumnId() {
            return this.lastColumnId;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.addSchema(this.schema, this.lastColumnId);
        }
    }

    public static class UpgradeFormatVersion
    implements MetadataUpdate {
        private final int formatVersion;

        public UpgradeFormatVersion(int formatVersion) {
            this.formatVersion = formatVersion;
        }

        public int formatVersion() {
            return this.formatVersion;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.upgradeFormatVersion(this.formatVersion);
        }
    }

    public static class AssignUUID
    implements MetadataUpdate {
        private final String uuid;

        public AssignUUID(String uuid) {
            this.uuid = uuid;
        }

        public String uuid() {
            return this.uuid;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.assignUUID(this.uuid);
        }
    }
}

