/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.BaseEntriesTable;
import org.apache.iceberg.BaseMetadataTableScan;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.io.CloseableIterable;

public class ManifestEntriesTable
extends BaseEntriesTable {
    ManifestEntriesTable(TableOperations ops, Table table) {
        this(ops, table, table.name() + ".entries");
    }

    ManifestEntriesTable(TableOperations ops, Table table, String name) {
        super(ops, table, name);
    }

    @Override
    public TableScan newScan() {
        return new EntriesTableScan(this.operations(), this.table(), this.schema());
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.ENTRIES;
    }

    private static class EntriesTableScan
    extends BaseMetadataTableScan {
        EntriesTableScan(TableOperations ops, Table table, Schema schema) {
            super(ops, table, schema, MetadataTableType.ENTRIES);
        }

        private EntriesTableScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            super(ops, table, schema, MetadataTableType.ENTRIES, context);
        }

        @Override
        protected TableScan newRefinedScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            return new EntriesTableScan(ops, table, schema, context);
        }

        @Override
        protected CloseableIterable<FileScanTask> doPlanFiles() {
            CloseableIterable<ManifestFile> manifests = CloseableIterable.withNoopClose(this.snapshot().allManifests(this.tableOps().io()));
            return BaseEntriesTable.planFiles(this.table(), manifests, this.tableSchema(), this.schema(), this.context());
        }
    }
}

