/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import java.util.function.Function;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.LocationUtil;
import org.apache.iceberg.util.PropertyUtil;

public class LocationProviders {
    private LocationProviders() {
    }

    public static LocationProvider locationsFor(String inputLocation, Map<String, String> properties) {
        String location = LocationUtil.stripTrailingSlash(inputLocation);
        if (properties.containsKey("write.location-provider.impl")) {
            DynConstructors.Ctor ctor;
            String impl = properties.get("write.location-provider.impl");
            try {
                ctor = DynConstructors.builder(LocationProvider.class).impl(impl, String.class, Map.class).impl(impl, new Class[0]).buildChecked();
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(String.format("Unable to find a constructor for implementation %s of %s. Make sure the implementation is in classpath, and that it either has a public no-arg constructor or a two-arg constructor taking in the string base table location and its property string map.", impl, LocationProvider.class), e);
            }
            try {
                return (LocationProvider)ctor.newInstance(location, properties);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(String.format("Provided implementation for dynamic instantiation should implement %s.", LocationProvider.class), e);
            }
        }
        if (PropertyUtil.propertyAsBoolean(properties, "write.object-storage.enabled", false)) {
            return new ObjectStoreLocationProvider(location, properties);
        }
        return new DefaultLocationProvider(location, properties);
    }

    static class ObjectStoreLocationProvider
    implements LocationProvider {
        private static final Function<Object, Integer> HASH_FUNC = Transforms.bucket(Integer.MAX_VALUE).bind(Types.StringType.get());
        private final String storageLocation;
        private final String context;

        ObjectStoreLocationProvider(String tableLocation, Map<String, String> properties) {
            this.storageLocation = LocationUtil.stripTrailingSlash(ObjectStoreLocationProvider.dataLocation(properties, tableLocation));
            this.context = this.storageLocation.startsWith(tableLocation) ? null : ObjectStoreLocationProvider.pathContext(tableLocation);
        }

        private static String dataLocation(Map<String, String> properties, String tableLocation) {
            String dataLocation = properties.get("write.data.path");
            if (dataLocation == null && (dataLocation = properties.get("write.object-storage.path")) == null && (dataLocation = properties.get("write.folder-storage.path")) == null) {
                dataLocation = String.format("%s/data", tableLocation);
            }
            return dataLocation;
        }

        @Override
        public String newDataLocation(PartitionSpec spec, StructLike partitionData, String filename) {
            return this.newDataLocation(String.format("%s/%s", spec.partitionToPath(partitionData), filename));
        }

        @Override
        public String newDataLocation(String filename) {
            int hash = HASH_FUNC.apply(filename);
            if (this.context != null) {
                return String.format("%s/%08x/%s/%s", this.storageLocation, hash, this.context, filename);
            }
            return String.format("%s/%08x/%s", this.storageLocation, hash, filename);
        }

        private static String pathContext(String tableLocation) {
            Path dataPath = new Path(tableLocation);
            Path parent = dataPath.getParent();
            String resolvedContext = parent != null ? String.format("%s/%s", parent.getName(), dataPath.getName()) : dataPath.getName();
            Preconditions.checkState(!resolvedContext.endsWith("/"), "Path context must not end with a slash.");
            return resolvedContext;
        }
    }

    static class DefaultLocationProvider
    implements LocationProvider {
        private final String dataLocation;

        DefaultLocationProvider(String tableLocation, Map<String, String> properties) {
            this.dataLocation = LocationUtil.stripTrailingSlash(DefaultLocationProvider.dataLocation(properties, tableLocation));
        }

        private static String dataLocation(Map<String, String> properties, String tableLocation) {
            String dataLocation = properties.get("write.data.path");
            if (dataLocation == null && (dataLocation = properties.get("write.folder-storage.path")) == null) {
                dataLocation = String.format("%s/data", tableLocation);
            }
            return dataLocation;
        }

        @Override
        public String newDataLocation(PartitionSpec spec, StructLike partitionData, String filename) {
            return String.format("%s/%s/%s", this.dataLocation, spec.partitionToPath(partitionData), filename);
        }

        @Override
        public String newDataLocation(String filename) {
            return String.format("%s/%s", this.dataLocation, filename);
        }
    }
}

