/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotProducer;
import org.apache.iceberg.SnapshotSummary;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.events.CreateSnapshotEvent;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

class FastAppend
extends SnapshotProducer<AppendFiles>
implements AppendFiles {
    private final String tableName;
    private final TableOperations ops;
    private final PartitionSpec spec;
    private final boolean snapshotIdInheritanceEnabled;
    private final SnapshotSummary.Builder summaryBuilder = SnapshotSummary.builder();
    private final List<DataFile> newFiles = Lists.newArrayList();
    private final List<ManifestFile> appendManifests = Lists.newArrayList();
    private final List<ManifestFile> rewrittenAppendManifests = Lists.newArrayList();
    private ManifestFile newManifest = null;
    private boolean hasNewFiles = false;

    FastAppend(String tableName, TableOperations ops) {
        super(ops);
        this.tableName = tableName;
        this.ops = ops;
        this.spec = ops.current().spec();
        this.snapshotIdInheritanceEnabled = ops.current().propertyAsBoolean("compatibility.snapshot-id-inheritance.enabled", false);
    }

    @Override
    protected AppendFiles self() {
        return this;
    }

    @Override
    public AppendFiles set(String property, String value) {
        this.summaryBuilder.set(property, value);
        return this;
    }

    @Override
    protected String operation() {
        return "append";
    }

    @Override
    protected Map<String, String> summary() {
        this.summaryBuilder.setPartitionSummaryLimit(this.ops.current().propertyAsInt("write.summary.partition-limit", 0));
        return this.summaryBuilder.build();
    }

    @Override
    public FastAppend appendFile(DataFile file) {
        this.hasNewFiles = true;
        this.newFiles.add(file);
        this.summaryBuilder.addedFile(this.spec, file);
        return this;
    }

    @Override
    public FastAppend toBranch(String branch) {
        this.targetBranch(branch);
        return this;
    }

    @Override
    public FastAppend appendManifest(ManifestFile manifest) {
        Preconditions.checkArgument(!manifest.hasExistingFiles(), "Cannot append manifest with existing files");
        Preconditions.checkArgument(!manifest.hasDeletedFiles(), "Cannot append manifest with deleted files");
        Preconditions.checkArgument(manifest.snapshotId() == null || manifest.snapshotId() == -1L, "Snapshot id must be assigned during commit");
        Preconditions.checkArgument(manifest.sequenceNumber() == -1L, "Sequence number must be assigned during commit");
        if (this.snapshotIdInheritanceEnabled && manifest.snapshotId() == null) {
            this.summaryBuilder.addedManifest(manifest);
            this.appendManifests.add(manifest);
        } else {
            ManifestFile copiedManifest = this.copyManifest(manifest);
            this.rewrittenAppendManifests.add(copiedManifest);
        }
        return this;
    }

    private ManifestFile copyManifest(ManifestFile manifest) {
        TableMetadata current = this.ops.current();
        InputFile toCopy = this.ops.io().newInputFile(manifest.path());
        OutputFile newManifestPath = this.newManifestOutput();
        return ManifestFiles.copyAppendManifest(current.formatVersion(), manifest.partitionSpecId(), toCopy, current.specsById(), newManifestPath, this.snapshotId(), this.summaryBuilder);
    }

    @Override
    @Deprecated
    public List<ManifestFile> apply(TableMetadata base) {
        return super.apply(base);
    }

    @Override
    public List<ManifestFile> apply(TableMetadata base, Snapshot snapshot) {
        ArrayList<ManifestFile> newManifests = Lists.newArrayList();
        try {
            ManifestFile manifest2 = this.writeManifest();
            if (manifest2 != null) {
                newManifests.add(manifest2);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to write manifest", new Object[0]);
        }
        Iterable appendManifestsWithMetadata = Iterables.transform(Iterables.concat(this.appendManifests, this.rewrittenAppendManifests), manifest -> GenericManifestFile.copyOf(manifest).withSnapshotId(this.snapshotId()).build());
        Iterables.addAll(newManifests, appendManifestsWithMetadata);
        if (snapshot != null) {
            newManifests.addAll(snapshot.allManifests(this.ops.io()));
        }
        return newManifests;
    }

    @Override
    public Object updateEvent() {
        long snapshotId = this.snapshotId();
        Snapshot snapshot = this.ops.current().snapshot(snapshotId);
        long sequenceNumber = snapshot.sequenceNumber();
        return new CreateSnapshotEvent(this.tableName, this.operation(), snapshotId, sequenceNumber, snapshot.summary());
    }

    @Override
    protected void cleanUncommitted(Set<ManifestFile> committed) {
        if (this.newManifest != null && !committed.contains(this.newManifest)) {
            this.deleteFile(this.newManifest.path());
        }
        for (ManifestFile manifest : this.rewrittenAppendManifests) {
            if (committed.contains(manifest)) continue;
            this.deleteFile(manifest.path());
        }
    }

    private ManifestFile writeManifest() throws IOException {
        if (this.hasNewFiles && this.newManifest != null) {
            this.deleteFile(this.newManifest.path());
            this.newManifest = null;
        }
        if (this.newManifest == null && this.newFiles.size() > 0) {
            try (ManifestWriter<DataFile> writer = this.newManifestWriter(this.spec);){
                writer.addAll(this.newFiles);
            }
            this.newManifest = writer.toManifestFile();
            this.hasNewFiles = false;
        }
        return this.newManifest;
    }
}

