/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestGroup;
import org.apache.iceberg.ManifestLists;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

class BaseSnapshot
implements Snapshot {
    private static final long INITIAL_SEQUENCE_NUMBER = 0L;
    private final long snapshotId;
    private final Long parentId;
    private final long sequenceNumber;
    private final long timestampMillis;
    private final String manifestListLocation;
    private final String operation;
    private final Map<String, String> summary;
    private final Integer schemaId;
    private final String[] v1ManifestLocations;
    private transient List<ManifestFile> allManifests = null;
    private transient List<ManifestFile> dataManifests = null;
    private transient List<ManifestFile> deleteManifests = null;
    private transient List<DataFile> addedDataFiles = null;
    private transient List<DataFile> removedDataFiles = null;
    private transient List<DeleteFile> addedDeleteFiles = null;
    private transient List<DeleteFile> removedDeleteFiles = null;

    BaseSnapshot(long sequenceNumber, long snapshotId, Long parentId, long timestampMillis, String operation, Map<String, String> summary, Integer schemaId, String manifestList) {
        this.sequenceNumber = sequenceNumber;
        this.snapshotId = snapshotId;
        this.parentId = parentId;
        this.timestampMillis = timestampMillis;
        this.operation = operation;
        this.summary = summary;
        this.schemaId = schemaId;
        this.manifestListLocation = manifestList;
        this.v1ManifestLocations = null;
    }

    BaseSnapshot(long sequenceNumber, long snapshotId, Long parentId, long timestampMillis, String operation, Map<String, String> summary, Integer schemaId, String[] v1ManifestLocations) {
        this.sequenceNumber = sequenceNumber;
        this.snapshotId = snapshotId;
        this.parentId = parentId;
        this.timestampMillis = timestampMillis;
        this.operation = operation;
        this.summary = summary;
        this.schemaId = schemaId;
        this.manifestListLocation = null;
        this.v1ManifestLocations = v1ManifestLocations;
    }

    @Override
    public long sequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public long snapshotId() {
        return this.snapshotId;
    }

    @Override
    public Long parentId() {
        return this.parentId;
    }

    @Override
    public long timestampMillis() {
        return this.timestampMillis;
    }

    @Override
    public String operation() {
        return this.operation;
    }

    @Override
    public Map<String, String> summary() {
        return this.summary;
    }

    @Override
    public Integer schemaId() {
        return this.schemaId;
    }

    private void cacheManifests(FileIO fileIO) {
        if (fileIO == null) {
            throw new IllegalArgumentException("Cannot cache changes: FileIO is null");
        }
        if (this.allManifests == null && this.v1ManifestLocations != null) {
            this.allManifests = Lists.transform(Arrays.asList(this.v1ManifestLocations), location -> new GenericManifestFile(fileIO.newInputFile((String)location), 0));
        }
        if (this.allManifests == null) {
            this.allManifests = ManifestLists.read(fileIO.newInputFile(this.manifestListLocation));
        }
        if (this.dataManifests == null || this.deleteManifests == null) {
            this.dataManifests = ImmutableList.copyOf(Iterables.filter(this.allManifests, manifest -> manifest.content() == ManifestContent.DATA));
            this.deleteManifests = ImmutableList.copyOf(Iterables.filter(this.allManifests, manifest -> manifest.content() == ManifestContent.DELETES));
        }
    }

    @Override
    public List<ManifestFile> allManifests(FileIO fileIO) {
        if (this.allManifests == null) {
            this.cacheManifests(fileIO);
        }
        return this.allManifests;
    }

    @Override
    public List<ManifestFile> dataManifests(FileIO fileIO) {
        if (this.dataManifests == null) {
            this.cacheManifests(fileIO);
        }
        return this.dataManifests;
    }

    @Override
    public List<ManifestFile> deleteManifests(FileIO fileIO) {
        if (this.deleteManifests == null) {
            this.cacheManifests(fileIO);
        }
        return this.deleteManifests;
    }

    public List<DataFile> addedDataFiles(FileIO fileIO) {
        if (this.addedDataFiles == null) {
            this.cacheDataFileChanges(fileIO);
        }
        return this.addedDataFiles;
    }

    public List<DataFile> removedDataFiles(FileIO fileIO) {
        if (this.removedDataFiles == null) {
            this.cacheDataFileChanges(fileIO);
        }
        return this.removedDataFiles;
    }

    @Override
    public Iterable<DeleteFile> addedDeleteFiles(FileIO fileIO) {
        if (this.addedDeleteFiles == null) {
            this.cacheDeleteFileChanges(fileIO);
        }
        return this.addedDeleteFiles;
    }

    @Override
    public Iterable<DeleteFile> removedDeleteFiles(FileIO fileIO) {
        if (this.removedDeleteFiles == null) {
            this.cacheDeleteFileChanges(fileIO);
        }
        return this.removedDeleteFiles;
    }

    @Override
    public String manifestListLocation() {
        return this.manifestListLocation;
    }

    private void cacheDeleteFileChanges(FileIO fileIO) {
        Preconditions.checkArgument(fileIO != null, "Cannot cache delete file changes: FileIO is null");
        ImmutableList.Builder adds = ImmutableList.builder();
        ImmutableList.Builder deletes = ImmutableList.builder();
        Iterable<ManifestFile> changedManifests = Iterables.filter(this.deleteManifests(fileIO), manifest -> Objects.equal(manifest.snapshotId(), this.snapshotId));
        for (ManifestFile manifest2 : changedManifests) {
            try {
                ManifestReader<DeleteFile> reader = ManifestFiles.readDeleteManifest(manifest2, fileIO, null);
                Throwable throwable = null;
                try {
                    for (ManifestEntry manifestEntry : reader.entries()) {
                        switch (manifestEntry.status()) {
                            case ADDED: {
                                adds.add((DeleteFile)((DeleteFile)manifestEntry.file()).copy());
                                break;
                            }
                            case DELETED: {
                                deletes.add((DeleteFile)((DeleteFile)manifestEntry.file()).copyWithoutStats());
                                break;
                            }
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    BaseSnapshot.$closeResource(throwable, reader);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close manifest reader", e);
            }
        }
        this.addedDeleteFiles = adds.build();
        this.removedDeleteFiles = deletes.build();
    }

    private void cacheDataFileChanges(FileIO fileIO) {
        Preconditions.checkArgument(fileIO != null, "Cannot cache data file changes: FileIO is null");
        ImmutableList.Builder adds = ImmutableList.builder();
        ImmutableList.Builder deletes = ImmutableList.builder();
        Iterable<ManifestFile> changedManifests = Iterables.filter(this.dataManifests(fileIO), manifest -> Objects.equal(manifest.snapshotId(), this.snapshotId));
        try (CloseableIterable<ManifestEntry<DataFile>> entries = new ManifestGroup(fileIO, changedManifests).ignoreExisting().entries();){
            block11: for (ManifestEntry manifestEntry : entries) {
                switch (manifestEntry.status()) {
                    case ADDED: {
                        adds.add((DataFile)((DataFile)manifestEntry.file()).copy());
                        continue block11;
                    }
                    case DELETED: {
                        deletes.add((DataFile)((DataFile)manifestEntry.file()).copyWithoutStats());
                        continue block11;
                    }
                }
                throw new IllegalStateException("Unexpected entry status, not added or deleted: " + manifestEntry);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to close entries while caching changes", new Object[0]);
        }
        this.addedDataFiles = adds.build();
        this.removedDataFiles = deletes.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BaseSnapshot) {
            BaseSnapshot other = (BaseSnapshot)o;
            return this.snapshotId == other.snapshotId() && Objects.equal(this.parentId, other.parentId()) && this.sequenceNumber == other.sequenceNumber() && this.timestampMillis == other.timestampMillis() && Objects.equal(this.schemaId, other.schemaId());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.snapshotId, this.parentId, this.sequenceNumber, this.timestampMillis, this.schemaId);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.snapshotId).add("timestamp_ms", this.timestampMillis).add("operation", this.operation).add("summary", this.summary).add("manifest-list", this.manifestListLocation).add("schema-id", this.schemaId).toString();
    }
}

