/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Set;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.MergingSnapshotProducer;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;

class BaseRewriteFiles
extends MergingSnapshotProducer<RewriteFiles>
implements RewriteFiles {
    private final Set<DataFile> replacedDataFiles = Sets.newHashSet();
    private Long startingSnapshotId = null;

    BaseRewriteFiles(String tableName, TableOperations ops) {
        super(tableName, ops);
        this.failMissingDeletePaths();
    }

    @Override
    protected RewriteFiles self() {
        return this;
    }

    @Override
    protected String operation() {
        return "replace";
    }

    private void verifyInputAndOutputFiles(Set<DataFile> dataFilesToDelete, Set<DeleteFile> deleteFilesToDelete, Set<DataFile> dataFilesToAdd, Set<DeleteFile> deleteFilesToAdd) {
        Preconditions.checkNotNull(dataFilesToDelete, "Data files to delete can not be null");
        Preconditions.checkNotNull(deleteFilesToDelete, "Delete files to delete can not be null");
        Preconditions.checkNotNull(dataFilesToAdd, "Data files to add can not be null");
        Preconditions.checkNotNull(deleteFilesToAdd, "Delete files to add can not be null");
        int filesToDelete = 0;
        filesToDelete += dataFilesToDelete.size();
        Preconditions.checkArgument((filesToDelete += deleteFilesToDelete.size()) > 0, "Files to delete cannot be null or empty");
        if (deleteFilesToDelete.isEmpty()) {
            Preconditions.checkArgument(deleteFilesToAdd.isEmpty(), "Delete files to add must be empty because there's no delete file to be rewritten");
        }
    }

    @Override
    public RewriteFiles rewriteFiles(Set<DataFile> filesToDelete, Set<DataFile> filesToAdd, long sequenceNumber) {
        this.setNewFilesSequenceNumber(sequenceNumber);
        return this.rewriteFiles(filesToDelete, ImmutableSet.of(), filesToAdd, ImmutableSet.of());
    }

    @Override
    public RewriteFiles rewriteFiles(Set<DataFile> dataFilesToReplace, Set<DeleteFile> deleteFilesToReplace, Set<DataFile> dataFilesToAdd, Set<DeleteFile> deleteFilesToAdd) {
        this.verifyInputAndOutputFiles(dataFilesToReplace, deleteFilesToReplace, dataFilesToAdd, deleteFilesToAdd);
        this.replacedDataFiles.addAll(dataFilesToReplace);
        for (DataFile dataFile : dataFilesToReplace) {
            this.delete(dataFile);
        }
        for (DeleteFile deleteFile : deleteFilesToReplace) {
            this.delete(deleteFile);
        }
        for (DataFile dataFile : dataFilesToAdd) {
            this.add(dataFile);
        }
        for (DeleteFile deleteFile : deleteFilesToAdd) {
            this.add(deleteFile);
        }
        return this;
    }

    @Override
    public RewriteFiles validateFromSnapshot(long snapshotId) {
        this.startingSnapshotId = snapshotId;
        return this;
    }

    @Override
    protected void validate(TableMetadata base, Snapshot snapshot) {
        if (this.replacedDataFiles.size() > 0) {
            this.validateNoNewDeletesForDataFiles(base, this.startingSnapshotId, this.replacedDataFiles);
        }
    }
}

