/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.DiscriminatorMapping;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.DeltaLakeTable;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.Namespace;

@Schema(type=SchemaType.OBJECT, title="Content", oneOf={IcebergTable.class, DeltaLakeTable.class, IcebergView.class, Namespace.class}, discriminatorMapping={@DiscriminatorMapping(value="ICEBERG_TABLE", schema=IcebergTable.class), @DiscriminatorMapping(value="DELTA_LAKE_TABLE", schema=DeltaLakeTable.class), @DiscriminatorMapping(value="ICEBERG_VIEW", schema=IcebergView.class), @DiscriminatorMapping(value="NAMESPACE", schema=Namespace.class)}, discriminatorProperty="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=IcebergTable.class), @JsonSubTypes.Type(value=DeltaLakeTable.class), @JsonSubTypes.Type(value=IcebergView.class), @JsonSubTypes.Type(value=Namespace.class)})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public abstract class Content {
    @Nullable
    public abstract String getId();

    @JsonIgnore
    @Value.Redacted
    public abstract Type getType();

    public <T> Optional<T> unwrap(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        if (clazz.isAssignableFrom(this.getClass())) {
            return Optional.of(clazz.cast(this));
        }
        return Optional.empty();
    }

    public static enum Type {
        UNKNOWN,
        ICEBERG_TABLE,
        DELTA_LAKE_TABLE,
        ICEBERG_VIEW,
        NAMESPACE;

    }
}

