/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.Literals;
import org.apache.iceberg.expressions.NamedReference;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.expressions.UnboundTransform;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Types;

public class ExpressionUtil {
    private static final Transform<CharSequence, Integer> HASH_FUNC = Transforms.bucket(Types.StringType.get(), Integer.MAX_VALUE);
    private static final Pattern DATE = Pattern.compile("\\d\\d\\d\\d-\\d\\d-\\d\\d");
    private static final Pattern TIME = Pattern.compile("\\d\\d:\\d\\d(:\\d\\d(.\\d{1,6})?)?");
    private static final Pattern TIMESTAMP = Pattern.compile("\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d(:\\d\\d(.\\d{1,6})?)?([-+]\\d\\d:\\d\\d)?");

    private ExpressionUtil() {
    }

    public static Expression sanitize(Expression expr) {
        return ExpressionVisitors.visit(expr, ExpressionSanitizer.INSTANCE);
    }

    public static String toSanitizedString(Expression expr) {
        return ExpressionVisitors.visit(expr, StringSanitizer.INSTANCE);
    }

    public static boolean equivalent(Expression left, Expression right, Types.StructType struct, boolean caseSensitive) {
        return Binder.bind(struct, Expressions.rewriteNot(left), caseSensitive).isEquivalentTo(Binder.bind(struct, Expressions.rewriteNot(right), caseSensitive));
    }

    public static boolean selectsPartitions(Expression expr, PartitionSpec spec, boolean caseSensitive) {
        return ExpressionUtil.equivalent(Projections.inclusive(spec, caseSensitive).project(expr), Projections.strict(spec, caseSensitive).project(expr), spec.partitionType(), caseSensitive);
    }

    private static String sanitize(Literal<?> literal) {
        if (literal instanceof Literals.StringLiteral) {
            CharSequence value = (CharSequence)((Literals.StringLiteral)literal).value();
            if (DATE.matcher(value).matches()) {
                return "(date)";
            }
            if (TIME.matcher(value).matches()) {
                return "(time)";
            }
            if (TIMESTAMP.matcher(value).matches()) {
                return "(timestamp)";
            }
            return ExpressionUtil.sanitizeString(value);
        }
        if (literal instanceof Literals.DateLiteral) {
            return "(date)";
        }
        if (literal instanceof Literals.TimeLiteral) {
            return "(time)";
        }
        if (literal instanceof Literals.TimestampLiteral) {
            return "(timestamp)";
        }
        if (literal instanceof Literals.IntegerLiteral) {
            return ExpressionUtil.sanitizeNumber((Number)((Literals.IntegerLiteral)literal).value(), "int");
        }
        if (literal instanceof Literals.LongLiteral) {
            return ExpressionUtil.sanitizeNumber((Number)((Literals.LongLiteral)literal).value(), "int");
        }
        if (literal instanceof Literals.FloatLiteral) {
            return ExpressionUtil.sanitizeNumber((Number)((Literals.FloatLiteral)literal).value(), "float");
        }
        if (literal instanceof Literals.DoubleLiteral) {
            return ExpressionUtil.sanitizeNumber((Number)((Literals.DoubleLiteral)literal).value(), "float");
        }
        return ExpressionUtil.sanitizeString(literal.value().toString());
    }

    private static String sanitizeNumber(Number value, String type) {
        int numDigits = (int)Math.log10(value.doubleValue()) + 1;
        return "(" + numDigits + "-digit-" + type + ")";
    }

    private static String sanitizeString(CharSequence value) {
        return String.format("(hash-%08x)", HASH_FUNC.apply(value));
    }

    private static class StringSanitizer
    extends ExpressionVisitors.ExpressionVisitor<String> {
        private static final StringSanitizer INSTANCE = new StringSanitizer();

        private StringSanitizer() {
        }

        @Override
        public String alwaysTrue() {
            return "true";
        }

        @Override
        public String alwaysFalse() {
            return "false";
        }

        @Override
        public String not(String result) {
            return "NOT (" + result + ")";
        }

        @Override
        public String and(String leftResult, String rightResult) {
            return "(" + leftResult + " AND " + rightResult + ")";
        }

        @Override
        public String or(String leftResult, String rightResult) {
            return "(" + leftResult + " OR " + rightResult + ")";
        }

        @Override
        public <T> String predicate(BoundPredicate<T> pred) {
            throw new UnsupportedOperationException("Cannot sanitize bound predicate: " + pred);
        }

        public String termToString(UnboundTerm<?> term) {
            if (term instanceof UnboundTransform) {
                return ((UnboundTransform)term).transform() + "(" + this.termToString(term.ref()) + ")";
            }
            if (term instanceof NamedReference) {
                return ((NamedReference)term).name();
            }
            throw new UnsupportedOperationException("Unsupported term: " + term);
        }

        @Override
        public <T> String predicate(UnboundPredicate<T> pred) {
            String term = this.termToString((UnboundTerm)pred.term());
            switch (pred.op()) {
                case IS_NULL: {
                    return term + " IS NULL";
                }
                case NOT_NULL: {
                    return term + " IS NOT NULL";
                }
                case IS_NAN: {
                    return "is_nan(" + term + ")";
                }
                case NOT_NAN: {
                    return "not_nan(" + term + ")";
                }
                case LT: {
                    return term + " < " + ExpressionUtil.sanitize(pred.literal());
                }
                case LT_EQ: {
                    return term + " <= " + ExpressionUtil.sanitize(pred.literal());
                }
                case GT: {
                    return term + " > " + ExpressionUtil.sanitize(pred.literal());
                }
                case GT_EQ: {
                    return term + " >= " + ExpressionUtil.sanitize(pred.literal());
                }
                case EQ: {
                    return term + " = " + ExpressionUtil.sanitize(pred.literal());
                }
                case NOT_EQ: {
                    return term + " != " + ExpressionUtil.sanitize(pred.literal());
                }
                case IN: {
                    return term + " IN " + pred.literals().stream().map(x$0 -> ExpressionUtil.sanitize(x$0)).collect(Collectors.joining(", ", "(", ")"));
                }
                case NOT_IN: {
                    return term + " NOT IN " + pred.literals().stream().map(x$0 -> ExpressionUtil.sanitize(x$0)).collect(Collectors.joining(", ", "(", ")"));
                }
                case STARTS_WITH: {
                    return term + " STARTS WITH " + ExpressionUtil.sanitize(pred.literal());
                }
                case NOT_STARTS_WITH: {
                    return term + " NOT STARTS WITH " + ExpressionUtil.sanitize(pred.literal());
                }
            }
            throw new UnsupportedOperationException("Cannot sanitize unsupported predicate type: " + (Object)((Object)pred.op()));
        }
    }

    private static class ExpressionSanitizer
    extends ExpressionVisitors.ExpressionVisitor<Expression> {
        private static final ExpressionSanitizer INSTANCE = new ExpressionSanitizer();

        private ExpressionSanitizer() {
        }

        @Override
        public Expression alwaysTrue() {
            return Expressions.alwaysTrue();
        }

        @Override
        public Expression alwaysFalse() {
            return Expressions.alwaysFalse();
        }

        @Override
        public Expression not(Expression result) {
            return Expressions.not(result);
        }

        @Override
        public Expression and(Expression leftResult, Expression rightResult) {
            return Expressions.and(leftResult, rightResult);
        }

        @Override
        public Expression or(Expression leftResult, Expression rightResult) {
            return Expressions.or(leftResult, rightResult);
        }

        @Override
        public <T> Expression predicate(BoundPredicate<T> pred) {
            throw new UnsupportedOperationException("Cannot sanitize bound predicate: " + pred);
        }

        @Override
        public <T> Expression predicate(UnboundPredicate<T> pred) {
            switch (pred.op()) {
                case IS_NULL: 
                case NOT_NULL: 
                case IS_NAN: 
                case NOT_NAN: {
                    return pred;
                }
                case LT: 
                case LT_EQ: 
                case GT: 
                case GT_EQ: 
                case EQ: 
                case NOT_EQ: 
                case STARTS_WITH: 
                case NOT_STARTS_WITH: {
                    return new UnboundPredicate<String>(pred.op(), (UnboundTerm)pred.term(), ExpressionUtil.sanitize(pred.literal()));
                }
                case IN: 
                case NOT_IN: {
                    Iterable iter = () -> pred.literals().stream().map(x$0 -> ExpressionUtil.sanitize(x$0)).iterator();
                    return new UnboundPredicate(pred.op(), (UnboundTerm)pred.term(), iter);
                }
            }
            throw new UnsupportedOperationException("Cannot sanitize unsupported predicate type: " + (Object)((Object)pred.op()));
        }
    }
}

