/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.actions.BaseFileGroupRewriteResult;
import org.apache.iceberg.actions.RewriteDataFiles;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class RewriteFileGroup {
    private final RewriteDataFiles.FileGroupInfo info;
    private final List<FileScanTask> fileScanTasks;
    private Set<DataFile> addedFiles = Collections.emptySet();

    public RewriteFileGroup(RewriteDataFiles.FileGroupInfo info, List<FileScanTask> fileScanTasks) {
        this.info = info;
        this.fileScanTasks = fileScanTasks;
    }

    public RewriteDataFiles.FileGroupInfo info() {
        return this.info;
    }

    public List<FileScanTask> fileScans() {
        return this.fileScanTasks;
    }

    public void setOutputFiles(Set<DataFile> files) {
        this.addedFiles = files;
    }

    public Set<DataFile> rewrittenFiles() {
        return this.fileScans().stream().map(ContentScanTask::file).collect(Collectors.toSet());
    }

    public Set<DataFile> addedFiles() {
        return this.addedFiles;
    }

    public RewriteDataFiles.FileGroupRewriteResult asResult() {
        Preconditions.checkState(this.addedFiles != null, "Cannot get result, Group was never rewritten");
        return new BaseFileGroupRewriteResult(this.info, this.addedFiles.size(), this.fileScanTasks.size());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("info", this.info).add("numRewrittenFiles", this.fileScanTasks.size()).add("numAddedFiles", this.addedFiles == null ? "Rewrite Incomplete" : Integer.toString(this.addedFiles.size())).toString();
    }

    public long sizeInBytes() {
        return this.fileScanTasks.stream().mapToLong(ContentScanTask::length).sum();
    }

    public int numFiles() {
        return this.fileScanTasks.size();
    }
}

