/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import org.apache.iceberg.BaseAllMetadataTableScan;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BaseMetadataTableScan;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

abstract class BaseFilesTable
extends BaseMetadataTable {
    BaseFilesTable(TableOperations ops, Table table, String name) {
        super(ops, table, name);
    }

    @Override
    public Schema schema() {
        Types.StructType partitionType = Partitioning.partitionType(this.table());
        Schema schema = new Schema(DataFile.getType(partitionType).fields());
        if (partitionType.fields().size() < 1) {
            return TypeUtil.selectNot(schema, Sets.newHashSet(102));
        }
        return schema;
    }

    private static CloseableIterable<FileScanTask> planFiles(Table table, CloseableIterable<ManifestFile> manifests, Schema tableSchema, Schema projectedSchema, TableScanContext context) {
        Expression rowFilter = context.rowFilter();
        boolean caseSensitive = context.caseSensitive();
        boolean ignoreResiduals = context.ignoreResiduals();
        LoadingCache<Integer, ManifestEvaluator> evalCache = Caffeine.newBuilder().build(specId -> {
            PartitionSpec spec = table.specs().get(specId);
            PartitionSpec transformedSpec = BaseFilesTable.transformSpec(tableSchema, spec);
            return ManifestEvaluator.forRowFilter(rowFilter, transformedSpec, caseSensitive);
        });
        CloseableIterable<ManifestFile> filteredManifests = CloseableIterable.filter(manifests, manifest -> ((ManifestEvaluator)evalCache.get(manifest.partitionSpecId())).eval((ManifestFile)manifest));
        String schemaString = SchemaParser.toJson(projectedSchema);
        String specString = PartitionSpecParser.toJson(PartitionSpec.unpartitioned());
        Expression filter = ignoreResiduals ? Expressions.alwaysTrue() : rowFilter;
        ResidualEvaluator residuals = ResidualEvaluator.unpartitioned(filter);
        return CloseableIterable.transform(filteredManifests, manifest -> new ManifestReadTask(table, (ManifestFile)manifest, projectedSchema, schemaString, specString, residuals));
    }

    static class ManifestReadTask
    extends BaseFileScanTask
    implements DataTask {
        private final FileIO io;
        private final Map<Integer, PartitionSpec> specsById;
        private final ManifestFile manifest;
        private final Schema schema;

        ManifestReadTask(Table table, ManifestFile manifest, Schema schema, String schemaString, String specString, ResidualEvaluator residuals) {
            super(DataFiles.fromManifest(manifest), null, schemaString, specString, residuals);
            this.io = table.io();
            this.specsById = Maps.newHashMap(table.specs());
            this.manifest = manifest;
            this.schema = schema;
        }

        @Override
        public CloseableIterable<StructLike> rows() {
            return CloseableIterable.transform(this.manifestEntries(), file -> (StructLike)((Object)file));
        }

        private CloseableIterable<? extends ContentFile<?>> manifestEntries() {
            switch (this.manifest.content()) {
                case DATA: {
                    return ManifestFiles.read(this.manifest, this.io, this.specsById).project(this.schema);
                }
                case DELETES: {
                    return ManifestFiles.readDeleteManifest(this.manifest, this.io, this.specsById).project(this.schema);
                }
            }
            throw new IllegalArgumentException("Unsupported manifest content type:" + (Object)((Object)this.manifest.content()));
        }

        @Override
        public Iterable<FileScanTask> split(long splitSize) {
            return ImmutableList.of(this);
        }

        @VisibleForTesting
        ManifestFile manifest() {
            return this.manifest;
        }
    }

    static abstract class BaseAllFilesTableScan
    extends BaseAllMetadataTableScan {
        protected BaseAllFilesTableScan(TableOperations ops, Table table, Schema schema, MetadataTableType tableType) {
            super(ops, table, schema, tableType);
        }

        protected BaseAllFilesTableScan(TableOperations ops, Table table, Schema schema, MetadataTableType tableType, TableScanContext context) {
            super(ops, table, schema, tableType, context);
        }

        protected abstract CloseableIterable<ManifestFile> manifests();

        @Override
        protected CloseableIterable<FileScanTask> doPlanFiles() {
            return BaseFilesTable.planFiles(this.table(), this.manifests(), this.tableSchema(), this.schema(), this.context());
        }
    }

    static abstract class BaseFilesTableScan
    extends BaseMetadataTableScan {
        protected BaseFilesTableScan(TableOperations ops, Table table, Schema schema, MetadataTableType tableType) {
            super(ops, table, schema, tableType);
        }

        protected BaseFilesTableScan(TableOperations ops, Table table, Schema schema, MetadataTableType tableType, TableScanContext context) {
            super(ops, table, schema, tableType, context);
        }

        protected abstract CloseableIterable<ManifestFile> manifests();

        @Override
        protected CloseableIterable<FileScanTask> doPlanFiles() {
            return BaseFilesTable.planFiles(this.table(), this.manifests(), this.tableSchema(), this.schema(), this.context());
        }
    }
}

