/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonFactory;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.node.ArrayNode;

public class JsonUtil {
    private static final JsonFactory FACTORY = new JsonFactory();
    private static final ObjectMapper MAPPER = new ObjectMapper(FACTORY);

    private JsonUtil() {
    }

    public static JsonFactory factory() {
        return FACTORY;
    }

    public static ObjectMapper mapper() {
        return MAPPER;
    }

    /*
     * Exception decompiling
     */
    public static String generate(ToJson toJson, boolean pretty) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T> T parse(String json, FromJson<T> parser) {
        try {
            return parser.parse(JsonUtil.mapper().readValue(json, JsonNode.class));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static int getInt(String property, JsonNode node) {
        Preconditions.checkArgument(node.has(property), "Cannot parse missing int %s", (Object)property);
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument(pNode != null && !pNode.isNull() && pNode.isNumber(), "Cannot parse %s to an integer value: %s", (Object)property, (Object)pNode);
        return pNode.asInt();
    }

    public static Integer getIntOrNull(String property, JsonNode node) {
        if (!node.hasNonNull(property)) {
            return null;
        }
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument(pNode != null && !pNode.isNull() && pNode.isIntegralNumber() && pNode.canConvertToInt(), "Cannot parse %s to an integer value: %s", (Object)property, (Object)pNode);
        return pNode.asInt();
    }

    public static Long getLongOrNull(String property, JsonNode node) {
        if (!node.hasNonNull(property)) {
            return null;
        }
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument(pNode != null && !pNode.isNull() && pNode.isIntegralNumber() && pNode.canConvertToLong(), "Cannot parse %s to a long value: %s", (Object)property, (Object)pNode);
        return pNode.asLong();
    }

    public static long getLong(String property, JsonNode node) {
        Preconditions.checkArgument(node.has(property), "Cannot parse missing long %s", (Object)property);
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument(pNode != null && !pNode.isNull() && pNode.isNumber(), "Cannot parse %s to a long value: %s", (Object)property, (Object)pNode);
        return pNode.asLong();
    }

    public static boolean getBool(String property, JsonNode node) {
        Preconditions.checkArgument(node.has(property), "Cannot parse missing boolean %s", (Object)property);
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument(pNode != null && !pNode.isNull() && pNode.isBoolean(), "Cannot parse %s to a boolean value: %s", (Object)property, (Object)pNode);
        return pNode.asBoolean();
    }

    public static String getString(String property, JsonNode node) {
        Preconditions.checkArgument(node.has(property), "Cannot parse missing string %s", (Object)property);
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument(pNode != null && !pNode.isNull() && pNode.isTextual(), "Cannot parse %s to a string value: %s", (Object)property, (Object)pNode);
        return pNode.asText();
    }

    public static String getStringOrNull(String property, JsonNode node) {
        if (!node.has(property)) {
            return null;
        }
        JsonNode pNode = node.get(property);
        if (pNode != null && pNode.isNull()) {
            return null;
        }
        Preconditions.checkArgument(pNode != null && pNode.isTextual(), "Cannot parse %s from non-string value: %s", (Object)property, (Object)pNode);
        return pNode.asText();
    }

    public static Map<String, String> getStringMap(String property, JsonNode node) {
        Preconditions.checkArgument(node.has(property), "Cannot parse missing map %s", (Object)property);
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument(pNode != null && !pNode.isNull() && pNode.isObject(), "Cannot parse %s from non-object value: %s", (Object)property, (Object)pNode);
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        Iterator<String> fields = pNode.fieldNames();
        while (fields.hasNext()) {
            String field = fields.next();
            builder.put(field, JsonUtil.getString(field, pNode));
        }
        return builder.build();
    }

    public static String[] getStringArray(JsonNode node) {
        Preconditions.checkArgument(node != null && !node.isNull() && node.isArray(), "Cannot parse string array from non-array: %s", (Object)node);
        ArrayNode arrayNode = (ArrayNode)node;
        String[] arr = new String[arrayNode.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = arrayNode.get(i).asText();
        }
        return arr;
    }

    public static List<String> getStringList(String property, JsonNode node) {
        Preconditions.checkArgument(node.has(property), "Cannot parse missing list %s", (Object)property);
        return ((ImmutableList.Builder)ImmutableList.builder().addAll((Iterator)new JsonStringArrayIterator(property, node))).build();
    }

    public static Set<String> getStringSet(String property, JsonNode node) {
        Preconditions.checkArgument(node.hasNonNull(property), "Cannot parse missing set %s", (Object)property);
        return ((ImmutableSet.Builder)ImmutableSet.builder().addAll((Iterator)new JsonStringArrayIterator(property, node))).build();
    }

    public static List<String> getStringListOrNull(String property, JsonNode node) {
        if (!node.has(property) || node.get(property).isNull()) {
            return null;
        }
        return ((ImmutableList.Builder)ImmutableList.builder().addAll((Iterator)new JsonStringArrayIterator(property, node))).build();
    }

    public static List<Integer> getIntegerList(String property, JsonNode node) {
        return ((ImmutableList.Builder)ImmutableList.builder().addAll((Iterator)new JsonIntegerArrayIterator(property, node))).build();
    }

    public static Set<Integer> getIntegerSetOrNull(String property, JsonNode node) {
        if (!node.has(property) || node.get(property).isNull()) {
            return null;
        }
        return JsonUtil.getIntegerSet(property, node);
    }

    public static Set<Integer> getIntegerSet(String property, JsonNode node) {
        return ((ImmutableSet.Builder)ImmutableSet.builder().addAll((Iterator)new JsonIntegerArrayIterator(property, node))).build();
    }

    public static Set<Long> getLongSetOrNull(String property, JsonNode node) {
        if (!node.hasNonNull(property)) {
            return null;
        }
        return ((ImmutableSet.Builder)ImmutableSet.builder().addAll((Iterator)new JsonLongArrayIterator(property, node))).build();
    }

    public static void writeIntegerFieldIf(boolean condition, String key, Integer value, JsonGenerator generator) throws IOException {
        if (condition) {
            generator.writeNumberField(key, value);
        }
    }

    public static void writeLongFieldIf(boolean condition, String key, Long value, JsonGenerator generator) throws IOException {
        if (condition) {
            generator.writeNumberField(key, value);
        }
    }

    static class JsonLongArrayIterator
    extends JsonArrayIterator<Long> {
        JsonLongArrayIterator(String property, JsonNode node) {
            super(property, node);
        }

        @Override
        Long convert(JsonNode element) {
            return element.asLong();
        }

        @Override
        void validate(JsonNode element) {
            Preconditions.checkArgument(element.isIntegralNumber() && element.canConvertToLong(), "Cannot parse long from  non-long value: %s", (Object)element);
        }
    }

    static class JsonIntegerArrayIterator
    extends JsonArrayIterator<Integer> {
        JsonIntegerArrayIterator(String property, JsonNode node) {
            super(property, node);
        }

        @Override
        Integer convert(JsonNode element) {
            return element.asInt();
        }

        @Override
        void validate(JsonNode element) {
            Preconditions.checkArgument(element.isInt(), "Cannot parse integer from non-int value: %s", (Object)element);
        }
    }

    static class JsonStringArrayIterator
    extends JsonArrayIterator<String> {
        JsonStringArrayIterator(String property, JsonNode node) {
            super(property, node);
        }

        @Override
        String convert(JsonNode element) {
            return element.asText();
        }

        @Override
        void validate(JsonNode element) {
            Preconditions.checkArgument(element.isTextual(), "Cannot parse string from non-text value: %s", (Object)element);
        }
    }

    static abstract class JsonArrayIterator<T>
    implements Iterator<T> {
        private final Iterator<JsonNode> elements;

        JsonArrayIterator(String property, JsonNode node) {
            JsonNode pNode = node.get(property);
            Preconditions.checkArgument(pNode != null && !pNode.isNull() && pNode.isArray(), "Cannot parse %s from non-array value: %s", (Object)property, (Object)pNode);
            this.elements = pNode.elements();
        }

        @Override
        public boolean hasNext() {
            return this.elements.hasNext();
        }

        @Override
        public T next() {
            JsonNode element = this.elements.next();
            this.validate(element);
            return this.convert(element);
        }

        abstract T convert(JsonNode var1);

        abstract void validate(JsonNode var1);
    }

    @FunctionalInterface
    public static interface FromJson<T> {
        public T parse(JsonNode var1);
    }

    @FunctionalInterface
    public static interface ToJson {
        public void generate(JsonGenerator var1) throws IOException;
    }
}

