/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CatalogProperties;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.Transactions;
import org.apache.iceberg.catalog.BaseSessionCatalog;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SessionCatalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hadoop.Configurable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.ResolvingFileIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.rest.ErrorHandlers;
import org.apache.iceberg.rest.HTTPClientFactory;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.RESTRequest;
import org.apache.iceberg.rest.RESTTableOperations;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.rest.ResourcePaths;
import org.apache.iceberg.rest.auth.OAuth2Util;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.responses.ConfigResponse;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.OAuthTokenResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Cache;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iceberg.util.EnvironmentUtil;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTSessionCatalog
extends BaseSessionCatalog
implements Configurable<Configuration>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(RESTSessionCatalog.class);
    private static final long MAX_REFRESH_WINDOW_MILLIS = 300000L;
    private static final long MIN_REFRESH_WAIT_MILLIS = 10L;
    private static final List<String> TOKEN_PREFERENCE_ORDER = ImmutableList.of("urn:ietf:params:oauth:token-type:id_token", "urn:ietf:params:oauth:token-type:access_token", "urn:ietf:params:oauth:token-type:jwt", "urn:ietf:params:oauth:token-type:saml2", "urn:ietf:params:oauth:token-type:saml1");
    private final Function<Map<String, String>, RESTClient> clientBuilder;
    private Cache<String, OAuth2Util.AuthSession> sessions = null;
    private OAuth2Util.AuthSession catalogAuth = null;
    private boolean refreshAuthByDefault = false;
    private RESTClient client = null;
    private ResourcePaths paths = null;
    private Object conf = null;
    private FileIO io = null;
    private volatile ScheduledExecutorService refreshExecutor = null;

    public RESTSessionCatalog() {
        this(new HTTPClientFactory());
    }

    RESTSessionCatalog(Function<Map<String, String>, RESTClient> clientBuilder) {
        this.clientBuilder = clientBuilder;
    }

    @Override
    public void initialize(String name, Map<String, String> unresolved) {
        ConfigResponse config;
        OAuthTokenResponse authResponse;
        Preconditions.checkArgument(unresolved != null, "Invalid configuration: null");
        Map<String, String> props = EnvironmentUtil.resolveAll(unresolved);
        long startTimeMillis = System.currentTimeMillis();
        String initToken = props.get("token");
        try (RESTClient initClient = this.clientBuilder.apply(props);){
            Map<String, String> initHeaders = RESTUtil.merge(RESTSessionCatalog.configHeaders(props), OAuth2Util.authHeaders(initToken));
            String credential = props.get("credential");
            if (credential != null && !credential.isEmpty()) {
                String scope = props.getOrDefault("scope", "catalog");
                authResponse = OAuth2Util.fetchToken(initClient, initHeaders, credential, scope);
                config = RESTSessionCatalog.fetchConfig(initClient, RESTUtil.merge(initHeaders, OAuth2Util.authHeaders(authResponse.token())));
            } else {
                authResponse = null;
                config = RESTSessionCatalog.fetchConfig(initClient, initHeaders);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close HTTP client", e);
        }
        Map<String, String> mergedProps = config.merge(props);
        Map<String, String> baseHeaders = RESTSessionCatalog.configHeaders(mergedProps);
        this.catalogAuth = new OAuth2Util.AuthSession(baseHeaders, null, null);
        if (authResponse != null) {
            this.catalogAuth = this.newSession(authResponse, startTimeMillis, this.catalogAuth);
        } else if (initToken != null) {
            this.catalogAuth = this.newSession(initToken, this.expiresInMs(mergedProps), this.catalogAuth);
        }
        this.sessions = RESTSessionCatalog.newSessionCache(mergedProps);
        this.refreshAuthByDefault = PropertyUtil.propertyAsBoolean(mergedProps, "auth.default-refresh-enabled", false);
        this.client = this.clientBuilder.apply(mergedProps);
        this.paths = ResourcePaths.forCatalogProperties(mergedProps);
        String ioImpl = mergedProps.get("io-impl");
        this.io = CatalogUtil.loadFileIO(ioImpl != null ? ioImpl : ResolvingFileIO.class.getName(), mergedProps, this.conf);
        super.initialize(name, mergedProps);
    }

    private OAuth2Util.AuthSession session(SessionCatalog.SessionContext context) {
        return this.sessions.get(context.sessionId(), id -> this.newSession(context.credentials(), context.properties(), this.catalogAuth));
    }

    private Supplier<Map<String, String>> headers(SessionCatalog.SessionContext context) {
        return this.session(context)::headers;
    }

    @Override
    public void setConf(Configuration newConf) {
        this.conf = newConf;
    }

    @Override
    public List<TableIdentifier> listTables(SessionCatalog.SessionContext context, Namespace ns) {
        this.checkNamespaceIsValid(ns);
        ListTablesResponse response = this.client.get(this.paths.tables(ns), ListTablesResponse.class, this.headers(context), ErrorHandlers.namespaceErrorHandler());
        return response.identifiers();
    }

    @Override
    public boolean dropTable(SessionCatalog.SessionContext context, TableIdentifier identifier) {
        this.checkIdentifierIsValid(identifier);
        try {
            this.client.delete(this.paths.table(identifier), null, this.headers(context), ErrorHandlers.tableErrorHandler());
            return true;
        }
        catch (NoSuchTableException e) {
            return false;
        }
    }

    @Override
    public boolean purgeTable(SessionCatalog.SessionContext context, TableIdentifier ident) {
        throw new UnsupportedOperationException("Purge is not supported");
    }

    @Override
    public void renameTable(SessionCatalog.SessionContext context, TableIdentifier from, TableIdentifier to) {
        this.checkIdentifierIsValid(from);
        this.checkIdentifierIsValid(to);
        RenameTableRequest request = RenameTableRequest.builder().withSource(from).withDestination(to).build();
        this.client.post(this.paths.rename(), (RESTRequest)request, null, this.headers(context), ErrorHandlers.tableErrorHandler());
    }

    private LoadTableResponse loadInternal(SessionCatalog.SessionContext context, TableIdentifier identifier) {
        return this.client.get(this.paths.table(identifier), LoadTableResponse.class, this.headers(context), ErrorHandlers.tableErrorHandler());
    }

    @Override
    public Table loadTable(SessionCatalog.SessionContext context, TableIdentifier identifier) {
        MetadataTableType metadataType;
        TableIdentifier loadedIdent;
        LoadTableResponse response;
        this.checkIdentifierIsValid(identifier);
        try {
            response = this.loadInternal(context, identifier);
            loadedIdent = identifier;
            metadataType = null;
        }
        catch (NoSuchTableException original) {
            metadataType = MetadataTableType.from(identifier.name());
            if (metadataType != null) {
                TableIdentifier baseIdent = TableIdentifier.of(identifier.namespace().levels());
                try {
                    response = this.loadInternal(context, baseIdent);
                    loadedIdent = baseIdent;
                }
                catch (NoSuchTableException ignored) {
                    throw original;
                }
            }
            throw original;
        }
        OAuth2Util.AuthSession session = this.tableSession(response.config(), this.session(context));
        RESTTableOperations ops = new RESTTableOperations(this.client, this.paths.table(loadedIdent), session::headers, this.tableFileIO(response.config()), response.tableMetadata());
        BaseTable table = new BaseTable(ops, this.fullTableName(loadedIdent));
        if (metadataType != null) {
            return MetadataTableUtils.createMetadataTableInstance(table, metadataType);
        }
        return table;
    }

    @Override
    public Catalog.TableBuilder buildTable(SessionCatalog.SessionContext context, TableIdentifier identifier, Schema schema) {
        return new Builder(identifier, schema, context);
    }

    @Override
    public void invalidateTable(SessionCatalog.SessionContext context, TableIdentifier ident) {
    }

    @Override
    public Table registerTable(SessionCatalog.SessionContext context, TableIdentifier ident, String metadataFileLocation) {
        throw new UnsupportedOperationException("Register table is not supported");
    }

    @Override
    public void createNamespace(SessionCatalog.SessionContext context, Namespace namespace, Map<String, String> metadata) {
        CreateNamespaceRequest request = CreateNamespaceRequest.builder().withNamespace(namespace).setProperties(metadata).build();
        this.client.post(this.paths.namespaces(), (RESTRequest)request, CreateNamespaceResponse.class, this.headers(context), ErrorHandlers.namespaceErrorHandler());
    }

    @Override
    public List<Namespace> listNamespaces(SessionCatalog.SessionContext context, Namespace namespace) {
        ImmutableMap<Object, Object> queryParams = namespace.isEmpty() ? ImmutableMap.of() : ImmutableMap.of("parent", RESTUtil.NAMESPACE_JOINER.join(namespace.levels()));
        ListNamespacesResponse response = this.client.get(this.paths.namespaces(), queryParams, ListNamespacesResponse.class, this.headers(context), ErrorHandlers.namespaceErrorHandler());
        return response.namespaces();
    }

    @Override
    public Map<String, String> loadNamespaceMetadata(SessionCatalog.SessionContext context, Namespace ns) {
        this.checkNamespaceIsValid(ns);
        GetNamespaceResponse response = this.client.get(this.paths.namespace(ns), GetNamespaceResponse.class, this.headers(context), ErrorHandlers.namespaceErrorHandler());
        return response.properties();
    }

    @Override
    public boolean dropNamespace(SessionCatalog.SessionContext context, Namespace ns) {
        this.checkNamespaceIsValid(ns);
        try {
            this.client.delete(this.paths.namespace(ns), null, this.headers(context), ErrorHandlers.namespaceErrorHandler());
            return true;
        }
        catch (NoSuchNamespaceException e) {
            return false;
        }
    }

    @Override
    public boolean updateNamespaceMetadata(SessionCatalog.SessionContext context, Namespace ns, Map<String, String> updates, Set<String> removals) {
        this.checkNamespaceIsValid(ns);
        UpdateNamespacePropertiesRequest request = UpdateNamespacePropertiesRequest.builder().updateAll(updates).removeAll(removals).build();
        UpdateNamespacePropertiesResponse response = this.client.post(this.paths.namespaceProperties(ns), (RESTRequest)request, UpdateNamespacePropertiesResponse.class, this.headers(context), ErrorHandlers.namespaceErrorHandler());
        return !response.updated().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduledExecutorService tokenRefreshExecutor() {
        if (this.refreshExecutor == null) {
            RESTSessionCatalog rESTSessionCatalog = this;
            synchronized (rESTSessionCatalog) {
                if (this.refreshExecutor == null) {
                    this.refreshExecutor = ThreadPools.newScheduledPool(this.name() + "-token-refresh", 1);
                }
            }
        }
        return this.refreshExecutor;
    }

    private void scheduleTokenRefresh(OAuth2Util.AuthSession session, long startTimeMillis, long expiresIn, TimeUnit unit) {
        long expiresInMillis = unit.toMillis(expiresIn);
        long refreshWindowMillis = Math.min(expiresInMillis / 10L, 300000L);
        long waitIntervalMillis = expiresInMillis - refreshWindowMillis;
        long elapsedMillis = System.currentTimeMillis() - startTimeMillis;
        long timeToWait = Math.max(waitIntervalMillis - elapsedMillis, 10L);
        this.tokenRefreshExecutor().schedule(() -> {
            long refreshStartTime = System.currentTimeMillis();
            Pair<Integer, TimeUnit> expiration = session.refresh(this.client);
            if (expiration != null) {
                this.scheduleTokenRefresh(session, refreshStartTime, expiration.first().intValue(), expiration.second());
            }
        }, timeToWait, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() throws IOException {
        this.shutdownRefreshExecutor();
        if (this.client != null) {
            this.client.close();
        }
    }

    private void shutdownRefreshExecutor() {
        if (this.refreshExecutor != null) {
            ScheduledExecutorService service = this.refreshExecutor;
            this.refreshExecutor = null;
            List<Runnable> tasks = service.shutdownNow();
            tasks.forEach(task -> {
                if (task instanceof Future) {
                    ((Future)((Object)task)).cancel(true);
                }
            });
            try {
                if (service.awaitTermination(1L, TimeUnit.MINUTES)) {
                    LOG.warn("Timed out waiting for refresh executor to terminate");
                }
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting for refresh executor to terminate", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private static List<MetadataUpdate> createChanges(TableMetadata meta) {
        Map<String, String> properties;
        ImmutableList.Builder changes = ImmutableList.builder();
        changes.add(new MetadataUpdate.UpgradeFormatVersion(meta.formatVersion()));
        Schema schema = meta.schema();
        changes.add(new MetadataUpdate.AddSchema(schema, schema.highestFieldId()));
        changes.add(new MetadataUpdate.SetCurrentSchema(-1));
        PartitionSpec spec = meta.spec();
        if (spec != null && spec.isPartitioned()) {
            changes.add(new MetadataUpdate.AddPartitionSpec(spec));
        } else {
            changes.add(new MetadataUpdate.AddPartitionSpec(PartitionSpec.unpartitioned()));
        }
        changes.add(new MetadataUpdate.SetDefaultPartitionSpec(-1));
        SortOrder order = meta.sortOrder();
        if (order != null && order.isSorted()) {
            changes.add(new MetadataUpdate.AddSortOrder(order));
        } else {
            changes.add(new MetadataUpdate.AddSortOrder(SortOrder.unsorted()));
        }
        changes.add(new MetadataUpdate.SetDefaultSortOrder(-1));
        String location = meta.location();
        if (location != null) {
            changes.add(new MetadataUpdate.SetLocation(location));
        }
        if ((properties = meta.properties()) != null && !properties.isEmpty()) {
            changes.add(new MetadataUpdate.SetProperties(properties));
        }
        return changes.build();
    }

    private String fullTableName(TableIdentifier ident) {
        return String.format("%s.%s", this.name(), ident);
    }

    private FileIO tableFileIO(Map<String, String> config) {
        if (config.isEmpty()) {
            return this.io;
        }
        Map<String, String> fullConf = RESTUtil.merge(this.properties(), config);
        String ioImpl = fullConf.get("io-impl");
        return CatalogUtil.loadFileIO(ioImpl != null ? ioImpl : ResolvingFileIO.class.getName(), fullConf, this.conf);
    }

    private OAuth2Util.AuthSession tableSession(Map<String, String> tableConf, OAuth2Util.AuthSession parent) {
        return this.newSession(tableConf, tableConf, parent);
    }

    private static ConfigResponse fetchConfig(RESTClient client, Map<String, String> headers) {
        ConfigResponse configResponse = client.get(ResourcePaths.config(), ConfigResponse.class, headers, ErrorHandlers.defaultErrorHandler());
        configResponse.validate();
        return configResponse;
    }

    private OAuth2Util.AuthSession newSession(Map<String, String> credentials, Map<String, String> properties, OAuth2Util.AuthSession parent) {
        if (credentials != null) {
            if (credentials.containsKey("token")) {
                return this.newSession(credentials.get("token"), this.expiresInMs(properties), parent);
            }
            if (credentials.containsKey("credential")) {
                return this.newSession(credentials.get("credential"), parent);
            }
            for (String tokenType : TOKEN_PREFERENCE_ORDER) {
                if (!credentials.containsKey(tokenType)) continue;
                return this.newSession(credentials.get(tokenType), tokenType, parent);
            }
        }
        return parent;
    }

    private OAuth2Util.AuthSession newSession(String token, Long expirationMs, OAuth2Util.AuthSession parent) {
        OAuth2Util.AuthSession session = new OAuth2Util.AuthSession(parent.headers(), token, "urn:ietf:params:oauth:token-type:access_token");
        if (expirationMs != null) {
            this.scheduleTokenRefresh(session, System.currentTimeMillis(), expirationMs, TimeUnit.MILLISECONDS);
        }
        return session;
    }

    private OAuth2Util.AuthSession newSession(String token, String tokenType, OAuth2Util.AuthSession parent) {
        long startTimeMillis = System.currentTimeMillis();
        OAuthTokenResponse response = OAuth2Util.exchangeToken(this.client, parent.headers(), token, tokenType, parent.token(), parent.tokenType(), "catalog");
        return this.newSession(response, startTimeMillis, parent);
    }

    private OAuth2Util.AuthSession newSession(String credential, OAuth2Util.AuthSession parent) {
        long startTimeMillis = System.currentTimeMillis();
        OAuthTokenResponse response = OAuth2Util.fetchToken(this.client, parent.headers(), credential, "catalog");
        return this.newSession(response, startTimeMillis, parent);
    }

    private OAuth2Util.AuthSession newSession(OAuthTokenResponse response, long startTimeMillis, OAuth2Util.AuthSession parent) {
        OAuth2Util.AuthSession session = new OAuth2Util.AuthSession(parent.headers(), response.token(), response.issuedTokenType());
        if (response.expiresInSeconds() != null) {
            this.scheduleTokenRefresh(session, startTimeMillis, response.expiresInSeconds().intValue(), TimeUnit.SECONDS);
        }
        return session;
    }

    private Long expiresInMs(Map<String, String> properties) {
        if (this.refreshAuthByDefault || properties.containsKey("token-expires-in-ms")) {
            return PropertyUtil.propertyAsLong(properties, "token-expires-in-ms", 3600000L);
        }
        return null;
    }

    private void checkIdentifierIsValid(TableIdentifier tableIdentifier) {
        if (tableIdentifier.namespace().isEmpty()) {
            throw new NoSuchTableException("Invalid table identifier: %s", tableIdentifier);
        }
    }

    private void checkNamespaceIsValid(Namespace namespace) {
        if (namespace.isEmpty()) {
            throw new NoSuchNamespaceException("Invalid namespace: %s", namespace);
        }
    }

    private static Map<String, String> configHeaders(Map<String, String> properties) {
        return RESTUtil.extractPrefixMap(properties, "header.");
    }

    private static Cache<String, OAuth2Util.AuthSession> newSessionCache(Map<String, String> properties) {
        long expirationIntervalMs = PropertyUtil.propertyAsLong(properties, "auth.session-timeout-ms", CatalogProperties.AUTH_SESSION_TIMEOUT_MS_DEFAULT);
        return Caffeine.newBuilder().expireAfterAccess(Duration.ofMillis(expirationIntervalMs)).removalListener((id, auth, cause) -> auth.stopRefreshing()).build();
    }

    private class Builder
    implements Catalog.TableBuilder {
        private final TableIdentifier ident;
        private final Schema schema;
        private final SessionCatalog.SessionContext context;
        private final ImmutableMap.Builder<String, String> propertiesBuilder = ImmutableMap.builder();
        private PartitionSpec spec = null;
        private SortOrder writeOrder = null;
        private String location = null;

        private Builder(TableIdentifier ident, Schema schema, SessionCatalog.SessionContext context) {
            RESTSessionCatalog.this.checkIdentifierIsValid(ident);
            this.ident = ident;
            this.schema = schema;
            this.context = context;
        }

        @Override
        public Builder withPartitionSpec(PartitionSpec tableSpec) {
            this.spec = tableSpec;
            return this;
        }

        @Override
        public Builder withSortOrder(SortOrder tableWriteOrder) {
            this.writeOrder = tableWriteOrder;
            return this;
        }

        @Override
        public Builder withLocation(String tableLocation) {
            this.location = tableLocation;
            return this;
        }

        @Override
        public Builder withProperties(Map<String, String> props) {
            if (props != null) {
                this.propertiesBuilder.putAll(props);
            }
            return this;
        }

        @Override
        public Builder withProperty(String key, String value) {
            this.propertiesBuilder.put(key, value);
            return this;
        }

        @Override
        public Table create() {
            CreateTableRequest request = CreateTableRequest.builder().withName(this.ident.name()).withSchema(this.schema).withPartitionSpec(this.spec).withWriteOrder(this.writeOrder).withLocation(this.location).setProperties(this.propertiesBuilder.build()).build();
            LoadTableResponse response = RESTSessionCatalog.this.client.post(RESTSessionCatalog.this.paths.tables(this.ident.namespace()), (RESTRequest)request, LoadTableResponse.class, RESTSessionCatalog.this.headers(this.context), ErrorHandlers.tableErrorHandler());
            OAuth2Util.AuthSession session = RESTSessionCatalog.this.tableSession(response.config(), RESTSessionCatalog.this.session(this.context));
            RESTTableOperations ops = new RESTTableOperations(RESTSessionCatalog.this.client, RESTSessionCatalog.this.paths.table(this.ident), session::headers, RESTSessionCatalog.this.tableFileIO(response.config()), response.tableMetadata());
            return new BaseTable(ops, RESTSessionCatalog.this.fullTableName(this.ident));
        }

        @Override
        public Transaction createTransaction() {
            LoadTableResponse response = this.stageCreate();
            String fullName = RESTSessionCatalog.this.fullTableName(this.ident);
            OAuth2Util.AuthSession session = RESTSessionCatalog.this.tableSession(response.config(), RESTSessionCatalog.this.session(this.context));
            TableMetadata meta = response.tableMetadata();
            RESTTableOperations ops = new RESTTableOperations(RESTSessionCatalog.this.client, RESTSessionCatalog.this.paths.table(this.ident), session::headers, RESTSessionCatalog.this.tableFileIO(response.config()), RESTTableOperations.UpdateType.CREATE, RESTSessionCatalog.createChanges(meta), meta);
            return Transactions.createTableTransaction(fullName, ops, meta);
        }

        @Override
        public Transaction replaceTransaction() {
            LoadTableResponse response = RESTSessionCatalog.this.loadInternal(this.context, this.ident);
            String fullName = RESTSessionCatalog.this.fullTableName(this.ident);
            OAuth2Util.AuthSession session = RESTSessionCatalog.this.tableSession(response.config(), RESTSessionCatalog.this.session(this.context));
            TableMetadata base = response.tableMetadata();
            ImmutableMap<String, String> tableProperties = this.propertiesBuilder.build();
            TableMetadata replacement = base.buildReplacement(this.schema, this.spec != null ? this.spec : PartitionSpec.unpartitioned(), this.writeOrder != null ? this.writeOrder : SortOrder.unsorted(), this.location != null ? this.location : base.location(), tableProperties);
            ImmutableList.Builder changes = ImmutableList.builder();
            if (replacement.changes().stream().noneMatch(MetadataUpdate.SetCurrentSchema.class::isInstance)) {
                changes.add(new MetadataUpdate.SetCurrentSchema(replacement.currentSchemaId()));
            }
            if (replacement.changes().stream().noneMatch(MetadataUpdate.SetDefaultPartitionSpec.class::isInstance)) {
                changes.add(new MetadataUpdate.SetDefaultPartitionSpec(replacement.defaultSpecId()));
            }
            if (replacement.changes().stream().noneMatch(MetadataUpdate.SetDefaultSortOrder.class::isInstance)) {
                changes.add(new MetadataUpdate.SetDefaultSortOrder(replacement.defaultSortOrderId()));
            }
            RESTTableOperations ops = new RESTTableOperations(RESTSessionCatalog.this.client, RESTSessionCatalog.this.paths.table(this.ident), session::headers, RESTSessionCatalog.this.tableFileIO(response.config()), RESTTableOperations.UpdateType.REPLACE, (List<MetadataUpdate>)((Object)changes.build()), base);
            return Transactions.replaceTableTransaction(fullName, ops, replacement);
        }

        @Override
        public Transaction createOrReplaceTransaction() {
            try {
                return this.replaceTransaction();
            }
            catch (NoSuchTableException e) {
                return this.createTransaction();
            }
        }

        private LoadTableResponse stageCreate() {
            ImmutableMap<String, String> tableProperties = this.propertiesBuilder.build();
            CreateTableRequest request = CreateTableRequest.builder().stageCreate().withName(this.ident.name()).withSchema(this.schema).withPartitionSpec(this.spec).withWriteOrder(this.writeOrder).withLocation(this.location).setProperties(tableProperties).build();
            return RESTSessionCatalog.this.client.post(RESTSessionCatalog.this.paths.tables(this.ident.namespace()), (RESTRequest)request, LoadTableResponse.class, RESTSessionCatalog.this.headers(this.context), ErrorHandlers.tableErrorHandler());
        }
    }
}

